package com.zzsn.utility.model;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.Vector;

/**
 * 情报信息表
 * 创建人：李东亮   
 * 创建时间：2015-6-16 下午4:58:51   
 * 公司 ：郑州数能软件科技有限公司
 * @version  1.0  
 *
 */
public class Basedata implements Serializable {

	private static final Logger Log = LoggerFactory.getLogger(Basedata.class);
	private Long id;
	//processitem id
	//system_type id
	//site id
	private Long sid;
	private String title;
	private String summary;
	private String keywords;
	private String author;
	private String sourcesite;
	private String sourceaddress;
	private String type;
	private String withtagfile;
	private String publishDate;
	private String createBy;
	private String createDate;
	private String content;
	private String contentNoTag;
	private Integer isdelete;
	private Long orgId;
	private String origin;
	private String lang;
	
	
	private Vector<Double> featVector = null; // 文档特征向量
	private boolean isNormalized = false; //是否归一化 
	
	private String words;
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public String getSummary() {
		return summary;
	}
	public void setSummary(String summary) {
		this.summary = summary;
	}
	public String getKeywords() {
		return keywords;
	}
	public void setKeywords(String keywords) {
		this.keywords = keywords;
	}

	
	public String getAuthor() {
		return author;
	}
	public void setAuthor(String author) {
		this.author = author;
	}
	public String getSourcesite() {
		return sourcesite;
	}
	public void setSourcesite(String sourcesite) {
		this.sourcesite = sourcesite;
	}
	public String getSourceaddress() {
		return sourceaddress;
	}
	public void setSourceaddress(String sourceaddress) {
		this.sourceaddress = sourceaddress;
	}
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
	public String getWithtagfile() {
		return withtagfile;
	}
	public void setWithtagfile(String withtagfile) {
		this.withtagfile = withtagfile;
	}
	public String getPublishDate() {
		return publishDate;
	}
	public void setPublishDate(String publishDate) {
		this.publishDate = publishDate;
	}
	public String getCreateBy() {
		return createBy;
	}
	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}
	public String getCreateDate() {
		return createDate;
	}
	public void setCreateDate(String createDate) {
		this.createDate = createDate;
	}
	public String getContent() {
		return content;
	}
	public void setContent(String content) {
		this.content = content;
	}
	public Vector<Double> getFeatVector() {
		return featVector;
	}
	public void setFeatVector(Vector<Double> featVector) {
		this.featVector = featVector;
	}
	public boolean isNormalized() {
		return isNormalized;
	}
	public void setNormalized(boolean isNormalized) {
		this.isNormalized = isNormalized;
	}
	
	
	public double similarity(Basedata other) {
		// TODO: maybe do some caching here too?
		double dotProduct = 0;
		
		if(other.isNormalized()==false)
		{
			other.normalize();
		}
		if(isNormalized == false)
		{
			this.normalize();
		}
		
		for (int i = 0; i < featVector.size(); ++i) {
			dotProduct += featVector.get(i) * other.getFeatVector().get(i);
//			magnitude += featVector.get(i) * featVector.get(i);
//			magnitudeOther += other.getFeatVector().get(i)
//					* other.getFeatVector().get(i);
		}
		return dotProduct; // / Math.sqrt(magnitude * magnitudeOther);
	}
	
	public boolean normalize()
	{
		try
		{
			if(featVector == null)
			{
				isNormalized = false;
				return false;
			}
			double magnitude = 0;
			for (int i = 0; i < featVector.size(); ++i) {
				magnitude += featVector.get(i) * featVector.get(i);
			}
			magnitude = Math.sqrt(magnitude);
			for (int i = 0; i < featVector.size(); ++i) {
				featVector.set(i,featVector.get(i)/magnitude);
			}
			
			isNormalized = true;
			
			return true;
		}
		catch(Exception e)
		{
			Log.error("异常", e);
			isNormalized = false;
			return false;
		}
	}
	
	
	public boolean merge(Basedata other)
	{
		try
		{
			for (int i = 0; i < featVector.size(); ++i) {
				featVector.set(i, (featVector.get(i) + other.getFeatVector().get(i)) / 2);
			}
			
			normalize();
			
			return true;
		}
		catch(Exception e)
		{
			return false;
		}
	}
	
	
	public Long getSid() {
		return sid;
	}
	public void setSid(Long sid) {
		this.sid = sid;
	}

	public Integer getIsdelete() {
		return isdelete;
	}
	public void setIsdelete(Integer isdelete) {
		this.isdelete = isdelete;
	}
	public Long getOrgId() {
		return orgId;
	}
	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}
	public String getWords() {
		return words;
	}
	public void setWords(String words) {
		this.words = words;
	}
	public String getOrigin() {
		return origin;
	}
	public void setOrigin(String origin) {
		this.origin = origin;
	}
	public String getContentNoTag() {
		return contentNoTag;
	}
	public void setContentNoTag(String contentNoTag) {
		this.contentNoTag = contentNoTag;
	}
	public String getLang() {
		return lang;
	}
	public void setLang(String lang) {
		this.lang = lang;
	}


}
