/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.test.algorithm;

import com.hankcs.hanlp.collection.MDAG.MDAG;
import com.hankcs.hanlp.collection.MDAG.MDAGMap;
import com.hankcs.hanlp.corpus.io.ByteArray;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import junit.framework.TestCase;

public class MDAGUnsimplifyTest
extends TestCase {
    private static final String DATA_TEST_OUT_BIN = "data/test/out.bin";

    public void testSimplify() throws Exception {
        MDAG mdag = new MDAG();
        mdag.addString("hers");
        mdag.addString("his");
        mdag.addString("she");
        mdag.addString("he");
        DataOutputStream out = new DataOutputStream(new FileOutputStream(DATA_TEST_OUT_BIN));
        mdag.save(out);
        mdag = new MDAG();
        mdag.load(ByteArray.createByteArray(DATA_TEST_OUT_BIN));
        System.out.println(mdag.contains("his"));
    }

    public void testSimplifyWithoutSave() throws Exception {
        MDAG mdag = new MDAG();
        mdag.addString("hers");
        mdag.addString("his");
        mdag.addString("she");
        mdag.addString("he");
        mdag.simplify();
        System.out.println(mdag.contains("hers"));
    }

    public void testSimplifyMap() throws Exception {
        MDAGMap<String> mdagMap = new MDAGMap<String>();
        ArrayList<String> validKeySet = new ArrayList<String>();
        validKeySet.add("hers");
        validKeySet.add("his");
        validKeySet.add("she");
        validKeySet.add("he");
        for (String key : validKeySet) {
            mdagMap.put(key, key);
        }
        mdagMap.simplify();
        System.out.println((String)mdagMap.get("he"));
    }
}

