/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp;

import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import com.hankcs.hanlp.dependency.nnparser.NeuralNetworkDependencyParser;
import com.hankcs.hanlp.dictionary.py.Pinyin;
import com.hankcs.hanlp.dictionary.py.PinyinDictionary;
import com.hankcs.hanlp.dictionary.ts.SimplifiedChineseDictionary;
import com.hankcs.hanlp.dictionary.ts.TraditionalChineseDictionary;
import com.hankcs.hanlp.phrase.MutualInformationEntropyPhraseExtractor;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.Viterbi.ViterbiSegment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.summary.TextRankKeyword;
import com.hankcs.hanlp.summary.TextRankSentence;
import com.hankcs.hanlp.tokenizer.StandardTokenizer;
import com.hankcs.hanlp.utility.Predefine;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

public class HanLP {
    private HanLP() {
    }

    public static String convertToSimplifiedChinese(String traditionalChineseString) {
        return TraditionalChineseDictionary.convertToSimplifiedChinese(traditionalChineseString.toCharArray());
    }

    public static String convertToTraditionalChinese(String simplifiedChineseString) {
        return SimplifiedChineseDictionary.convertToTraditionalChinese(simplifiedChineseString.toCharArray());
    }

    public static String convertToPinyinString(String text, String separator, boolean remainNone) {
        List<Pinyin> pinyinList = PinyinDictionary.convertToPinyin(text, remainNone);
        int length = pinyinList.size();
        StringBuilder sb = new StringBuilder(length * (5 + separator.length()));
        int i = 1;
        for (Pinyin pinyin : pinyinList) {
            sb.append(pinyin.getPinyinWithoutTone());
            if (i < length) {
                sb.append(separator);
            }
            ++i;
        }
        return sb.toString();
    }

    public static List<Pinyin> convertToPinyinList(String text) {
        return PinyinDictionary.convertToPinyin(text);
    }

    public static String convertToPinyinFirstCharString(String text, String separator, boolean remainNone) {
        List<Pinyin> pinyinList = PinyinDictionary.convertToPinyin(text, remainNone);
        int length = pinyinList.size();
        StringBuilder sb = new StringBuilder(length * (1 + separator.length()));
        int i = 1;
        for (Pinyin pinyin : pinyinList) {
            sb.append(pinyin.getFirstChar());
            if (i < length) {
                sb.append(separator);
            }
            ++i;
        }
        return sb.toString();
    }

    public static List<Term> segment(String text) {
        return StandardTokenizer.segment(text.toCharArray());
    }

    public static Segment newSegment() {
        return new ViterbiSegment();
    }

    public static CoNLLSentence parseDependency(String sentence) {
        return NeuralNetworkDependencyParser.compute(sentence);
    }

    public static List<String> extractPhrase(String text, int size) {
        MutualInformationEntropyPhraseExtractor extractor = new MutualInformationEntropyPhraseExtractor();
        return extractor.extractPhrase(text, size);
    }

    public static List<String> extractKeyword(String document, int size) {
        return TextRankKeyword.getKeywordList(document, size);
    }

    public static List<String> extractSummary(String document, int size) {
        return TextRankSentence.getTopSentenceList(document, size);
    }

    public static String getSummary(String document, int max_length) {
        return TextRankSentence.getSummary(document, max_length);
    }

    public static final class Config {
        public static boolean DEBUG;
        public static String CoreDictionaryPath;
        public static String CoreDictionaryTransformMatrixDictionaryPath;
        public static String[] CustomDictionaryPath;
        public static String BiGramDictionaryPath;
        public static String CoreStopWordDictionaryPath;
        public static String CoreSynonymDictionaryDictionaryPath;
        public static String PersonDictionaryPath;
        public static String PersonDictionaryTrPath;
        public static String PlaceDictionaryPath;
        public static String PlaceDictionaryTrPath;
        public static String OrganizationDictionaryPath;
        public static String OrganizationDictionaryTrPath;
        public static String TraditionalChineseDictionaryPath;
        public static String SYTDictionaryPath;
        public static String PinyinDictionaryPath;
        public static String TranslatedPersonDictionaryPath;
        public static String JapanesePersonDictionaryPath;
        public static String CharTypePath;
        public static String CharTablePath;
        public static String WordNatureModelPath;
        public static String MaxEntModelPath;
        public static String NNParserModelPath;
        public static String CRFSegmentModelPath;
        public static String HMMSegmentModelPath;
        public static String CRFDependencyModelPath;
        public static boolean ShowTermNature;
        public static boolean Normalization;

        /*
         * Unable to fully structure code
         */
        static {
            block10: {
                block11: {
                    Config.DEBUG = false;
                    Config.CoreDictionaryPath = "data/dictionary/CoreNatureDictionary.txt";
                    Config.CoreDictionaryTransformMatrixDictionaryPath = "data/dictionary/CoreNatureDictionary.tr.txt";
                    Config.CustomDictionaryPath = new String[]{"data/dictionary/custom/CustomDictionary.txt"};
                    Config.BiGramDictionaryPath = "data/dictionary/CoreNatureDictionary.ngram.txt";
                    Config.CoreStopWordDictionaryPath = "data/dictionary/stopwords.txt";
                    Config.CoreSynonymDictionaryDictionaryPath = "data/dictionary/synonym/CoreSynonym.txt";
                    Config.PersonDictionaryPath = "data/dictionary/person/nr.txt";
                    Config.PersonDictionaryTrPath = "data/dictionary/person/nr.tr.txt";
                    Config.PlaceDictionaryPath = "data/dictionary/place/ns.txt";
                    Config.PlaceDictionaryTrPath = "data/dictionary/place/ns.tr.txt";
                    Config.OrganizationDictionaryPath = "data/dictionary/organization/nt.txt";
                    Config.OrganizationDictionaryTrPath = "data/dictionary/organization/nt.tr.txt";
                    Config.TraditionalChineseDictionaryPath = "data/dictionary/tc/TraditionalChinese.txt";
                    Config.SYTDictionaryPath = "data/dictionary/pinyin/SYTDictionary.txt";
                    Config.PinyinDictionaryPath = "data/dictionary/pinyin/pinyin.txt";
                    Config.TranslatedPersonDictionaryPath = "data/dictionary/person/nrf.txt";
                    Config.JapanesePersonDictionaryPath = "data/dictionary/person/nrj.txt";
                    Config.CharTypePath = "data/dictionary/other/CharType.dat.yes";
                    Config.CharTablePath = "data/dictionary/other/CharTable.bin.yes";
                    Config.WordNatureModelPath = "data/model/dependency/WordNature.txt";
                    Config.MaxEntModelPath = "data/model/dependency/MaxEntModel.txt";
                    Config.NNParserModelPath = "data/model/dependency/NNParserModel.txt";
                    Config.CRFSegmentModelPath = "data/model/segment/CRFSegmentModel.txt";
                    Config.HMMSegmentModelPath = "data/model/segment/HMMSegmentModel.bin";
                    Config.CRFDependencyModelPath = "data/model/dependency/CRFDependencyModelMini.txt";
                    Config.ShowTermNature = true;
                    Config.Normalization = false;
                    p = new Properties();
                    try {
                        loader = Thread.currentThread().getContextClassLoader();
                        if (loader == null) {
                            loader = Config.class.getClassLoader();
                        }
                        p.load(new InputStreamReader(Predefine.HANLP_PROPERTIES_PATH == null ? loader.getResourceAsStream("conf/hanlp.properties") : new FileInputStream(Predefine.HANLP_PROPERTIES_PATH), "UTF-8"));
                        root = p.getProperty("root", "").replaceAll("\\\\", "/");
                        if (!root.endsWith("/")) {
                            root = String.valueOf(root) + "/";
                        }
                        Config.CoreDictionaryPath = String.valueOf(root) + p.getProperty("CoreDictionaryPath", Config.CoreDictionaryPath);
                        Config.CoreDictionaryTransformMatrixDictionaryPath = String.valueOf(root) + p.getProperty("CoreDictionaryTransformMatrixDictionaryPath", Config.CoreDictionaryTransformMatrixDictionaryPath);
                        Config.BiGramDictionaryPath = String.valueOf(root) + p.getProperty("BiGramDictionaryPath", Config.BiGramDictionaryPath);
                        Config.CoreStopWordDictionaryPath = String.valueOf(root) + p.getProperty("CoreStopWordDictionaryPath", Config.CoreStopWordDictionaryPath);
                        Config.CoreSynonymDictionaryDictionaryPath = String.valueOf(root) + p.getProperty("CoreSynonymDictionaryDictionaryPath", Config.CoreSynonymDictionaryDictionaryPath);
                        Config.PersonDictionaryPath = String.valueOf(root) + p.getProperty("PersonDictionaryPath", Config.PersonDictionaryPath);
                        Config.PersonDictionaryTrPath = String.valueOf(root) + p.getProperty("PersonDictionaryTrPath", Config.PersonDictionaryTrPath);
                        pathArray = p.getProperty("CustomDictionaryPath", "dictionary/custom/CustomDictionary.txt").split(";");
                        prePath = root;
                        i = 0;
                        while (i < pathArray.length) {
                            if (pathArray[i].startsWith(" ")) {
                                pathArray[i] = String.valueOf(prePath) + pathArray[i].trim();
                            } else {
                                pathArray[i] = String.valueOf(root) + pathArray[i];
                                lastSplash = pathArray[i].lastIndexOf(47);
                                if (lastSplash != -1) {
                                    prePath = pathArray[i].substring(0, lastSplash + 1);
                                }
                            }
                            ++i;
                        }
                        Config.CustomDictionaryPath = pathArray;
                        Config.TraditionalChineseDictionaryPath = String.valueOf(root) + p.getProperty("TraditionalChineseDictionaryPath", Config.TraditionalChineseDictionaryPath);
                        Config.SYTDictionaryPath = String.valueOf(root) + p.getProperty("SYTDictionaryPath", Config.SYTDictionaryPath);
                        Config.PinyinDictionaryPath = String.valueOf(root) + p.getProperty("PinyinDictionaryPath", Config.PinyinDictionaryPath);
                        Config.TranslatedPersonDictionaryPath = String.valueOf(root) + p.getProperty("TranslatedPersonDictionaryPath", Config.TranslatedPersonDictionaryPath);
                        Config.JapanesePersonDictionaryPath = String.valueOf(root) + p.getProperty("JapanesePersonDictionaryPath", Config.JapanesePersonDictionaryPath);
                        Config.PlaceDictionaryPath = String.valueOf(root) + p.getProperty("PlaceDictionaryPath", Config.PlaceDictionaryPath);
                        Config.PlaceDictionaryTrPath = String.valueOf(root) + p.getProperty("PlaceDictionaryTrPath", Config.PlaceDictionaryTrPath);
                        Config.OrganizationDictionaryPath = String.valueOf(root) + p.getProperty("OrganizationDictionaryPath", Config.OrganizationDictionaryPath);
                        Config.OrganizationDictionaryTrPath = String.valueOf(root) + p.getProperty("OrganizationDictionaryTrPath", Config.OrganizationDictionaryTrPath);
                        Config.CharTypePath = String.valueOf(root) + p.getProperty("CharTypePath", Config.CharTypePath);
                        Config.CharTablePath = String.valueOf(root) + p.getProperty("CharTablePath", Config.CharTablePath);
                        Config.WordNatureModelPath = String.valueOf(root) + p.getProperty("WordNatureModelPath", Config.WordNatureModelPath);
                        Config.MaxEntModelPath = String.valueOf(root) + p.getProperty("MaxEntModelPath", Config.MaxEntModelPath);
                        Config.NNParserModelPath = String.valueOf(root) + p.getProperty("NNParserModelPath", Config.NNParserModelPath);
                        Config.CRFSegmentModelPath = String.valueOf(root) + p.getProperty("CRFSegmentModelPath", Config.CRFSegmentModelPath);
                        Config.CRFDependencyModelPath = String.valueOf(root) + p.getProperty("CRFDependencyModelPath", Config.CRFDependencyModelPath);
                        Config.HMMSegmentModelPath = String.valueOf(root) + p.getProperty("HMMSegmentModelPath", Config.HMMSegmentModelPath);
                        Config.ShowTermNature = "true".equals(p.getProperty("ShowTermNature", "true"));
                        Config.Normalization = "true".equals(p.getProperty("Normalization", "false"));
                        break block10;
                    }
                    catch (Exception e) {
                        sbInfo = new StringBuilder("========Tips========\n\u8bf7\u5c06HanLP.properties\u653e\u5728\u4e0b\u5217\u76ee\u5f55\uff1a\n");
                        classPath = (String)System.getProperties().get("java.class.path");
                        if (classPath == null) break block11;
                        var7_13 = classPath.split(";");
                        var6_12 = var7_13.length;
                        var5_10 = 0;
                        ** while (var5_10 < var6_12)
                    }
lbl-1000:
                    // 1 sources

                    {
                        path = var7_13[var5_10];
                        if (new File(path).isDirectory()) {
                            sbInfo.append(path).append('\n');
                        }
                        ++var5_10;
                        continue;
                    }
                }
                sbInfo.append("Web\u9879\u76ee\u5219\u8bf7\u653e\u5230\u4e0b\u5217\u76ee\u5f55\uff1a\nWebapp/WEB-INF/lib\nWebapp/WEB-INF/classes\nAppserver/lib\nJRE/lib\n");
                sbInfo.append("\u5e76\u4e14\u7f16\u8f91root=PARENT/path/to/your/data\n");
                sbInfo.append("\u73b0\u5728HanLP\u5c06\u5c1d\u8bd5\u4ece").append(System.getProperties().get("user.dir")).append("\u8bfb\u53d6data\u2026\u2026");
                Predefine.logger.severe("\u6ca1\u6709\u627e\u5230HanLP.properties\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u627e\u4e0d\u5230data\n" + sbInfo);
            }
        }

        public static void enableDebug() {
            Config.enableDebug(true);
        }

        public static void enableDebug(boolean enable) {
            DEBUG = enable;
            if (DEBUG) {
                Predefine.logger.setLevel(Level.ALL);
            } else {
                Predefine.logger.setLevel(Level.OFF);
            }
        }
    }
}

