/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.test.dependency;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLLoader;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLSentence;
import com.hankcs.hanlp.corpus.dependency.CoNll.CoNLLWord;
import com.hankcs.hanlp.corpus.dependency.CoNll.Evaluator;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dependency.CRFDependencyParser;
import com.hankcs.hanlp.dependency.MaxEntDependencyParser;
import com.hankcs.hanlp.dependency.WordNatureDependencyParser;
import com.hankcs.hanlp.dependency.nnparser.NeuralNetworkDependencyParser;
import com.hankcs.hanlp.seg.common.Term;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;

public class TestParse
extends TestCase {
    public void testParse() throws Exception {
        LinkedList<Term> termList = new LinkedList<Term>();
        termList.add(new Term("\u575a\u51b3", Nature.ad));
        termList.add(new Term("\u60e9\u6cbb", Nature.v));
        termList.add(new Term("\u8d2a\u6c61", Nature.v));
        termList.add(new Term("\u8d3f\u8d42", Nature.n));
        termList.add(new Term("\u7b49", Nature.udeng));
        termList.add(new Term("\u7ecf\u6d4e", Nature.n));
        termList.add(new Term("\u72af\u7f6a", Nature.vn));
        System.out.println(CRFDependencyParser.compute(termList));
    }

    public void testSegAndParse() throws Exception {
        System.out.println(MaxEntDependencyParser.compute("\u6211\u559c\u6b22\u9648\u81ba\u5965"));
    }

    public void testMaxEntParser() throws Exception {
        HanLP.Config.enableDebug();
        System.out.println(MaxEntDependencyParser.compute("\u6211\u6bcf\u5929\u9a91\u8f66\u4e0a\u5b66"));
    }

    public void testCRFParser() throws Exception {
        HanLP.Config.enableDebug();
        System.out.println(CRFDependencyParser.compute("\u6211\u6bcf\u5929\u9a91\u8f66\u4e0a\u5b66"));
    }

    public void testWordNatureParser() throws Exception {
        HanLP.Config.enableDebug();
        System.out.println(WordNatureDependencyParser.compute("\u6211\u6bcf\u5929\u9a91\u8f66\u4e0a\u5b66"));
    }

    public void testNNParser() throws Exception {
        System.out.println(NeuralNetworkDependencyParser.compute("\u5f90\u5148\u751f\u8fd8\u5177\u4f53\u5e2e\u52a9\u4ed6\u786e\u5b9a\u4e86\u628a\u753b\u96c4\u9e70\u3001\u677e\u9f20\u548c\u9ebb\u96c0\u4f5c\u4e3a\u4e3b\u653b\u76ee\u6807\u3002"));
    }

    public void testNatureMap() throws Exception {
        System.out.println(true);
        String text = "\u4e8c\uff2f\u4e00\u4e8c\u5e74\u56db\u6708\u4e94\u65e5";
        List<Term> termList = NeuralNetworkDependencyParser.INSTANCE.getSegment().seg(text);
        System.out.println(termList);
        System.out.println(NeuralNetworkDependencyParser.compute(termList));
    }

    public void testCrfParser() throws Exception {
        HanLP.Config.enableDebug();
        LinkedList<Term> termList = new LinkedList<Term>();
        termList.add(new Term("\u575a\u51b3", Nature.ad));
        termList.add(new Term("\u60e9\u6cbb", Nature.v));
        termList.add(new Term("\u8d2a\u6c61", Nature.v));
        termList.add(new Term("\u8d3f\u8d42", Nature.n));
        termList.add(new Term("\u7b49", Nature.udeng));
        termList.add(new Term("\u7ecf\u6d4e", Nature.n));
        termList.add(new Term("\u72af\u7f6a", Nature.vn));
        System.out.println(CRFDependencyParser.compute(termList));
    }

    public void testEvaluate() throws Exception {
        this.testParse();
        LinkedList<CoNLLSentence> sentenceList = CoNLLLoader.loadSentenceList("D:\\Doc\\\u8bed\u6599\u5e93\\\u4f9d\u5b58\u5206\u6790\u8bad\u7ec3\u6570\u636e\\THU\\dev.conll");
        Evaluator evaluator = new Evaluator();
        int id = 1;
        for (CoNLLSentence sentence : sentenceList) {
            System.out.printf("%d / %d...", id++, sentenceList.size());
            long start = System.currentTimeMillis();
            LinkedList<Term> termList = new LinkedList<Term>();
            CoNLLWord[] coNLLWordArray = sentence.word;
            int n = sentence.word.length;
            int n2 = 0;
            while (n2 < n) {
                CoNLLWord word = coNLLWordArray[n2];
                termList.add(new Term(word.LEMMA, Nature.valueOf(word.POSTAG)));
                ++n2;
            }
            CoNLLSentence out = CRFDependencyParser.compute(termList);
            evaluator.e(sentence, out);
            System.out.println("done in " + (System.currentTimeMillis() - start) + " ms.");
        }
        System.out.println(evaluator);
    }
}

