/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.test.algorithm;

import com.hankcs.hanlp.collection.dartsclone.DartMap;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.io.IOUtil;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import junit.framework.TestCase;

public class DartMapTest
extends TestCase {
    private static final String DATA_TEST_OUT_BIN = "data/test/out.bin";
    Set<String> validKeySet;
    Set<String> invalidKeySet;
    private DartMap<Integer> dartMap;

    public void setUp() throws Exception {
        IOUtil.LineIterator iterator = new IOUtil.LineIterator("data/dictionary/CoreNatureDictionary.ngram.txt");
        this.validKeySet = new TreeSet<String>();
        while (iterator.hasNext()) {
            this.validKeySet.add(iterator.next().split("\\s")[0]);
        }
    }

    public void testGenerateInvalidKeySet() throws Exception {
        this.invalidKeySet = new TreeSet<String>();
        Random random = new Random(System.currentTimeMillis());
        while (this.invalidKeySet.size() < this.validKeySet.size()) {
            int length = random.nextInt(10) + 1;
            StringBuilder key = new StringBuilder(length);
            int i = 0;
            while (i < length) {
                key.append(random.nextInt(65535));
                ++i;
            }
            if (this.validKeySet.contains(key.toString())) continue;
            this.invalidKeySet.add(key.toString());
        }
    }

    public void testBuild() throws Exception {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (String key : this.validKeySet) {
            map.put(key, key.length());
        }
        this.dartMap = new DartMap(map);
    }

    public void testContainsAndNoteContains() throws Exception {
        this.testBuild();
        for (String key : this.validKeySet) {
            DartMapTest.assertEquals((int)key.length(), (int)this.dartMap.get(key));
        }
        this.testGenerateInvalidKeySet();
        for (String key : this.invalidKeySet) {
            DartMapTest.assertEquals(null, (Object)this.dartMap.get(key));
        }
    }

    public void testCommPrefixSearch() throws Exception {
        this.testBuild();
        System.out.println(this.dartMap.commonPrefixSearch("\u4e00\u4e3e\u4e00\u52a8"));
    }

    public void testBenchmark() throws Exception {
        this.testBuild();
        DoubleArrayTrie trie = new DoubleArrayTrie();
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (String key : this.validKeySet) {
            map.put(key, key.length());
        }
        trie.build(map);
        long start = System.currentTimeMillis();
        for (String key : this.validKeySet) {
            DartMapTest.assertEquals((int)key.length(), (int)((Integer)map.get(key)));
        }
        System.out.printf("TreeMap: %d ms\n", System.currentTimeMillis() - start);
        map = null;
        start = System.currentTimeMillis();
        for (String key : this.validKeySet) {
            DartMapTest.assertEquals((int)key.length(), (int)((Integer)trie.get(key)));
        }
        System.out.printf("DAT: %d ms\n", System.currentTimeMillis() - start);
        trie = null;
        start = System.currentTimeMillis();
        for (String key : this.validKeySet) {
            DartMapTest.assertEquals((int)key.length(), (int)this.dartMap.get(key));
        }
        System.out.printf("DAWG: %d ms\n", System.currentTimeMillis() - start);
    }
}

