/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.test.algorithm;

import com.hankcs.hanlp.algoritm.ahocorasick.trie.Emit;
import com.hankcs.hanlp.algoritm.ahocorasick.trie.Trie;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.corpus.io.IOUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import junit.framework.TestCase;

public class AhoCorasickDoubleArrayTrieTest
extends TestCase {
    public void testAC() throws Exception {
        Trie trie = new Trie();
        trie.addKeyword("hers");
        trie.addKeyword("his");
        trie.addKeyword("she");
        trie.addKeyword("he");
        Collection<Emit> emits = trie.parseText("ushers");
        System.out.println(emits);
    }

    public void testBuild() throws Exception {
        String[] keyArray;
        TreeMap<String, String> map = new TreeMap<String, String>();
        String[] stringArray = keyArray = new String[]{"hers", "his", "she", "he"};
        int n = keyArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            map.put(key, key);
            ++n2;
        }
        AhoCorasickDoubleArrayTrie<String> act = new AhoCorasickDoubleArrayTrie<String>();
        act.build(map);
        act.parseText("uhers", new AhoCorasickDoubleArrayTrie.IHit<String>(){

            @Override
            public void hit(int begin, int end, String value) {
                System.out.printf("[%d:%d]=%s\n", begin, end, value);
            }
        });
    }

    public void testDatFromFile() throws Exception {
        TreeMap<String, String> map = new TreeMap<String, String>();
        IOUtil.LineIterator iterator = new IOUtil.LineIterator("data/dictionary/CoreNatureDictionary.mini.txt");
        while (iterator.hasNext()) {
            String line = iterator.next();
            map.put(line, line);
        }
        DoubleArrayTrie<String> trie = new DoubleArrayTrie<String>();
        trie.build(map);
        for (String key : map.keySet()) {
            AhoCorasickDoubleArrayTrieTest.assertEquals((String)key, (String)((String)trie.get(key)));
        }
    }

    public void testDat() throws Exception {
        String[] keyArray;
        TreeMap<String, String> map = new TreeMap<String, String>();
        String[] stringArray = keyArray = new String[]{"hers", "his", "she", "he"};
        int n = keyArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            map.put(key, key);
            ++n2;
        }
        DoubleArrayTrie<String> trie = new DoubleArrayTrie<String>();
        trie.build(map);
        System.out.println(trie.exactMatchSearch("he"));
    }

    public void testTwoStruct() throws Exception {
    }

    public void testTwoAC() throws Exception {
        TreeMap<String, String> map = new TreeMap<String, String>();
        IOUtil.LineIterator iterator = new IOUtil.LineIterator("data/dictionary/CoreNatureDictionary.mini.txt");
        while (iterator.hasNext()) {
            String line = iterator.next().split("\\s")[0];
            map.put(line, line);
        }
        Trie trie = new Trie();
        trie.addAllKeyword(map.keySet());
        AhoCorasickDoubleArrayTrie<String> act = new AhoCorasickDoubleArrayTrie<String>();
        act.build(map);
        for (String key : map.keySet()) {
            Collection<Emit> emits = trie.parseText(key);
            HashSet<String> otherSet = new HashSet<String>();
            for (Emit emit : emits) {
                otherSet.add(String.valueOf(emit.getKeyword()) + emit.getEnd());
            }
            List entries = act.parseText(key);
            HashSet<String> mySet = new HashSet<String>();
            for (AhoCorasickDoubleArrayTrie.Hit entry : entries) {
                mySet.add(String.valueOf((String)entry.value) + (entry.end - 1));
            }
            AhoCorasickDoubleArrayTrieTest.assertEquals(otherSet, mySet);
        }
    }

    public void testSegment() throws Exception {
        TreeMap<String, String> map = new TreeMap<String, String>();
        IOUtil.LineIterator iterator = new IOUtil.LineIterator("data/dictionary/CoreNatureDictionary.txt");
        while (iterator.hasNext()) {
            String line = iterator.next().split("\\s")[0];
            map.put(line, line);
        }
        Trie trie = new Trie();
        trie.addAllKeyword(map.keySet());
        AhoCorasickDoubleArrayTrie<String> act = new AhoCorasickDoubleArrayTrie<String>();
        long timeMillis = System.currentTimeMillis();
        act.build(map);
        System.out.println("\u6784\u5efa\u8017\u65f6\uff1a" + (System.currentTimeMillis() - timeMillis) + " ms");
        LinkedList<String> lineList = IOUtil.readLineList("D:\\Doc\\\u8bed\u6599\u5e93\\\u300a\u6211\u7684\u56e2\u957f\u6211\u7684\u56e2\u300b.txt");
        timeMillis = System.currentTimeMillis();
        for (String sentence : lineList) {
            List entryList = act.parseText(sentence);
            for (AhoCorasickDoubleArrayTrie.Hit entry : entryList) {
                int end = entry.end;
                int start = entry.begin;
                AhoCorasickDoubleArrayTrieTest.assertEquals((String)sentence.substring(start, end), (String)((String)entry.value));
            }
        }
        System.out.printf("%d ms\n", System.currentTimeMillis() - timeMillis);
    }
}

