/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.bintrie.BaseNode;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.CustomDictionary;
import com.hankcs.hanlp.dictionary.other.CharTable;
import com.hankcs.hanlp.dictionary.other.CharType;
import com.hankcs.hanlp.seg.Config;
import com.hankcs.hanlp.seg.NShort.Path.AtomNode;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.SentencesUtil;
import com.hankcs.hanlp.utility.TextUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class Segment {
    protected Config config = new Config();

    protected static List<AtomNode> atomSegment(char[] charArray, int start, int end) {
        ArrayList<AtomNode> atomSegment = new ArrayList<AtomNode>();
        int pCur = start;
        StringBuilder sb = new StringBuilder();
        int[] charTypeArray = new int[end - start];
        int i = 0;
        while (i < charTypeArray.length) {
            char c = charArray[i + start];
            charTypeArray[i] = CharType.get(c);
            if (c == '.' && i + start < charArray.length - 1 && CharType.get(charArray[i + start + 1]) == 9) {
                charTypeArray[i] = 9;
            } else if (c == '.' && i + start < charArray.length - 1 && charArray[i + start + 1] >= '0' && charArray[i + start + 1] <= '9') {
                charTypeArray[i] = 5;
            } else if (charTypeArray[i] == 8) {
                charTypeArray[i] = 5;
            }
            ++i;
        }
        while (pCur < end) {
            int nCurType = charTypeArray[pCur - start];
            if (nCurType == 7 || nCurType == 10 || nCurType == 6 || nCurType == 17) {
                String single = String.valueOf(charArray[pCur]);
                if (single.length() != 0) {
                    atomSegment.add(new AtomNode(single, nCurType));
                }
                ++pCur;
                continue;
            }
            if (pCur < end - 1 && (nCurType == 5 || nCurType == 9)) {
                sb.delete(0, sb.length());
                sb.append(charArray[pCur]);
                boolean reachEnd = true;
                while (pCur < end - 1) {
                    int nNextType;
                    if ((nNextType = charTypeArray[++pCur - start]) == nCurType) {
                        sb.append(charArray[pCur]);
                        continue;
                    }
                    reachEnd = false;
                    break;
                }
                atomSegment.add(new AtomNode(sb.toString(), nCurType));
                if (!reachEnd) continue;
                ++pCur;
                continue;
            }
            atomSegment.add(new AtomNode(charArray[pCur], nCurType));
            ++pCur;
        }
        return atomSegment;
    }

    protected static List<AtomNode> simpleAtomSegment(char[] charArray, int start, int end) {
        LinkedList<AtomNode> atomNodeList = new LinkedList<AtomNode>();
        atomNodeList.add(new AtomNode(new String(charArray, start, end - start), 8));
        return atomNodeList;
    }

    protected static List<AtomNode> quickAtomSegment(char[] charArray, int start, int end) {
        LinkedList<AtomNode> atomNodeList = new LinkedList<AtomNode>();
        int offsetAtom = start;
        byte preType = CharType.get(charArray[offsetAtom]);
        while (++offsetAtom < end) {
            byte curType = CharType.get(charArray[offsetAtom]);
            if (curType != preType) {
                if (charArray[offsetAtom] == '.' && preType == 9) {
                    while (++offsetAtom < end) {
                        curType = CharType.get(charArray[offsetAtom]);
                        if (curType != 9) break;
                    }
                }
                atomNodeList.add(new AtomNode(new String(charArray, start, offsetAtom - start), (int)preType));
                start = offsetAtom;
            }
            preType = curType;
        }
        if (offsetAtom == end) {
            atomNodeList.add(new AtomNode(new String(charArray, start, offsetAtom - start), (int)preType));
        }
        return atomNodeList;
    }

    protected static List<Vertex> combineByCustomDictionary(List<Vertex> vertexList) {
        int j;
        StringBuilder sbTerm;
        CoreDictionary.Attribute value;
        int end;
        int to;
        int start;
        Vertex[] wordNet = new Vertex[vertexList.size()];
        vertexList.toArray(wordNet);
        DoubleArrayTrie<CoreDictionary.Attribute> dat = CustomDictionary.dat;
        int i = 0;
        while (i < wordNet.length) {
            int state = 1;
            if ((state = dat.transition(wordNet[i].realWord, state)) > 0) {
                start = i;
                end = to = i + 1;
                value = dat.output(state);
                while (to < wordNet.length) {
                    if ((state = dat.transition(wordNet[to].realWord, state)) < 0) break;
                    CoreDictionary.Attribute output = dat.output(state);
                    if (output != null) {
                        value = output;
                        end = to + 1;
                    }
                    ++to;
                }
                if (value != null) {
                    sbTerm = new StringBuilder();
                    j = start;
                    while (j < end) {
                        sbTerm.append(wordNet[j]);
                        wordNet[j] = null;
                        ++j;
                    }
                    wordNet[i] = new Vertex(sbTerm.toString(), value);
                    i = end - 1;
                }
            }
            ++i;
        }
        if (CustomDictionary.trie != null) {
            i = 0;
            while (i < wordNet.length) {
                BaseNode state;
                if (wordNet[i] != null && (state = CustomDictionary.trie.transition(wordNet[i].realWord.toCharArray(), 0)) != null) {
                    start = i;
                    end = to = i + 1;
                    value = (CoreDictionary.Attribute)state.getValue();
                    while (to < wordNet.length) {
                        if (wordNet[to] != null) {
                            if ((state = state.transition(wordNet[to].realWord.toCharArray(), 0)) == null) break;
                            if (state.getValue() != null) {
                                value = (CoreDictionary.Attribute)state.getValue();
                                end = to + 1;
                            }
                        }
                        ++to;
                    }
                    if (value != null) {
                        sbTerm = new StringBuilder();
                        j = start;
                        while (j < end) {
                            if (wordNet[j] != null) {
                                sbTerm.append(wordNet[j]);
                                wordNet[j] = null;
                            }
                            ++j;
                        }
                        wordNet[i] = new Vertex(sbTerm.toString(), value);
                        i = end - 1;
                    }
                }
                ++i;
            }
        }
        vertexList.clear();
        Vertex[] vertexArray = wordNet;
        int n = wordNet.length;
        int n2 = 0;
        while (n2 < n) {
            Vertex vertex = vertexArray[n2];
            if (vertex != null) {
                vertexList.add(vertex);
            }
            ++n2;
        }
        return vertexList;
    }

    protected void mergeNumberQuantifier(List<Vertex> termList, WordNet wordNetAll, Config config) {
        if (termList.size() < 4) {
            return;
        }
        StringBuilder sbQuantifier = new StringBuilder();
        ListIterator<Vertex> iterator = termList.listIterator();
        iterator.next();
        int line = 1;
        while (iterator.hasNext()) {
            Vertex pre = iterator.next();
            if (pre.hasNature(Nature.m)) {
                sbQuantifier.append(pre.realWord);
                Vertex cur = null;
                while (iterator.hasNext() && (cur = iterator.next()).hasNature(Nature.m)) {
                    sbQuantifier.append(cur.realWord);
                    iterator.remove();
                }
                if (cur != null && (cur.hasNature(Nature.q) || cur.hasNature(Nature.qv) || cur.hasNature(Nature.qt))) {
                    if (config.indexMode) {
                        wordNetAll.add(line, new Vertex(sbQuantifier.toString(), new CoreDictionary.Attribute(Nature.m)));
                    }
                    sbQuantifier.append(cur.realWord);
                    pre.attribute = new CoreDictionary.Attribute(Nature.mq);
                    pre.wordID = -1;
                    iterator.remove();
                }
                if (sbQuantifier.length() != pre.realWord.length()) {
                    pre.realWord = sbQuantifier.toString();
                    sbQuantifier.setLength(0);
                }
            }
            sbQuantifier.setLength(0);
            line += pre.realWord.length();
        }
    }

    public List<Term> seg(String text) {
        char[] charArray = text.toCharArray();
        if (HanLP.Config.Normalization) {
            CharTable.normalization(charArray);
        }
        if (this.config.threadNumber > 1 && charArray.length > 10000) {
            int n;
            int from;
            List<String> sentenceList = SentencesUtil.toSentenceList(charArray);
            String[] sentenceArray = new String[sentenceList.size()];
            sentenceList.toArray(sentenceArray);
            List[] termListArray = new List[sentenceArray.length];
            int per = sentenceArray.length / this.config.threadNumber;
            WorkThread[] threadArray = new WorkThread[this.config.threadNumber];
            int i = 0;
            while (i < this.config.threadNumber - 1) {
                from = i * per;
                threadArray[i] = new WorkThread(sentenceArray, termListArray, from, from + per);
                threadArray[i].start();
                ++i;
            }
            threadArray[this.config.threadNumber - 1] = new WorkThread(sentenceArray, termListArray, (this.config.threadNumber - 1) * per, sentenceArray.length);
            threadArray[this.config.threadNumber - 1].start();
            try {
                WorkThread[] workThreadArray = threadArray;
                n = threadArray.length;
                from = 0;
                while (from < n) {
                    WorkThread thread = workThreadArray[from];
                    thread.join();
                    ++from;
                }
            }
            catch (InterruptedException e) {
                Predefine.logger.severe("\u7ebf\u7a0b\u540c\u6b65\u5f02\u5e38\uff1a" + TextUtility.exceptionToString(e));
                return Collections.emptyList();
            }
            LinkedList<Term> termList = new LinkedList<Term>();
            if (this.config.offset || this.config.indexMode) {
                int sentenceOffset = 0;
                int i2 = 0;
                while (i2 < sentenceArray.length) {
                    for (Term term : termListArray[i2]) {
                        term.offset += sentenceOffset;
                        termList.add(term);
                    }
                    sentenceOffset += sentenceArray[i2].length();
                    ++i2;
                }
            } else {
                List[] listArray = termListArray;
                int n2 = termListArray.length;
                n = 0;
                while (n < n2) {
                    List list = listArray[n];
                    termList.addAll(list);
                    ++n;
                }
            }
            return termList;
        }
        return this.segSentence(charArray);
    }

    public List<Term> seg(char[] text) {
        assert (text != null);
        if (HanLP.Config.Normalization) {
            CharTable.normalization(text);
        }
        return this.segSentence(text);
    }

    public List<List<Term>> seg2sentence(String text) {
        LinkedList<List<Term>> resultList = new LinkedList<List<Term>>();
        for (String sentence : SentencesUtil.toSentenceList(text)) {
            resultList.add(this.segSentence(sentence.toCharArray()));
        }
        return resultList;
    }

    protected abstract List<Term> segSentence(char[] var1);

    public Segment enableIndexMode(boolean enable) {
        this.config.indexMode = enable;
        return this;
    }

    public Segment enablePartOfSpeechTagging(boolean enable) {
        this.config.speechTagging = enable;
        return this;
    }

    public Segment enableNameRecognize(boolean enable) {
        this.config.nameRecognize = enable;
        this.config.updateNerConfig();
        return this;
    }

    public Segment enablePlaceRecognize(boolean enable) {
        this.config.placeRecognize = enable;
        this.config.updateNerConfig();
        return this;
    }

    public Segment enableOrganizationRecognize(boolean enable) {
        this.config.organizationRecognize = enable;
        this.config.updateNerConfig();
        return this;
    }

    public Segment enableCustomDictionary(boolean enable) {
        this.config.useCustomDictionary = enable;
        return this;
    }

    public Segment enableTranslatedNameRecognize(boolean enable) {
        this.config.translatedNameRecognize = enable;
        this.config.updateNerConfig();
        return this;
    }

    public Segment enableJapaneseNameRecognize(boolean enable) {
        this.config.japaneseNameRecognize = enable;
        this.config.updateNerConfig();
        return this;
    }

    public Segment enableOffset(boolean enable) {
        this.config.offset = enable;
        return this;
    }

    public Segment enableNumberQuantifierRecognize(boolean enable) {
        this.config.numberQuantifierRecognize = enable;
        return this;
    }

    public Segment enableAllNamedEntityRecognize(boolean enable) {
        this.config.nameRecognize = enable;
        this.config.japaneseNameRecognize = enable;
        this.config.translatedNameRecognize = enable;
        this.config.placeRecognize = enable;
        this.config.organizationRecognize = enable;
        this.config.updateNerConfig();
        return this;
    }

    public Segment enableMultithreading(boolean enable) {
        this.config.threadNumber = enable ? 4 : 1;
        return this;
    }

    public Segment enableMultithreading(int threadNumber) {
        this.config.threadNumber = threadNumber;
        return this;
    }

    class WorkThread
    extends Thread {
        String[] sentenceArray;
        List<Term>[] termListArray;
        int from;
        int to;

        public WorkThread(String[] sentenceArray, List<Term>[] termListArray, int from, int to) {
            this.sentenceArray = sentenceArray;
            this.termListArray = termListArray;
            this.from = from;
            this.to = to;
        }

        @Override
        public void run() {
            int i = this.from;
            while (i < this.to) {
                this.termListArray[i] = Segment.this.segSentence(this.sentenceArray[i].toCharArray());
                ++i;
            }
        }
    }
}

