/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf;

import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.ITrie;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.ICacheAble;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.model.crf.FeatureFunction;
import com.hankcs.hanlp.model.crf.FeatureTemplate;
import com.hankcs.hanlp.model.crf.Table;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CRFModel
implements ICacheAble {
    Map<String, Integer> tag2id;
    protected String[] id2tag;
    ITrie<FeatureFunction> featureFunctionTrie;
    List<FeatureTemplate> featureTemplateList;
    protected double[][] matrix;

    public CRFModel() {
        this.featureFunctionTrie = new DoubleArrayTrie<FeatureFunction>();
    }

    public CRFModel(ITrie<FeatureFunction> featureFunctionTrie) {
        this.featureFunctionTrie = featureFunctionTrie;
    }

    protected void onLoadTxtFinished() {
    }

    public static CRFModel loadTxt(String path, CRFModel instance) {
        String line;
        CRFModel CRFModel2 = instance;
        if (CRFModel2.load(ByteArray.createByteArray(String.valueOf(path) + ".bin"))) {
            return CRFModel2;
        }
        IOUtil.LineIterator lineIterator = new IOUtil.LineIterator(path);
        if (!lineIterator.hasNext()) {
            return null;
        }
        Predefine.logger.info(lineIterator.next());
        Predefine.logger.info(lineIterator.next());
        int maxid = Integer.parseInt(lineIterator.next().substring("maxid:".length()).trim());
        Predefine.logger.info(lineIterator.next());
        lineIterator.next();
        int id = 0;
        CRFModel2.tag2id = new HashMap<String, Integer>();
        while ((line = lineIterator.next()).length() != 0) {
            CRFModel2.tag2id.put(line, id);
            ++id;
        }
        CRFModel2.id2tag = new String[CRFModel2.tag2id.size()];
        int size = CRFModel2.id2tag.length;
        for (Map.Entry<String, Integer> entry : CRFModel2.tag2id.entrySet()) {
            CRFModel2.id2tag[entry.getValue().intValue()] = entry.getKey();
        }
        TreeMap<String, FeatureFunction> featureFunctionMap = new TreeMap<String, FeatureFunction>();
        LinkedList<FeatureFunction> featureFunctionList = new LinkedList<FeatureFunction>();
        CRFModel2.featureTemplateList = new LinkedList<FeatureTemplate>();
        while ((line = lineIterator.next()).length() != 0) {
            if (!"B".equals(line)) {
                FeatureTemplate featureTemplate = FeatureTemplate.create(line);
                CRFModel2.featureTemplateList.add(featureTemplate);
                continue;
            }
            CRFModel2.matrix = new double[size][size];
        }
        if (CRFModel2.matrix != null) {
            lineIterator.next();
        }
        while ((line = lineIterator.next()).length() != 0) {
            String[] args = line.split(" ", 2);
            char[] charArray = args[1].toCharArray();
            FeatureFunction featureFunction = new FeatureFunction(charArray, size);
            featureFunctionMap.put(args[1], featureFunction);
            featureFunctionList.add(featureFunction);
        }
        if (CRFModel2.matrix != null) {
            int i = 0;
            while (i < size) {
                int j = 0;
                while (j < size) {
                    CRFModel2.matrix[i][j] = Double.parseDouble(lineIterator.next());
                    ++j;
                }
                ++i;
            }
        }
        for (FeatureFunction featureFunction : featureFunctionList) {
            int i = 0;
            while (i < size) {
                featureFunction.w[i] = Double.parseDouble(lineIterator.next());
                ++i;
            }
        }
        if (lineIterator.hasNext()) {
            Predefine.logger.warning("\u6587\u672c\u8bfb\u53d6\u6709\u6b8b\u7559\uff0c\u53ef\u80fd\u4f1a\u51fa\u95ee\u9898\uff01" + path);
        }
        lineIterator.close();
        Predefine.logger.info("\u5f00\u59cb\u6784\u5efatrie\u6811");
        CRFModel2.featureFunctionTrie.build(featureFunctionMap);
        try {
            Predefine.logger.info("\u5f00\u59cb\u7f13\u5b58" + path + ".bin");
            DataOutputStream out = new DataOutputStream(new FileOutputStream(String.valueOf(path) + ".bin"));
            CRFModel2.save(out);
            out.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u5728\u7f13\u5b58" + path + ".bin" + "\u65f6\u53d1\u751f\u9519\u8bef" + TextUtility.exceptionToString(e));
        }
        CRFModel2.onLoadTxtFinished();
        return CRFModel2;
    }

    public void tag(Table table) {
        int size = table.size();
        if (size == 0) {
            return;
        }
        int tagSize = this.id2tag.length;
        double[][] net = new double[size][tagSize];
        int i = 0;
        while (i < size) {
            LinkedList<double[]> scoreList = this.computeScoreList(table, i);
            int tag = 0;
            while (tag < tagSize) {
                net[i][tag] = CRFModel.computeScore(scoreList, tag);
                ++tag;
            }
            ++i;
        }
        if (size == 1) {
            double maxScore = -1.0E10;
            int bestTag = 0;
            int tag = 0;
            while (tag < net[0].length) {
                if (net[0][tag] > maxScore) {
                    maxScore = net[0][tag];
                    bestTag = tag;
                }
                ++tag;
            }
            table.setLast(0, this.id2tag[bestTag]);
            return;
        }
        int[][] from = new int[size][tagSize];
        int i2 = 1;
        while (i2 < size) {
            int now = 0;
            while (now < tagSize) {
                double maxScore = -1.0E10;
                int pre = 0;
                while (pre < tagSize) {
                    double score = net[i2 - 1][pre] + this.matrix[pre][now] + net[i2][now];
                    if (score > maxScore) {
                        maxScore = score;
                        from[i2][now] = pre;
                    }
                    ++pre;
                }
                net[i2][now] = maxScore;
                ++now;
            }
            ++i2;
        }
        double maxScore = -1.0E10;
        int maxTag = 0;
        int tag = 0;
        while (tag < net[size - 1].length) {
            if (net[size - 1][tag] > maxScore) {
                maxScore = net[size - 1][tag];
                maxTag = tag;
            }
            ++tag;
        }
        table.setLast(size - 1, this.id2tag[maxTag]);
        maxTag = from[size - 1][maxTag];
        int i3 = size - 2;
        while (i3 > 0) {
            table.setLast(i3, this.id2tag[maxTag]);
            maxTag = from[i3][maxTag];
            --i3;
        }
        table.setLast(0, this.id2tag[maxTag]);
    }

    protected LinkedList<double[]> computeScoreList(Table table, int current) {
        LinkedList<double[]> scoreList = new LinkedList<double[]>();
        for (FeatureTemplate featureTemplate : this.featureTemplateList) {
            char[] o = featureTemplate.generateParameter(table, current);
            FeatureFunction featureFunction = this.featureFunctionTrie.get(o);
            if (featureFunction == null) continue;
            scoreList.add(featureFunction.w);
        }
        return scoreList;
    }

    protected static double computeScore(LinkedList<double[]> scoreList, int tag) {
        double score = 0.0;
        for (double[] w : scoreList) {
            score += w[tag];
        }
        return score;
    }

    @Override
    public void save(DataOutputStream out) throws Exception {
        out.writeInt(this.id2tag.length);
        String[] stringArray = this.id2tag;
        int n = this.id2tag.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            out.writeUTF(tag);
            ++n2;
        }
        FeatureFunction[] valueArray = this.featureFunctionTrie.getValueArray((FeatureFunction[])new FeatureFunction[0]);
        out.writeInt(valueArray.length);
        Object object = valueArray;
        int n3 = valueArray.length;
        n = 0;
        while (n < n3) {
            FeatureFunction featureFunction = object[n];
            featureFunction.save(out);
            ++n;
        }
        this.featureFunctionTrie.save(out);
        out.writeInt(this.featureTemplateList.size());
        for (FeatureTemplate featureTemplate : this.featureTemplateList) {
            featureTemplate.save(out);
        }
        if (this.matrix != null) {
            out.writeInt(this.matrix.length);
            object = this.matrix;
            n3 = this.matrix.length;
            int n4 = 0;
            while (n4 < n3) {
                FeatureFunction line;
                FeatureFunction featureFunction = line = object[n4];
                int n5 = ((FeatureFunction)featureFunction).length;
                int n6 = 0;
                while (n6 < n5) {
                    FeatureFunction v = featureFunction[n6];
                    out.writeDouble((double)v);
                    ++n6;
                }
                ++n4;
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public boolean load(ByteArray byteArray) {
        int i;
        int size;
        block9: {
            if (byteArray == null) {
                return false;
            }
            size = byteArray.nextInt();
            this.id2tag = new String[size];
            this.tag2id = new HashMap<String, Integer>(size);
            int i2 = 0;
            while (i2 < this.id2tag.length) {
                this.id2tag[i2] = byteArray.nextUTF();
                this.tag2id.put(this.id2tag[i2], i2);
                ++i2;
            }
            FeatureFunction[] valueArray = new FeatureFunction[byteArray.nextInt()];
            i = 0;
            while (i < valueArray.length) {
                valueArray[i] = new FeatureFunction();
                valueArray[i].load(byteArray);
                ++i;
            }
            this.featureFunctionTrie.load(byteArray, (FeatureFunction[])valueArray);
            size = byteArray.nextInt();
            this.featureTemplateList = new ArrayList<FeatureTemplate>(size);
            i = 0;
            while (i < size) {
                FeatureTemplate featureTemplate = new FeatureTemplate();
                featureTemplate.load(byteArray);
                this.featureTemplateList.add(featureTemplate);
                ++i;
            }
            size = byteArray.nextInt();
            if (size != 0) break block9;
            return true;
        }
        try {
            this.matrix = new double[size][size];
            i = 0;
            while (i < size) {
                int j = 0;
                while (j < size) {
                    this.matrix[i][j] = byteArray.nextDouble();
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Predefine.logger.warning("\u7f13\u5b58\u8f7d\u5165\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u7531\u4e8e\u7248\u672c\u53d8\u8fc1\u5e26\u6765\u7684\u4e0d\u517c\u5bb9\u3002\u5177\u4f53\u5f02\u5e38\u662f\uff1a\n" + TextUtility.exceptionToString(e));
            return false;
        }
        return true;
    }

    public static CRFModel loadTxt(String path) {
        return CRFModel.loadTxt(path, new CRFModel(new DoubleArrayTrie<FeatureFunction>()));
    }

    public static CRFModel load(String path) {
        CRFModel model = CRFModel.loadBin(String.valueOf(path) + ".bin");
        if (model != null) {
            return model;
        }
        return CRFModel.loadTxt(path, new CRFModel(new DoubleArrayTrie<FeatureFunction>()));
    }

    public static CRFModel loadBin(String path) {
        ByteArray byteArray = ByteArray.createByteArray(path);
        if (byteArray == null) {
            return null;
        }
        CRFModel model = new CRFModel();
        if (model.load(byteArray)) {
            return model;
        }
        return null;
    }

    public Integer getTagId(String tag) {
        return this.tag2id.get(tag);
    }
}

