/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.AhoCorasick;

import com.hankcs.hanlp.collection.AhoCorasick.State;
import com.hankcs.hanlp.corpus.io.ByteArray;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingDeque;

public class AhoCorasickDoubleArrayTrie<V> {
    protected int[] check;
    protected int[] base;
    int[] fail;
    int[][] output;
    protected V[] v;
    protected int[] l;
    protected int size;

    public List<Hit<V>> parseText(String text) {
        int position = 1;
        int currentState = 0;
        LinkedList<Hit<V>> collectedEmits = new LinkedList<Hit<V>>();
        int i = 0;
        while (i < text.length()) {
            currentState = this.getState(currentState, text.charAt(i));
            this.storeEmits(position, currentState, collectedEmits);
            ++position;
            ++i;
        }
        return collectedEmits;
    }

    public void parseText(String text, IHit<V> processor) {
        int position = 1;
        int currentState = 0;
        int i = 0;
        while (i < text.length()) {
            int[] hitArray = this.output[currentState = this.getState(currentState, text.charAt(i))];
            if (hitArray != null) {
                int[] nArray = hitArray;
                int n = hitArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int hit = nArray[n2];
                    processor.hit(position - this.l[hit], position, this.v[hit]);
                    ++n2;
                }
            }
            ++position;
            ++i;
        }
    }

    public void parseText(char[] text, IHit<V> processor) {
        int position = 1;
        int currentState = 0;
        char[] cArray = text;
        int n = text.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            int[] hitArray = this.output[currentState = this.getState(currentState, c)];
            if (hitArray != null) {
                int[] nArray = hitArray;
                int n3 = hitArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int hit = nArray[n4];
                    processor.hit(position - this.l[hit], position, this.v[hit]);
                    ++n4;
                }
            }
            ++position;
            ++n2;
        }
    }

    public void parseText(char[] text, IHitFull<V> processor) {
        int position = 1;
        int currentState = 0;
        char[] cArray = text;
        int n = text.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            int[] hitArray = this.output[currentState = this.getState(currentState, c)];
            if (hitArray != null) {
                int[] nArray = hitArray;
                int n3 = hitArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int hit = nArray[n4];
                    processor.hit(position - this.l[hit], position, this.v[hit], hit);
                    ++n4;
                }
            }
            ++position;
            ++n2;
        }
    }

    public void save(DataOutputStream out) throws Exception {
        out.writeInt(this.size);
        int i = 0;
        while (i < this.size) {
            out.writeInt(this.base[i]);
            out.writeInt(this.check[i]);
            out.writeInt(this.fail[i]);
            int[] output = this.output[i];
            if (output == null) {
                out.writeInt(0);
            } else {
                out.writeInt(output.length);
                int[] nArray = output;
                int n = output.length;
                int n2 = 0;
                while (n2 < n) {
                    int o = nArray[n2];
                    out.writeInt(o);
                    ++n2;
                }
            }
            ++i;
        }
        out.writeInt(this.l.length);
        int[] nArray = this.l;
        int n = this.l.length;
        int n3 = 0;
        while (n3 < n) {
            int length = nArray[n3];
            out.writeInt(length);
            ++n3;
        }
    }

    public void save(ObjectOutputStream out) throws IOException {
        out.writeObject(this.base);
        out.writeObject(this.check);
        out.writeObject(this.fail);
        out.writeObject(this.output);
        out.writeObject(this.l);
    }

    public void load(ObjectInputStream in, V[] value) throws IOException, ClassNotFoundException {
        this.base = (int[])in.readObject();
        this.check = (int[])in.readObject();
        this.fail = (int[])in.readObject();
        this.output = (int[][])in.readObject();
        this.l = (int[])in.readObject();
        this.v = value;
    }

    public boolean load(ByteArray byteArray, V[] value) {
        int length;
        if (byteArray == null) {
            return false;
        }
        this.size = byteArray.nextInt();
        this.base = new int[this.size + 65535];
        this.check = new int[this.size + 65535];
        this.fail = new int[this.size + 65535];
        this.output = new int[this.size + 65535][];
        int i = 0;
        while (i < this.size) {
            this.base[i] = byteArray.nextInt();
            this.check[i] = byteArray.nextInt();
            this.fail[i] = byteArray.nextInt();
            length = byteArray.nextInt();
            if (length != 0) {
                this.output[i] = new int[length];
                int j = 0;
                while (j < this.output[i].length) {
                    this.output[i][j] = byteArray.nextInt();
                    ++j;
                }
            }
            ++i;
        }
        length = byteArray.nextInt();
        this.l = new int[length];
        i = 0;
        while (i < this.l.length) {
            this.l[i] = byteArray.nextInt();
            ++i;
        }
        this.v = value;
        return true;
    }

    public V get(String key) {
        int index = this.exactMatchSearch(key);
        if (index >= 0) {
            return this.v[index];
        }
        return null;
    }

    public boolean set(String key, V value) {
        int index = this.exactMatchSearch(key);
        if (index >= 0) {
            this.v[index] = value;
            return true;
        }
        return false;
    }

    public V get(int index) {
        return this.v[index];
    }

    private int getState(int currentState, char character) {
        int newCurrentState = this.transitionWithRoot(currentState, character);
        while (newCurrentState == -1) {
            currentState = this.fail[currentState];
            newCurrentState = this.transitionWithRoot(currentState, character);
        }
        return newCurrentState;
    }

    private void storeEmits(int position, int currentState, List<Hit<V>> collectedEmits) {
        int[] hitArray = this.output[currentState];
        if (hitArray != null) {
            int[] nArray = hitArray;
            int n = hitArray.length;
            int n2 = 0;
            while (n2 < n) {
                int hit = nArray[n2];
                collectedEmits.add(new Hit<V>(position - this.l[hit], position, this.v[hit]));
                ++n2;
            }
        }
    }

    protected int transition(int current, char c) {
        int b = current;
        int p = b + c + 1;
        if (b != this.check[p]) {
            return -1;
        }
        b = this.base[p];
        p = b;
        return p;
    }

    protected int transitionWithRoot(int nodePos, char c) {
        int b = this.base[nodePos];
        int p = b + c + 1;
        if (b != this.check[p]) {
            if (nodePos == 0) {
                return 0;
            }
            return -1;
        }
        return p;
    }

    public void build(TreeMap<String, V> map) {
        new Builder().build(map);
    }

    private int fetch(State parent, List<Map.Entry<Integer, State>> siblings) {
        if (parent.isAcceptable()) {
            State fakeNode = new State(-(parent.getDepth() + 1));
            fakeNode.addEmit(parent.getLargestValueId());
            siblings.add(new AbstractMap.SimpleEntry<Integer, State>(0, fakeNode));
        }
        for (Map.Entry<Character, State> entry : parent.getSuccess().entrySet()) {
            siblings.add(new AbstractMap.SimpleEntry<Integer, State>(entry.getKey().charValue() + '\u0001', entry.getValue()));
        }
        return siblings.size();
    }

    public int exactMatchSearch(String key) {
        return this.exactMatchSearch(key, 0, 0, 0);
    }

    private int exactMatchSearch(String key, int pos, int len, int nodePos) {
        int p;
        if (len <= 0) {
            len = key.length();
        }
        if (nodePos <= 0) {
            nodePos = 0;
        }
        int result = -1;
        char[] keyChars = key.toCharArray();
        int b = this.base[nodePos];
        int i = pos;
        while (i < len) {
            p = b + keyChars[i] + 1;
            if (b != this.check[p]) {
                return result;
            }
            b = this.base[p];
            ++i;
        }
        p = b;
        int n = this.base[p];
        if (b == this.check[p] && n < 0) {
            result = -n - 1;
        }
        return result;
    }

    private int exactMatchSearch(char[] keyChars, int pos, int len, int nodePos) {
        int p;
        int result = -1;
        int b = this.base[nodePos];
        int i = pos;
        while (i < len) {
            p = b + keyChars[i] + 1;
            if (b != this.check[p]) {
                return result;
            }
            b = this.base[p];
            ++i;
        }
        p = b;
        int n = this.base[p];
        if (b == this.check[p] && n < 0) {
            result = -n - 1;
        }
        return result;
    }

    public int size() {
        return this.v.length;
    }

    private class Builder {
        private State rootState = new State();
        private boolean[] used;
        private int allocSize;
        private int progress;
        private int nextCheckPos;
        private int keySize;

        private Builder() {
        }

        public void build(TreeMap<String, V> map) {
            AhoCorasickDoubleArrayTrie.this.v = map.values().toArray();
            AhoCorasickDoubleArrayTrie.this.l = new int[AhoCorasickDoubleArrayTrie.this.v.length];
            Set<String> keySet = map.keySet();
            this.addAllKeyword(keySet);
            this.buildDoubleArrayTrie(keySet);
            this.used = null;
            this.constructFailureStates();
            this.rootState = null;
            this.loseWeight();
        }

        private void addKeyword(String keyword, int index) {
            State currentState = this.rootState;
            char[] cArray = keyword.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                Character character = Character.valueOf(cArray[n2]);
                currentState = currentState.addState(character);
                ++n2;
            }
            currentState.addEmit(index);
            AhoCorasickDoubleArrayTrie.this.l[index] = keyword.length();
        }

        private void addAllKeyword(Collection<String> keywordSet) {
            int i = 0;
            for (String keyword : keywordSet) {
                this.addKeyword(keyword, i++);
            }
        }

        private void constructFailureStates() {
            AhoCorasickDoubleArrayTrie.this.fail = new int[AhoCorasickDoubleArrayTrie.this.size + 1];
            AhoCorasickDoubleArrayTrie.this.fail[1] = AhoCorasickDoubleArrayTrie.this.base[0];
            AhoCorasickDoubleArrayTrie.this.output = new int[AhoCorasickDoubleArrayTrie.this.size + 1][];
            LinkedBlockingDeque<State> queue = new LinkedBlockingDeque<State>();
            for (State depthOneState : this.rootState.getStates()) {
                depthOneState.setFailure(this.rootState, AhoCorasickDoubleArrayTrie.this.fail);
                queue.add(depthOneState);
                this.constructOutput(depthOneState);
            }
            while (!queue.isEmpty()) {
                State currentState = (State)queue.remove();
                for (Character transition : currentState.getTransitions()) {
                    State targetState = currentState.nextState(transition);
                    queue.add(targetState);
                    State traceFailureState = currentState.failure();
                    while (traceFailureState.nextState(transition) == null) {
                        traceFailureState = traceFailureState.failure();
                    }
                    State newFailureState = traceFailureState.nextState(transition);
                    targetState.setFailure(newFailureState, AhoCorasickDoubleArrayTrie.this.fail);
                    targetState.addEmit(newFailureState.emit());
                    this.constructOutput(targetState);
                }
            }
        }

        private void constructOutput(State targetState) {
            Collection<Integer> emit = targetState.emit();
            if (emit == null || emit.size() == 0) {
                return;
            }
            int[] output = new int[emit.size()];
            Iterator<Integer> it = emit.iterator();
            int i = 0;
            while (i < output.length) {
                output[i] = it.next();
                ++i;
            }
            AhoCorasickDoubleArrayTrie.this.output[targetState.getIndex()] = output;
        }

        private void buildDoubleArrayTrie(Set<String> keySet) {
            this.progress = 0;
            this.keySize = keySet.size();
            this.resize(0x200000);
            AhoCorasickDoubleArrayTrie.this.base[0] = 1;
            this.nextCheckPos = 0;
            State root_node = this.rootState;
            ArrayList<Map.Entry<Integer, State>> siblings = new ArrayList<Map.Entry<Integer, State>>(root_node.getSuccess().entrySet().size());
            AhoCorasickDoubleArrayTrie.this.fetch(root_node, siblings);
            this.insert(siblings);
        }

        private int resize(int newSize) {
            int[] base2 = new int[newSize];
            int[] check2 = new int[newSize];
            boolean[] used2 = new boolean[newSize];
            if (this.allocSize > 0) {
                System.arraycopy(AhoCorasickDoubleArrayTrie.this.base, 0, base2, 0, this.allocSize);
                System.arraycopy(AhoCorasickDoubleArrayTrie.this.check, 0, check2, 0, this.allocSize);
                System.arraycopy(this.used, 0, used2, 0, this.allocSize);
            }
            AhoCorasickDoubleArrayTrie.this.base = base2;
            AhoCorasickDoubleArrayTrie.this.check = check2;
            this.used = used2;
            this.allocSize = newSize;
            return this.allocSize;
        }

        /*
         * Unable to fully structure code
         */
        private int insert(List<Map.Entry<Integer, State>> siblings) {
            begin = 0;
            pos = Math.max(siblings.get(0).getKey() + 1, this.nextCheckPos) - 1;
            nonzero_num = 0;
            first = false;
            if (this.allocSize <= pos) {
                this.resize(pos + 1);
            }
            block0: while (true) {
                if (this.allocSize <= ++pos) {
                    this.resize(pos + 1);
                }
                if (AhoCorasickDoubleArrayTrie.this.check[pos] != 0) {
                    ++nonzero_num;
                    continue;
                }
                if (!first) {
                    this.nextCheckPos = pos;
                    first = true;
                }
                if (this.allocSize <= (begin = pos - siblings.get(0).getKey()) + siblings.get(siblings.size() - 1).getKey()) {
                    l = 1.05 > 1.0 * (double)this.keySize / (double)(this.progress + 1) ? 1.05 : 1.0 * (double)this.keySize / (double)(this.progress + 1);
                    this.resize((int)((double)this.allocSize * l));
                }
                if (this.used[begin]) continue;
                i = 1;
                while (i < siblings.size()) {
                    if (AhoCorasickDoubleArrayTrie.this.check[begin + siblings.get(i).getKey()] == 0) ** break;
                    continue block0;
                    ++i;
                }
                break;
            }
            if (1.0 * (double)nonzero_num / (double)(pos - this.nextCheckPos + 1) >= 0.95) {
                this.nextCheckPos = pos;
            }
            this.used[begin] = true;
            AhoCorasickDoubleArrayTrie.this.size = AhoCorasickDoubleArrayTrie.this.size > begin + siblings.get(siblings.size() - 1).getKey() + 1 ? AhoCorasickDoubleArrayTrie.this.size : begin + siblings.get(siblings.size() - 1).getKey() + 1;
            for (Map.Entry<Integer, State> sibling : siblings) {
                AhoCorasickDoubleArrayTrie.this.check[begin + sibling.getKey().intValue()] = begin;
            }
            for (Map.Entry<Integer, State> sibling : siblings) {
                new_siblings = new ArrayList<Map.Entry<Integer, State>>(sibling.getValue().getSuccess().entrySet().size() + 1);
                if (AhoCorasickDoubleArrayTrie.access$0(AhoCorasickDoubleArrayTrie.this, sibling.getValue(), new_siblings) == 0) {
                    AhoCorasickDoubleArrayTrie.this.base[begin + sibling.getKey().intValue()] = -sibling.getValue().getLargestValueId().intValue() - 1;
                    ++this.progress;
                } else {
                    AhoCorasickDoubleArrayTrie.this.base[begin + sibling.getKey().intValue()] = h = this.insert(new_siblings);
                }
                sibling.getValue().setIndex(begin + sibling.getKey());
            }
            return begin;
        }

        private void loseWeight() {
            int[] nbase = new int[AhoCorasickDoubleArrayTrie.this.size + 65535];
            System.arraycopy(AhoCorasickDoubleArrayTrie.this.base, 0, nbase, 0, AhoCorasickDoubleArrayTrie.this.size);
            AhoCorasickDoubleArrayTrie.this.base = nbase;
            int[] ncheck = new int[AhoCorasickDoubleArrayTrie.this.size + 65535];
            System.arraycopy(AhoCorasickDoubleArrayTrie.this.check, 0, ncheck, 0, AhoCorasickDoubleArrayTrie.this.size);
            AhoCorasickDoubleArrayTrie.this.check = ncheck;
        }
    }

    private static class DebugArray {
        Map<String, String> nameValueMap = new LinkedHashMap<String, String>();

        private DebugArray() {
        }

        public void add(String name, int value) {
            String valueInMap = this.nameValueMap.get(name);
            if (valueInMap == null) {
                valueInMap = "";
            }
            valueInMap = String.valueOf(valueInMap) + " " + String.format("%5d", value);
            this.nameValueMap.put(name, valueInMap);
        }

        public String toString() {
            String text = "";
            for (Map.Entry<String, String> entry : this.nameValueMap.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                text = String.valueOf(text) + String.format("%-5s", name) + "= " + value + '\n';
            }
            return text;
        }

        public void println() {
            System.out.print(this);
        }
    }

    public class Hit<V> {
        public final int begin;
        public final int end;
        public final V value;

        public Hit(int begin, int end, V value) {
            this.begin = begin;
            this.end = end;
            this.value = value;
        }

        public String toString() {
            return String.format("[%d:%d]=%s", this.begin, this.end, this.value);
        }
    }

    public static interface IHit<V> {
        public void hit(int var1, int var2, V var3);
    }

    public static interface IHitFull<V> {
        public void hit(int var1, int var2, V var3, int var4);
    }
}

