/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.algoritm;

import com.hankcs.hanlp.dictionary.common.CommonSynonymDictionary;
import java.util.List;

public class EditDistance {
    public static long compute(List<CommonSynonymDictionary.SynonymItem> synonymItemListA, List<CommonSynonymDictionary.SynonymItem> synonymItemListB) {
        long[] arrayA = new long[synonymItemListA.size()];
        long[] arrayB = new long[synonymItemListB.size()];
        int i = 0;
        for (CommonSynonymDictionary.SynonymItem item : synonymItemListA) {
            arrayA[i++] = item.entry.id;
        }
        i = 0;
        for (CommonSynonymDictionary.SynonymItem item : synonymItemListB) {
            arrayB[i++] = item.entry.id;
        }
        return EditDistance.compute(arrayA, arrayB);
    }

    public static long compute(long[] arrayA, long[] arrayB) {
        int m = arrayA.length;
        int n = arrayB.length;
        if (m == 0 || n == 0) {
            return 0x2AAAAAAAAAAAAAAAL;
        }
        long[][] d = new long[m + 1][n + 1];
        int j = 0;
        while (j <= n) {
            d[0][j] = j;
            ++j;
        }
        int i = 0;
        while (i <= m) {
            d[i][0] = i;
            ++i;
        }
        i = 1;
        while (i <= m) {
            long ci = arrayA[i - 1];
            int j2 = 1;
            while (j2 <= n) {
                long cj = arrayB[j2 - 1];
                d[i][j2] = ci == cj ? d[i - 1][j2 - 1] : Math.min(d[i - 1][j2 - 1] + Math.abs(ci - cj), Math.min(d[i][j2 - 1] + cj, d[i - 1][j2] + ci));
                ++j2;
            }
            ++i;
        }
        return d[m][n];
    }

    public static int compute(int[] arrayA, int[] arrayB) {
        int m = arrayA.length;
        int n = arrayB.length;
        if (m == 0 || n == 0) {
            return 0x2AAAAAAA;
        }
        int[][] d = new int[m + 1][n + 1];
        int j = 0;
        while (j <= n) {
            d[0][j] = j;
            ++j;
        }
        int i = 0;
        while (i <= m) {
            d[i][0] = i;
            ++i;
        }
        i = 1;
        while (i <= m) {
            int ci = arrayA[i - 1];
            int j2 = 1;
            while (j2 <= n) {
                int cj = arrayB[j2 - 1];
                d[i][j2] = ci == cj ? d[i - 1][j2 - 1] : Math.min(d[i - 1][j2 - 1] + Math.abs(ci - cj), Math.min(d[i][j2 - 1] + cj, d[i - 1][j2] + ci));
                ++j2;
            }
            ++i;
        }
        return d[m][n];
    }

    public static int compute(String a, String b) {
        return EditDistance.ed(a, b);
    }

    public static int ed(String wrongWord, String rightWord) {
        int m = wrongWord.length();
        int n = rightWord.length();
        int[][] d = new int[m + 1][n + 1];
        int j = 0;
        while (j <= n) {
            d[0][j] = j;
            ++j;
        }
        int i = 0;
        while (i <= m) {
            d[i][0] = i;
            ++i;
        }
        i = 1;
        while (i <= m) {
            char ci = wrongWord.charAt(i - 1);
            int j2 = 1;
            while (j2 <= n) {
                char cj = rightWord.charAt(j2 - 1);
                d[i][j2] = ci == cj ? d[i - 1][j2 - 1] : (i > 1 && j2 > 1 && ci == rightWord.charAt(j2 - 2) && cj == wrongWord.charAt(i - 2) ? 1 + Math.min(d[i - 2][j2 - 2], Math.min(d[i][j2 - 1], d[i - 1][j2])) : Math.min(d[i - 1][j2 - 1] + 1, Math.min(d[i][j2 - 1] + 1, d[i - 1][j2] + 1)));
                ++j2;
            }
            ++i;
        }
        return d[m][n];
    }

    public static int compute(char[] wrongWord, char[] rightWord) {
        int m = wrongWord.length;
        int n = rightWord.length;
        int[][] d = new int[m + 1][n + 1];
        int j = 0;
        while (j <= n) {
            d[0][j] = j;
            ++j;
        }
        int i = 0;
        while (i <= m) {
            d[i][0] = i;
            ++i;
        }
        i = 1;
        while (i <= m) {
            char ci = wrongWord[i - 1];
            int j2 = 1;
            while (j2 <= n) {
                char cj = rightWord[j2 - 1];
                d[i][j2] = ci == cj ? d[i - 1][j2 - 1] : (i > 1 && j2 > 1 && ci == rightWord[j2 - 2] && cj == wrongWord[i - 2] ? 1 + Math.min(d[i - 2][j2 - 2], Math.min(d[i][j2 - 1], d[i - 1][j2])) : Math.min(d[i - 1][j2 - 1] + 1, Math.min(d[i][j2 - 1] + 1, d[i - 1][j2] + 1)));
                ++j2;
            }
            ++i;
        }
        return d[m][n];
    }
}

