/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.process.WordToSentenceProcessor;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.TypesafeMap;
import edu.stanford.nlp.util.XMLUtils;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlainTextDocumentReaderAndWriter<IN extends CoreMap>
implements DocumentReaderAndWriter<IN> {
    private static final long serialVersionUID = -2420535144980273136L;
    private static final Pattern sgml = Pattern.compile("<[^>]*>");
    private final WordToSentenceProcessor<IN> wts = new WordToSentenceProcessor(WordToSentenceProcessor.NewlineIsSentenceBreak.ALWAYS);
    private SeqClassifierFlags flags;
    private TokenizerFactory<IN> tokenizerFactory;

    @Override
    public void init(SeqClassifierFlags flags) {
        TokenizerFactory factory;
        String options = "tokenizeNLs=false,invertible=true";
        if (flags.tokenizerOptions != null) {
            options = options + "," + flags.tokenizerOptions;
        }
        if (flags.tokenizerFactory != null) {
            try {
                Class clazz = (Class)ErasureUtils.uncheckedCast(Class.forName(flags.tokenizerFactory));
                Method factoryMethod = clazz.getMethod("newCoreLabelTokenizerFactory", String.class);
                factory = (TokenizerFactory)ErasureUtils.uncheckedCast(factoryMethod.invoke(null, options));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            factory = (TokenizerFactory)ErasureUtils.uncheckedCast(PTBTokenizer.PTBTokenizerFactory.newCoreLabelTokenizerFactory(options));
        }
        this.init(flags, factory);
    }

    public void init(SeqClassifierFlags flags, TokenizerFactory<IN> tokenizerFactory) {
        this.flags = flags;
        this.tokenizerFactory = tokenizerFactory;
    }

    @Override
    public Iterator<List<IN>> getIterator(Reader r) {
        Tokenizer<IN> tokenizer = this.tokenizerFactory.getTokenizer(r);
        ArrayList<CoreMap> words = new ArrayList<CoreMap>();
        CoreMap previous = null;
        StringBuilder prepend = new StringBuilder();
        while (tokenizer.hasNext()) {
            String before;
            CoreMap w = (CoreMap)tokenizer.next();
            String word = (String)w.get(CoreAnnotations.TextAnnotation.class);
            Matcher m = sgml.matcher(word);
            if (m.matches()) {
                before = StringUtils.getNotNullString((String)w.get(CoreAnnotations.BeforeAnnotation.class));
                String after = StringUtils.getNotNullString((String)w.get(CoreAnnotations.AfterAnnotation.class));
                prepend.append(before).append(word);
                if (previous == null) continue;
                String previousTokenAfter = StringUtils.getNotNullString((String)previous.get(CoreAnnotations.AfterAnnotation.class));
                previous.set(CoreAnnotations.AfterAnnotation.class, previousTokenAfter + word + after);
                continue;
            }
            before = StringUtils.getNotNullString((String)w.get(CoreAnnotations.BeforeAnnotation.class));
            if (prepend.length() > 0) {
                w.set(CoreAnnotations.BeforeAnnotation.class, prepend.toString() + before);
                prepend = new StringBuilder();
            }
            words.add(w);
            previous = w;
        }
        List<List<IN>> sentences = this.wts.process(words);
        String after = "";
        TypesafeMap last = null;
        for (List<IN> sentence : sentences) {
            int pos = 0;
            for (CoreMap w : sentence) {
                w.set(CoreAnnotations.PositionAnnotation.class, Integer.toString(pos));
                after = StringUtils.getNotNullString((String)w.get(CoreAnnotations.AfterAnnotation.class));
                w.remove(CoreAnnotations.AfterAnnotation.class);
                last = w;
            }
        }
        if (last != null) {
            last.set(CoreAnnotations.AfterAnnotation.class, after);
        }
        return sentences.iterator();
    }

    @Override
    public void printAnswers(List<IN> list, PrintWriter out2) {
        String style = null;
        if (this.flags != null) {
            style = this.flags.outputFormat;
        }
        if (style == null || "".equals(style)) {
            style = "slashTags";
        }
        OutputStyle outputStyle = OutputStyle.fromShortName(style);
        this.printAnswers(list, out2, outputStyle, !"slashTags".equals(style));
    }

    public String getAnswers(List<IN> l, OutputStyle outputStyle, boolean preserveSpacing) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printAnswers(l, pw, outputStyle, preserveSpacing);
        pw.flush();
        return sw.toString();
    }

    public void printAnswers(List<IN> l, PrintWriter out2, OutputStyle outputStyle, boolean preserveSpacing) {
        switch (outputStyle) {
            case SLASH_TAGS: {
                if (preserveSpacing) {
                    PlainTextDocumentReaderAndWriter.printAnswersAsIsText(l, out2);
                    break;
                }
                PlainTextDocumentReaderAndWriter.printAnswersTokenizedText(l, out2);
                break;
            }
            case XML: {
                if (preserveSpacing) {
                    PlainTextDocumentReaderAndWriter.printAnswersXML(l, out2);
                    break;
                }
                PlainTextDocumentReaderAndWriter.printAnswersTokenizedXML(l, out2);
                break;
            }
            case INLINE_XML: {
                if (preserveSpacing) {
                    this.printAnswersInlineXML(l, out2);
                    break;
                }
                this.printAnswersTokenizedInlineXML(l, out2);
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)outputStyle) + " is an unsupported OutputStyle");
            }
        }
    }

    private static <IN extends CoreMap> void printAnswersTokenizedText(List<IN> l, PrintWriter out2) {
        for (CoreMap wi : l) {
            out2.print(StringUtils.getNotNullString((String)wi.get(CoreAnnotations.TextAnnotation.class)));
            out2.print('/');
            out2.print(StringUtils.getNotNullString((String)wi.get(CoreAnnotations.AnswerAnnotation.class)));
            out2.print(' ');
        }
        out2.println();
    }

    private static <IN extends CoreMap> void printAnswersAsIsText(List<IN> l, PrintWriter out2) {
        for (CoreMap wi : l) {
            out2.print(StringUtils.getNotNullString((String)wi.get(CoreAnnotations.BeforeAnnotation.class)));
            out2.print(StringUtils.getNotNullString((String)wi.get(CoreAnnotations.TextAnnotation.class)));
            out2.print('/');
            out2.print(StringUtils.getNotNullString((String)wi.get(CoreAnnotations.AnswerAnnotation.class)));
            out2.print(StringUtils.getNotNullString((String)wi.get(CoreAnnotations.AfterAnnotation.class)));
        }
    }

    private static <IN extends CoreMap> void printAnswersXML(List<IN> doc, PrintWriter out2) {
        int num = 0;
        for (CoreMap wi : doc) {
            String prev = StringUtils.getNotNullString((String)wi.get(CoreAnnotations.BeforeAnnotation.class));
            out2.print(prev);
            out2.print("<wi num=\"");
            out2.print(num++);
            out2.print("\" entity=\"");
            out2.print(StringUtils.getNotNullString((String)wi.get(CoreAnnotations.AnswerAnnotation.class)));
            out2.print("\">");
            out2.print(XMLUtils.escapeXML(StringUtils.getNotNullString((String)wi.get(CoreAnnotations.TextAnnotation.class))));
            out2.print("</wi>");
            String after = StringUtils.getNotNullString((String)wi.get(CoreAnnotations.AfterAnnotation.class));
            out2.print(after);
        }
    }

    private static <IN extends CoreMap> void printAnswersTokenizedXML(List<IN> doc, PrintWriter out2) {
        int num = 0;
        for (CoreMap wi : doc) {
            out2.print("<wi num=\"");
            out2.print(num++);
            out2.print("\" entity=\"");
            out2.print(StringUtils.getNotNullString((String)wi.get(CoreAnnotations.AnswerAnnotation.class)));
            out2.print("\">");
            out2.print(XMLUtils.escapeXML(StringUtils.getNotNullString((String)wi.get(CoreAnnotations.TextAnnotation.class))));
            out2.println("</wi>");
        }
    }

    private void printAnswersInlineXML(List<IN> doc, PrintWriter out2) {
        String background;
        String prevTag = background = this.flags.backgroundSymbol;
        Iterator<IN> wordIter = doc.iterator();
        while (wordIter.hasNext()) {
            CoreMap wi = (CoreMap)wordIter.next();
            String tag = StringUtils.getNotNullString((String)wi.get(CoreAnnotations.AnswerAnnotation.class));
            String before = StringUtils.getNotNullString((String)wi.get(CoreAnnotations.BeforeAnnotation.class));
            String current = StringUtils.getNotNullString((String)wi.get(CoreAnnotations.OriginalTextAnnotation.class));
            if (!tag.equals(prevTag)) {
                if (!prevTag.equals(background) && !tag.equals(background)) {
                    out2.print("</");
                    out2.print(prevTag);
                    out2.print('>');
                    out2.print(before);
                    out2.print('<');
                    out2.print(tag);
                    out2.print('>');
                } else if (!prevTag.equals(background)) {
                    out2.print("</");
                    out2.print(prevTag);
                    out2.print('>');
                    out2.print(before);
                } else if (!tag.equals(background)) {
                    out2.print(before);
                    out2.print('<');
                    out2.print(tag);
                    out2.print('>');
                }
            } else {
                out2.print(before);
            }
            out2.print(current);
            String afterWS = StringUtils.getNotNullString((String)wi.get(CoreAnnotations.AfterAnnotation.class));
            if (!tag.equals(background) && !wordIter.hasNext()) {
                out2.print("</");
                out2.print(tag);
                out2.print('>');
                prevTag = background;
            } else {
                prevTag = tag;
            }
            out2.print(afterWS);
        }
    }

    private void printAnswersTokenizedInlineXML(List<IN> doc, PrintWriter out2) {
        String background;
        String prevTag = background = this.flags.backgroundSymbol;
        boolean first = true;
        Iterator<IN> wordIter = doc.iterator();
        while (wordIter.hasNext()) {
            CoreMap wi = (CoreMap)wordIter.next();
            String tag = StringUtils.getNotNullString((String)wi.get(CoreAnnotations.AnswerAnnotation.class));
            if (!tag.equals(prevTag)) {
                if (!prevTag.equals(background) && !tag.equals(background)) {
                    out2.print("</");
                    out2.print(prevTag);
                    out2.print("> <");
                    out2.print(tag);
                    out2.print('>');
                } else if (!prevTag.equals(background)) {
                    out2.print("</");
                    out2.print(prevTag);
                    out2.print("> ");
                } else if (!tag.equals(background)) {
                    if (!first) {
                        out2.print(' ');
                    }
                    out2.print('<');
                    out2.print(tag);
                    out2.print('>');
                }
            } else if (!first) {
                out2.print(' ');
            }
            first = false;
            out2.print(StringUtils.getNotNullString((String)wi.get(CoreAnnotations.OriginalTextAnnotation.class)));
            if (!wordIter.hasNext()) {
                if (!tag.equals(background)) {
                    out2.print("</");
                    out2.print(tag);
                    out2.print('>');
                }
                out2.print(' ');
                prevTag = background;
                continue;
            }
            prevTag = tag;
        }
        out2.println();
    }

    public static enum OutputStyle {
        SLASH_TAGS("slashTags"),
        XML("xml"),
        INLINE_XML("inlineXML"),
        TSV("tsv");

        private final String shortName;
        private static final Map<String, OutputStyle> shortNames;

        private OutputStyle(String shortName) {
            this.shortName = shortName;
        }

        public static OutputStyle fromShortName(String name) {
            OutputStyle result = shortNames.get(name);
            if (result == null) {
                throw new IllegalArgumentException(name + " is not an OutputStyle");
            }
            return result;
        }

        static {
            shortNames = Generics.newHashMap();
            for (OutputStyle style : OutputStyle.values()) {
                shortNames.put(style.shortName, style);
            }
        }
    }
}

