/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.io.NumberRangeFileFilter;
import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.WordFactory;
import edu.stanford.nlp.parser.lexparser.Debinarizer;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.ParentAnnotationStats;
import edu.stanford.nlp.parser.lexparser.TreeAnnotatorAndBinarizer;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.util.Generics;
import java.io.FileFilter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TreebankAnnotator {
    final TreeTransformer treeTransformer;
    final TreeTransformer treeUnTransformer;
    final TreeTransformer collinizer;
    final Options op;

    public List<Tree> annotateTrees(List<Tree> trees) {
        ArrayList<Tree> annotatedTrees = new ArrayList<Tree>();
        for (Tree tree : trees) {
            annotatedTrees.add(this.treeTransformer.transformTree(tree));
        }
        return annotatedTrees;
    }

    public List<Tree> deannotateTrees(List<Tree> trees) {
        ArrayList<Tree> deannotatedTrees = new ArrayList<Tree>();
        for (Tree tree : trees) {
            deannotatedTrees.add(this.treeUnTransformer.transformTree(tree));
        }
        return deannotatedTrees;
    }

    public static List<Tree> getTrees(String path, int low, int high, int minLength, int maxLength) {
        DiskTreebank treebank = new DiskTreebank(new TreeReaderFactory(){

            @Override
            public TreeReader newTreeReader(Reader in) {
                return new PennTreeReader(in, new LabeledScoredTreeFactory(new WordFactory()), new BobChrisTreeNormalizer());
            }
        });
        treebank.loadPath(path, (FileFilter)new NumberRangeFileFilter(low, high, true));
        ArrayList<Tree> trees = new ArrayList<Tree>();
        for (Tree tree : treebank) {
            if (tree.yield().size() > maxLength || tree.yield().size() < minLength) continue;
            trees.add(tree);
        }
        return trees;
    }

    public static List<Tree> removeDependencyRoots(List<Tree> trees) {
        ArrayList<Tree> prunedTrees = new ArrayList<Tree>();
        for (Tree tree : trees) {
            prunedTrees.add(TreebankAnnotator.removeDependencyRoot(tree));
        }
        return prunedTrees;
    }

    static Tree removeDependencyRoot(Tree tree) {
        List<Tree> childList = tree.getChildrenAsList();
        Tree last = childList.get(childList.size() - 1);
        if (!last.label().value().equals(".$$.")) {
            return tree;
        }
        List<Tree> lastGoneList = childList.subList(0, childList.size() - 1);
        tree.setChildren(lastGoneList);
        return tree;
    }

    public Tree collinize(Tree tree) {
        return this.collinizer.transformTree(tree);
    }

    public TreebankAnnotator(Options op, String treebankRoot) {
        op.trainOptions.splitters = ParentAnnotationStats.getEnglishSplitCategories(treebankRoot);
        op.trainOptions.sisterSplitters = Generics.newHashSet(Arrays.asList(op.tlpParams.sisterSplitters()));
        op.setOptions("-acl03pcfg", "-cnf");
        this.treeTransformer = new TreeAnnotatorAndBinarizer(op.tlpParams, op.forceCNF, !op.trainOptions.outsideFactor(), true, op);
        this.treeUnTransformer = new Debinarizer(op.forceCNF);
        this.collinizer = op.tlpParams.collinizer();
        this.op = op;
    }

    public static void main(String[] args) {
        CategoryWordTag.printWordTag = false;
        String path = args[0];
        List<Tree> trees = TreebankAnnotator.getTrees(path, 200, 219, 0, 10);
        trees.iterator().next().pennPrint();
        Options op = new Options();
        List<Tree> annotatedTrees = TreebankAnnotator.removeDependencyRoots(new TreebankAnnotator(op, path).annotateTrees(trees));
        annotatedTrees.iterator().next().pennPrint();
    }
}

