/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.EmptyFileException;
import org.apache.poi.poifs.common.POIFSBigBlockSize;
import org.apache.poi.poifs.common.POIFSConstants;
import org.apache.poi.poifs.dev.POIFSViewable;
import org.apache.poi.poifs.filesystem.BlockStore;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.EntryNode;
import org.apache.poi.poifs.filesystem.NPOIFSDocument;
import org.apache.poi.poifs.filesystem.NPOIFSMiniStore;
import org.apache.poi.poifs.filesystem.NPOIFSStream;
import org.apache.poi.poifs.filesystem.POIFSWriterListener;
import org.apache.poi.poifs.nio.ByteArrayBackedDataSource;
import org.apache.poi.poifs.nio.DataSource;
import org.apache.poi.poifs.nio.FileBackedDataSource;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.DocumentProperty;
import org.apache.poi.poifs.property.NPropertyTable;
import org.apache.poi.poifs.storage.BATBlock;
import org.apache.poi.poifs.storage.BlockAllocationTableReader;
import org.apache.poi.poifs.storage.BlockAllocationTableWriter;
import org.apache.poi.poifs.storage.HeaderBlock;
import org.apache.poi.poifs.storage.HeaderBlockWriter;
import org.apache.poi.util.CloseIgnoringInputStream;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LongField;

public class NPOIFSFileSystem
extends BlockStore
implements POIFSViewable,
Closeable {
    private NPOIFSMiniStore _mini_store;
    private NPropertyTable _property_table;
    private List<BATBlock> _xbat_blocks;
    private List<BATBlock> _bat_blocks;
    private HeaderBlock _header;
    private DirectoryNode _root = null;
    private DataSource _data;
    private POIFSBigBlockSize bigBlockSize = POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS;

    public static InputStream createNonClosingInputStream(InputStream is) {
        return new CloseIgnoringInputStream(is);
    }

    private NPOIFSFileSystem(boolean newFS) {
        this._header = new HeaderBlock(this.bigBlockSize);
        this._property_table = new NPropertyTable(this._header);
        this._mini_store = new NPOIFSMiniStore(this, this._property_table.getRoot(), new ArrayList<BATBlock>(), this._header);
        this._xbat_blocks = new ArrayList<BATBlock>();
        this._bat_blocks = new ArrayList<BATBlock>();
        if (newFS) {
            this._data = new ByteArrayBackedDataSource(new byte[this.bigBlockSize.getBigBlockSize() * 3]);
        }
    }

    public NPOIFSFileSystem() {
        this(true);
        this._header.setBATCount(1);
        this._header.setBATArray(new int[]{0});
        BATBlock bb = BATBlock.createEmptyBATBlock(this.bigBlockSize, false);
        bb.setOurBlockIndex(0);
        this._bat_blocks.add(bb);
        this.setNextBlock(0, -3);
        this.setNextBlock(1, -2);
        this._property_table.setStartBlock(-2);
    }

    public NPOIFSFileSystem(File file) throws IOException {
        this(file, true);
    }

    public NPOIFSFileSystem(File file, boolean readOnly) throws IOException {
        this(null, file, readOnly, true);
    }

    public NPOIFSFileSystem(FileChannel channel) throws IOException {
        this(channel, true);
    }

    public NPOIFSFileSystem(FileChannel channel, boolean readOnly) throws IOException {
        this(channel, null, readOnly, false);
    }

    private NPOIFSFileSystem(FileChannel channel, File srcFile, boolean readOnly, boolean closeChannelOnError) throws IOException {
        this(false);
        try {
            if (srcFile != null) {
                if (srcFile.length() == 0L) {
                    throw new EmptyFileException();
                }
                FileBackedDataSource d = new FileBackedDataSource(srcFile, readOnly);
                channel = d.getChannel();
                this._data = d;
            } else {
                this._data = new FileBackedDataSource(channel, readOnly);
            }
            ByteBuffer headerBuffer = ByteBuffer.allocate(512);
            IOUtils.readFully(channel, headerBuffer);
            this._header = new HeaderBlock(headerBuffer);
            this.readCoreContents();
        }
        catch (IOException e) {
            if (closeChannelOnError) {
                channel.close();
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (closeChannelOnError && channel != null) {
                channel.close();
                channel = null;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NPOIFSFileSystem(InputStream stream) throws IOException {
        this(false);
        ReadableByteChannel channel = null;
        boolean success = false;
        try {
            channel = Channels.newChannel(stream);
            ByteBuffer headerBuffer = ByteBuffer.allocate(512);
            IOUtils.readFully(channel, headerBuffer);
            this._header = new HeaderBlock(headerBuffer);
            BlockAllocationTableReader.sanityCheckBlockCount(this._header.getBATCount());
            long maxSize = BATBlock.calculateMaximumSize(this._header);
            if (maxSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Unable read a >2gb file via an InputStream");
            }
            ByteBuffer data = ByteBuffer.allocate((int)maxSize);
            headerBuffer.position(0);
            data.put(headerBuffer);
            data.position(headerBuffer.capacity());
            IOUtils.readFully(channel, data);
            success = true;
            this._data = new ByteArrayBackedDataSource(data.array(), data.position());
        }
        finally {
            if (channel != null) {
                channel.close();
            }
            this.closeInputStream(stream, success);
        }
        this.readCoreContents();
    }

    private void closeInputStream(InputStream stream, boolean success) {
        try {
            stream.close();
        }
        catch (IOException e) {
            if (success) {
                throw new RuntimeException(e);
            }
            e.printStackTrace();
        }
    }

    public static boolean hasPOIFSHeader(InputStream inp) throws IOException {
        inp.mark(8);
        byte[] header = new byte[8];
        IOUtils.readFully(inp, header);
        LongField signature = new LongField(0, header);
        if (inp instanceof PushbackInputStream) {
            PushbackInputStream pin = (PushbackInputStream)inp;
            pin.unread(header);
        } else {
            inp.reset();
        }
        return signature.get() == -2226271756974174256L;
    }

    private void readCoreContents() throws IOException {
        this.bigBlockSize = this._header.getBigBlockSize();
        BlockStore.ChainLoopDetector loopDetector = this.getChainLoopDetector();
        for (int fatAt : this._header.getBATArray()) {
            this.readBAT(fatAt, loopDetector);
        }
        int remainingFATs = this._header.getBATCount() - this._header.getBATArray().length;
        int nextAt = this._header.getXBATIndex();
        for (int i = 0; i < this._header.getXBATCount(); ++i) {
            int fatAt;
            loopDetector.claim(nextAt);
            ByteBuffer fatData = this.getBlockAt(nextAt);
            BATBlock xfat = BATBlock.createBATBlock(this.bigBlockSize, fatData);
            xfat.setOurBlockIndex(nextAt);
            nextAt = xfat.getValueAt(this.bigBlockSize.getXBATEntriesPerBlock());
            this._xbat_blocks.add(xfat);
            int xbatFATs = Math.min(remainingFATs, this.bigBlockSize.getXBATEntriesPerBlock());
            for (int j = 0; j < xbatFATs && (fatAt = xfat.getValueAt(j)) != -1 && fatAt != -2; ++j) {
                this.readBAT(fatAt, loopDetector);
            }
            remainingFATs -= xbatFATs;
        }
        this._property_table = new NPropertyTable(this._header, this);
        ArrayList<BATBlock> sbats = new ArrayList<BATBlock>();
        this._mini_store = new NPOIFSMiniStore(this, this._property_table.getRoot(), sbats, this._header);
        nextAt = this._header.getSBATStart();
        for (int i = 0; i < this._header.getSBATCount(); ++i) {
            loopDetector.claim(nextAt);
            ByteBuffer fatData = this.getBlockAt(nextAt);
            BATBlock sfat = BATBlock.createBATBlock(this.bigBlockSize, fatData);
            sfat.setOurBlockIndex(nextAt);
            sbats.add(sfat);
            nextAt = this.getNextBlock(nextAt);
        }
    }

    private void readBAT(int batAt, BlockStore.ChainLoopDetector loopDetector) throws IOException {
        loopDetector.claim(batAt);
        ByteBuffer fatData = this.getBlockAt(batAt);
        BATBlock bat = BATBlock.createBATBlock(this.bigBlockSize, fatData);
        bat.setOurBlockIndex(batAt);
        this._bat_blocks.add(bat);
    }

    private BATBlock createBAT(int offset, boolean isBAT) throws IOException {
        BATBlock newBAT = BATBlock.createEmptyBATBlock(this.bigBlockSize, !isBAT);
        newBAT.setOurBlockIndex(offset);
        ByteBuffer buffer = ByteBuffer.allocate(this.bigBlockSize.getBigBlockSize());
        int writeTo = (1 + offset) * this.bigBlockSize.getBigBlockSize();
        this._data.write(buffer, writeTo);
        return newBAT;
    }

    @Override
    protected ByteBuffer getBlockAt(int offset) throws IOException {
        long blockWanted = offset + 1;
        long startAt = blockWanted * (long)this.bigBlockSize.getBigBlockSize();
        try {
            return this._data.read(this.bigBlockSize.getBigBlockSize(), startAt);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException("Block " + offset + " not found - " + e);
        }
    }

    @Override
    protected ByteBuffer createBlockIfNeeded(int offset) throws IOException {
        try {
            return this.getBlockAt(offset);
        }
        catch (IndexOutOfBoundsException e) {
            long startAt = (offset + 1) * this.bigBlockSize.getBigBlockSize();
            ByteBuffer buffer = ByteBuffer.allocate(this.getBigBlockSize());
            this._data.write(buffer, startAt);
            return this.getBlockAt(offset);
        }
    }

    @Override
    protected BATBlock.BATBlockAndIndex getBATBlockAndIndex(int offset) {
        return BATBlock.getBATBlockAndIndex(offset, this._header, this._bat_blocks);
    }

    @Override
    protected int getNextBlock(int offset) {
        BATBlock.BATBlockAndIndex bai = this.getBATBlockAndIndex(offset);
        return bai.getBlock().getValueAt(bai.getIndex());
    }

    @Override
    protected void setNextBlock(int offset, int nextBlock) {
        BATBlock.BATBlockAndIndex bai = this.getBATBlockAndIndex(offset);
        bai.getBlock().setValueAt(bai.getIndex(), nextBlock);
    }

    @Override
    protected int getFreeBlock() throws IOException {
        int numSectors = this.bigBlockSize.getBATEntriesPerBlock();
        int offset = 0;
        for (BATBlock bat : this._bat_blocks) {
            if (bat.hasFreeSectors()) {
                for (int j = 0; j < numSectors; ++j) {
                    int batValue = bat.getValueAt(j);
                    if (batValue != -1) continue;
                    return offset + j;
                }
            }
            offset += numSectors;
        }
        BATBlock bat = this.createBAT(offset, true);
        bat.setValueAt(0, -3);
        this._bat_blocks.add(bat);
        if (this._header.getBATCount() >= 109) {
            BATBlock xbat = null;
            for (BATBlock x : this._xbat_blocks) {
                if (!x.hasFreeSectors()) continue;
                xbat = x;
                break;
            }
            if (xbat == null) {
                xbat = this.createBAT(offset + 1, false);
                xbat.setValueAt(0, offset);
                bat.setValueAt(1, -4);
                ++offset;
                if (this._xbat_blocks.size() == 0) {
                    this._header.setXBATStart(offset);
                } else {
                    this._xbat_blocks.get(this._xbat_blocks.size() - 1).setValueAt(this.bigBlockSize.getXBATEntriesPerBlock(), offset);
                }
                this._xbat_blocks.add(xbat);
                this._header.setXBATCount(this._xbat_blocks.size());
            } else {
                for (int i = 0; i < this.bigBlockSize.getXBATEntriesPerBlock(); ++i) {
                    if (xbat.getValueAt(i) != -1) continue;
                    xbat.setValueAt(i, offset);
                    break;
                }
            }
        } else {
            int[] newBATs = new int[this._header.getBATCount() + 1];
            System.arraycopy(this._header.getBATArray(), 0, newBATs, 0, newBATs.length - 1);
            newBATs[newBATs.length - 1] = offset;
            this._header.setBATArray(newBATs);
        }
        this._header.setBATCount(this._bat_blocks.size());
        return offset + 1;
    }

    protected long size() throws IOException {
        return this._data.size();
    }

    @Override
    protected BlockStore.ChainLoopDetector getChainLoopDetector() throws IOException {
        return new BlockStore.ChainLoopDetector(this._data.size());
    }

    NPropertyTable _get_property_table() {
        return this._property_table;
    }

    public NPOIFSMiniStore getMiniStore() {
        return this._mini_store;
    }

    void addDocument(NPOIFSDocument document) {
        this._property_table.addProperty(document.getDocumentProperty());
    }

    void addDirectory(DirectoryProperty directory) {
        this._property_table.addProperty(directory);
    }

    public DocumentEntry createDocument(InputStream stream, String name) throws IOException {
        return this.getRoot().createDocument(name, stream);
    }

    public DocumentEntry createDocument(String name, int size, POIFSWriterListener writer) throws IOException {
        return this.getRoot().createDocument(name, size, writer);
    }

    public DirectoryEntry createDirectory(String name) throws IOException {
        return this.getRoot().createDirectory(name);
    }

    public void writeFilesystem() throws IOException {
        if (!(this._data instanceof FileBackedDataSource)) {
            throw new IllegalArgumentException("POIFS opened from an inputstream, so writeFilesystem() may not be called. Use writeFilesystem(OutputStream) instead");
        }
        if (!((FileBackedDataSource)this._data).isWriteable()) {
            throw new IllegalArgumentException("POIFS opened in read only mode, so writeFilesystem() may not be called. Open the FileSystem in read-write mode first");
        }
        this.syncWithDataSource();
    }

    public void writeFilesystem(OutputStream stream) throws IOException {
        this.syncWithDataSource();
        this._data.copyTo(stream);
    }

    private void syncWithDataSource() throws IOException {
        ByteBuffer block;
        NPOIFSStream propStream = new NPOIFSStream(this, this._header.getPropertyStart());
        this._property_table.preWrite();
        this._property_table.write(propStream);
        HeaderBlockWriter hbw = new HeaderBlockWriter(this._header);
        hbw.writeBlock(this.getBlockAt(-1));
        for (BATBlock bat : this._bat_blocks) {
            block = this.getBlockAt(bat.getOurBlockIndex());
            BlockAllocationTableWriter.writeBlock(bat, block);
        }
        for (BATBlock bat : this._xbat_blocks) {
            block = this.getBlockAt(bat.getOurBlockIndex());
            BlockAllocationTableWriter.writeBlock(bat, block);
        }
        this._mini_store.syncWithDataSource();
    }

    @Override
    public void close() throws IOException {
        this._data.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("two arguments required: input filename and output filename");
            System.exit(1);
        }
        FileInputStream istream = new FileInputStream(args[0]);
        try {
            FileOutputStream ostream = new FileOutputStream(args[1]);
            try {
                NPOIFSFileSystem fs = new NPOIFSFileSystem(istream);
                try {
                    fs.writeFilesystem(ostream);
                }
                finally {
                    fs.close();
                }
            }
            finally {
                ostream.close();
            }
        }
        finally {
            istream.close();
        }
    }

    public DirectoryNode getRoot() {
        if (this._root == null) {
            this._root = new DirectoryNode((DirectoryProperty)this._property_table.getRoot(), this, null);
        }
        return this._root;
    }

    public DocumentInputStream createDocumentInputStream(String documentName) throws IOException {
        return this.getRoot().createDocumentInputStream(documentName);
    }

    void remove(EntryNode entry) throws IOException {
        if (entry instanceof DocumentEntry) {
            NPOIFSDocument doc = new NPOIFSDocument((DocumentProperty)entry.getProperty(), this);
            doc.free();
        }
        this._property_table.removeProperty(entry.getProperty());
    }

    @Override
    public Object[] getViewableArray() {
        if (this.preferArray()) {
            return this.getRoot().getViewableArray();
        }
        return new Object[0];
    }

    @Override
    public Iterator<Object> getViewableIterator() {
        if (!this.preferArray()) {
            return this.getRoot().getViewableIterator();
        }
        return Collections.emptyList().iterator();
    }

    @Override
    public boolean preferArray() {
        return this.getRoot().preferArray();
    }

    @Override
    public String getShortDescription() {
        return "POIFS FileSystem";
    }

    public int getBigBlockSize() {
        return this.bigBlockSize.getBigBlockSize();
    }

    public POIFSBigBlockSize getBigBlockSizeDetails() {
        return this.bigBlockSize;
    }

    @Override
    protected int getBlockStoreBlockSize() {
        return this.getBigBlockSize();
    }
}

