/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.NShort.Path;

import com.hankcs.hanlp.seg.NShort.Path.CQueue;
import com.hankcs.hanlp.seg.NShort.Path.PathNode;
import com.hankcs.hanlp.seg.NShort.Path.QueueElement;
import com.hankcs.hanlp.seg.common.EdgeFrom;
import com.hankcs.hanlp.seg.common.Graph;
import com.hankcs.hanlp.utility.Predefine;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class NShortPath {
    private Graph graph;
    private int N;
    private int vertexCount;
    private CQueue[][] fromArray;
    private double[][] weightArray;

    public NShortPath(Graph graph, int N) {
        this.calculate(graph, N);
    }

    private void initNShortPath(Graph inGraph, int nValueKind) {
        this.graph = inGraph;
        this.N = nValueKind;
        this.vertexCount = inGraph.vertexes.length;
        this.fromArray = new CQueue[this.vertexCount - 1][];
        this.weightArray = new double[this.vertexCount - 1][];
        int i = 0;
        while (i < this.vertexCount - 1) {
            this.fromArray[i] = new CQueue[nValueKind];
            this.weightArray[i] = new double[nValueKind];
            int j = 0;
            while (j < nValueKind) {
                this.fromArray[i][j] = new CQueue();
                ++j;
            }
            ++i;
        }
    }

    private void calculate(Graph inGraph, int nValueKind) {
        this.initNShortPath(inGraph, nValueKind);
        CQueue queWork = new CQueue();
        int nCurNode = 1;
        while (nCurNode < this.vertexCount) {
            this.enQueueCurNodeEdges(queWork, nCurNode);
            int i = 0;
            while (i < this.N) {
                this.weightArray[nCurNode - 1][i] = Double.MAX_VALUE;
                ++i;
            }
            QueueElement tmpElement = queWork.deQueue();
            if (tmpElement != null) {
                i = 0;
                while (i < this.N) {
                    double eWeight;
                    this.weightArray[nCurNode - 1][i] = eWeight = tmpElement.weight;
                    do {
                        this.fromArray[nCurNode - 1][i].enQueue(new QueueElement(tmpElement.from, tmpElement.index, 0.0));
                        tmpElement = queWork.deQueue();
                        if (tmpElement != null) continue;
                        i = this.N;
                        break;
                    } while (tmpElement.weight == eWeight);
                    ++i;
                }
            }
            ++nCurNode;
        }
    }

    private void enQueueCurNodeEdges(CQueue queWork, int nCurNode) {
        queWork.clear();
        List<EdgeFrom> pEdgeToList = this.graph.getEdgeListTo(nCurNode);
        block0: for (EdgeFrom e : pEdgeToList) {
            int nPreNode = e.from;
            double eWeight = e.weight;
            int i = 0;
            while (i < this.N) {
                if (nPreNode == 0) {
                    queWork.enQueue(new QueueElement(nPreNode, i, eWeight));
                    continue block0;
                }
                if (this.weightArray[nPreNode - 1][i] == Double.MAX_VALUE) continue block0;
                queWork.enQueue(new QueueElement(nPreNode, i, eWeight + this.weightArray[nPreNode - 1][i]));
                ++i;
            }
        }
    }

    public List<int[]> getPaths(int index) {
        assert (index <= this.N && index >= 0);
        Stack<PathNode> stack = new Stack<PathNode>();
        int curNode = this.vertexCount - 1;
        int curIndex = index;
        ArrayList<int[]> result = new ArrayList<int[]>();
        QueueElement element = this.fromArray[curNode - 1][curIndex].GetFirst();
        while (element != null) {
            stack.push(new PathNode(curNode, curIndex));
            stack.push(new PathNode(element.from, element.index));
            curNode = element.from;
            while (curNode != 0) {
                element = this.fromArray[element.from - 1][element.index].GetFirst();
                stack.push(new PathNode(element.from, element.index));
                curNode = element.from;
            }
            PathNode[] nArray = new PathNode[stack.size()];
            int i = 0;
            while (i < stack.size()) {
                nArray[i] = (PathNode)stack.get(stack.size() - i - 1);
                ++i;
            }
            int[] aPath = new int[nArray.length];
            i = 0;
            while (i < aPath.length) {
                aPath[i] = nArray[i].from;
                ++i;
            }
            result.add(aPath);
            do {
                PathNode node = (PathNode)stack.pop();
                curNode = node.from;
                curIndex = node.index;
            } while (curNode < 1 || stack.size() != 0 && !this.fromArray[curNode - 1][curIndex].CanGetNext());
            element = this.fromArray[curNode - 1][curIndex].GetNext();
        }
        return result;
    }

    public Integer[] getBestPath() {
        assert (this.vertexCount > 2);
        Stack<Integer> stack = new Stack<Integer>();
        int curNode = this.vertexCount - 1;
        int curIndex = 0;
        QueueElement element = this.fromArray[curNode - 1][curIndex].GetFirst();
        stack.push(curNode);
        stack.push(element.from);
        curNode = element.from;
        while (curNode != 0) {
            element = this.fromArray[element.from - 1][element.index].GetFirst();
            stack.push(element.from);
            curNode = element.from;
        }
        return (Integer[])stack.toArray();
    }

    public List<int[]> getNPaths(int n) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        n = Math.min(Predefine.MAX_SEGMENT_NUM, n);
        int i = 0;
        while (i < this.N && result.size() < n) {
            List<int[]> pathList = this.getPaths(i);
            for (int[] path : pathList) {
                if (result.size() == n) break;
                result.add(path);
            }
            ++i;
        }
        return result;
    }

    public List<int[]> getNPaths() {
        return this.getNPaths(Predefine.MAX_SEGMENT_NUM);
    }
}

