/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import org.apache.poi.hslf.record.PositionDependentRecordAtom;
import org.apache.poi.util.LittleEndian;

public final class UserEditAtom
extends PositionDependentRecordAtom {
    public static final int LAST_VIEW_NONE = 0;
    public static final int LAST_VIEW_SLIDE_VIEW = 1;
    public static final int LAST_VIEW_OUTLINE_VIEW = 2;
    public static final int LAST_VIEW_NOTES = 3;
    private byte[] _header;
    private static long _type = 4085L;
    private short unused;
    private int lastViewedSlideID;
    private int pptVersion;
    private int lastUserEditAtomOffset;
    private int persistPointersOffset;
    private int docPersistRef;
    private int maxPersistWritten;
    private short lastViewType;
    private int encryptSessionPersistIdRef = -1;

    public int getLastViewedSlideID() {
        return this.lastViewedSlideID;
    }

    public short getLastViewType() {
        return this.lastViewType;
    }

    public int getLastUserEditAtomOffset() {
        return this.lastUserEditAtomOffset;
    }

    public int getPersistPointersOffset() {
        return this.persistPointersOffset;
    }

    public int getDocPersistRef() {
        return this.docPersistRef;
    }

    public int getMaxPersistWritten() {
        return this.maxPersistWritten;
    }

    public int getEncryptSessionPersistIdRef() {
        return this.encryptSessionPersistIdRef;
    }

    public void setLastUserEditAtomOffset(int offset) {
        this.lastUserEditAtomOffset = offset;
    }

    public void setPersistPointersOffset(int offset) {
        this.persistPointersOffset = offset;
    }

    public void setLastViewType(short type) {
        this.lastViewType = type;
    }

    public void setMaxPersistWritten(int max) {
        this.maxPersistWritten = max;
    }

    public void setEncryptSessionPersistIdRef(int id) {
        this.encryptSessionPersistIdRef = id;
        LittleEndian.putInt((byte[])this._header, (int)4, (int)(id == -1 ? 28 : 32));
    }

    protected UserEditAtom(byte[] source, int start, int len) {
        if (len < 34) {
            len = 34;
        }
        int offset = start;
        this._header = new byte[8];
        System.arraycopy(source, offset, this._header, 0, 8);
        this.lastViewedSlideID = LittleEndian.getInt((byte[])source, (int)(offset += 8));
        this.pptVersion = LittleEndian.getInt((byte[])source, (int)(offset += 4));
        this.lastUserEditAtomOffset = LittleEndian.getInt((byte[])source, (int)(offset += 4));
        this.persistPointersOffset = LittleEndian.getInt((byte[])source, (int)(offset += 4));
        this.docPersistRef = LittleEndian.getInt((byte[])source, (int)(offset += 4));
        this.maxPersistWritten = LittleEndian.getInt((byte[])source, (int)(offset += 4));
        this.lastViewType = LittleEndian.getShort((byte[])source, (int)(offset += 4));
        this.unused = LittleEndian.getShort((byte[])source, (int)(offset += 2));
        if ((offset += 2) - start < len) {
            this.encryptSessionPersistIdRef = LittleEndian.getInt((byte[])source, (int)offset);
            offset += 4;
        }
        assert (offset - start == len);
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void updateOtherRecordReferences(Hashtable<Integer, Integer> oldToNewReferencesLookup) {
        Integer newLocation;
        if (this.lastUserEditAtomOffset != 0) {
            newLocation = oldToNewReferencesLookup.get(this.lastUserEditAtomOffset);
            if (newLocation == null) {
                throw new RuntimeException("Couldn't find the new location of the UserEditAtom that used to be at " + this.lastUserEditAtomOffset);
            }
            this.lastUserEditAtomOffset = newLocation;
        }
        if ((newLocation = oldToNewReferencesLookup.get(this.persistPointersOffset)) == null) {
            throw new RuntimeException("Couldn't find the new location of the PersistPtr that used to be at " + this.persistPointersOffset);
        }
        this.persistPointersOffset = newLocation;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        UserEditAtom.writeLittleEndian(this.lastViewedSlideID, out);
        UserEditAtom.writeLittleEndian(this.pptVersion, out);
        UserEditAtom.writeLittleEndian(this.lastUserEditAtomOffset, out);
        UserEditAtom.writeLittleEndian(this.persistPointersOffset, out);
        UserEditAtom.writeLittleEndian(this.docPersistRef, out);
        UserEditAtom.writeLittleEndian(this.maxPersistWritten, out);
        UserEditAtom.writeLittleEndian(this.lastViewType, out);
        UserEditAtom.writeLittleEndian(this.unused, out);
        if (this.encryptSessionPersistIdRef != -1) {
            UserEditAtom.writeLittleEndian(this.encryptSessionPersistIdRef, out);
        }
    }
}

