/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import org.lobobrowser.html.renderer.FloatingBounds;
import org.lobobrowser.util.Objects;

class FloatingViewportBounds
implements FloatingBounds {
    private final FloatingBounds prevBounds;
    private final boolean leftFloat;
    private final int y;
    private final int offsetFromBorder;
    private final int height;

    public FloatingViewportBounds(FloatingBounds prevBounds, boolean leftFloat, int y, int offsetFromBorder, int height) {
        this.prevBounds = prevBounds;
        this.leftFloat = leftFloat;
        this.y = y;
        this.offsetFromBorder = offsetFromBorder;
        this.height = height;
    }

    public int getLeft(int y) {
        int newLeft;
        FloatingBounds prev;
        int left = 0;
        if (this.leftFloat && y >= this.y && y < this.y + this.height) {
            left = this.offsetFromBorder;
        }
        if ((prev = this.prevBounds) != null && (newLeft = prev.getLeft(y)) > left) {
            left = newLeft;
        }
        return left;
    }

    public int getRight(int y) {
        int newRight;
        FloatingBounds prev;
        int right = 0;
        if (!this.leftFloat && y >= this.y && y < this.y + this.height) {
            right = this.offsetFromBorder;
        }
        if ((prev = this.prevBounds) != null && (newRight = prev.getRight(y)) > right) {
            right = newRight;
        }
        return right;
    }

    public int getClearY(int y) {
        int pcy;
        int cleary = Math.max(y, this.y + this.height);
        FloatingBounds prev = this.prevBounds;
        if (prev != null && (pcy = prev.getClearY(y)) > cleary) {
            cleary = pcy;
        }
        return cleary;
    }

    public int getFirstClearY(int y) {
        int prevClearY;
        int clearY = y;
        FloatingBounds prev = this.prevBounds;
        if (prev != null && (prevClearY = prev.getFirstClearY(y)) != y) {
            clearY = prevClearY;
        }
        if (clearY == y && y >= this.y && y < this.y + this.height) {
            clearY = this.y + this.height;
        }
        return clearY;
    }

    public int getLeftClearY(int y) {
        int pcy;
        int cleary = this.leftFloat ? Math.max(y, this.y + this.height) : y;
        FloatingBounds prev = this.prevBounds;
        if (prev != null && (pcy = prev.getLeftClearY(y)) > cleary) {
            cleary = pcy;
        }
        return cleary;
    }

    public int getRightClearY(int y) {
        int pcy;
        int cleary = !this.leftFloat ? Math.max(y, this.y + this.height) : y;
        FloatingBounds prev = this.prevBounds;
        if (prev != null && (pcy = prev.getLeftClearY(y)) > cleary) {
            cleary = pcy;
        }
        return cleary;
    }

    public int getMaxY() {
        int prevMaxY;
        int maxY = this.y + this.height;
        FloatingBounds prev = this.prevBounds;
        if (prev != null && (prevMaxY = prev.getMaxY()) > maxY) {
            maxY = prevMaxY;
        }
        return maxY;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FloatingViewportBounds)) {
            return false;
        }
        FloatingViewportBounds olm = (FloatingViewportBounds)other;
        return olm.leftFloat == this.leftFloat && olm.y == this.y && olm.height == this.height && olm.offsetFromBorder == this.offsetFromBorder && Objects.equals(olm.prevBounds, this.prevBounds);
    }

    public int hashCode() {
        return (this.leftFloat ? 1 : 0) ^ this.y ^ this.height ^ this.offsetFromBorder;
    }
}

