/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class CompositeFileInputStream
extends FilterInputStream {
    Iterator<File> filenames;

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c == -1 && this.filenames.hasNext()) {
            this.cueStream();
            return this.read();
        }
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int c = super.read(b, off, len);
        if (c == -1 && this.filenames.hasNext()) {
            this.cueStream();
            return this.read(b, off, len);
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int c = super.read(b);
        if (c == -1 && this.filenames.hasNext()) {
            this.cueStream();
            return this.read(b);
        }
        return c;
    }

    @Override
    public long skip(long n) throws IOException {
        long s = super.skip(n);
        if (s < n && this.filenames.hasNext()) {
            this.cueStream();
            return s + this.skip(n - s);
        }
        return s;
    }

    public CompositeFileInputStream(List<File> files) throws IOException {
        super(null);
        this.filenames = files.iterator();
        this.cueStream();
    }

    private void cueStream() throws IOException {
        if (this.filenames.hasNext()) {
            this.in = new FileInputStream(this.filenames.next());
        }
    }
}

