/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip.zipnum;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.util.GeneralURIStreamFactory;
import org.archive.util.HMACSigner;
import org.archive.util.binsearch.SeekableLineReader;
import org.archive.util.binsearch.SeekableLineReaderFactory;
import org.archive.util.binsearch.impl.HTTPSeekableLineReader;
import org.archive.util.binsearch.impl.HTTPSeekableLineReaderFactory;
import org.archive.util.io.RuntimeIOException;

public class ZipNumBlockLoader {
    private static final Logger LOGGER = Logger.getLogger(ZipNumBlockLoader.class.getName());
    protected Map<String, SeekableLineReaderFactory> fileFactoryMap = null;
    protected HTTPSeekableLineReaderFactory httpFactory = null;
    static final int DEFAULT_SIG_DURATION_SECS = 10;
    protected HMACSigner signer;
    protected int signDurationSecs = 10;
    protected boolean useNio = false;
    protected String httpLib = HTTPSeekableLineReaderFactory.HttpLibs.APACHE_31.name();
    protected boolean bufferFully = true;
    protected boolean noKeepAlive = true;
    protected String cookie = null;
    protected int maxHostConnections = 100000;
    protected int maxTotalConnections = 100000;
    protected int connectTimeoutMS = 10000;
    protected int readTimeoutMS = 10000;
    protected int numRetries = -1;
    protected boolean staleChecking = false;
    private static ThreadLocal<Map<String, SeekableLineReader>> slrMap = new ThreadLocal<Map<String, SeekableLineReader>>(){

        @Override
        protected Map<String, SeekableLineReader> initialValue() {
            return new HashMap<String, SeekableLineReader>();
        }
    };

    public static void closeAllReaders() {
        for (Map.Entry<String, SeekableLineReader> entry : slrMap.get().entrySet()) {
            try {
                SeekableLineReader reader = entry.getValue();
                if (reader.isClosed()) continue;
                LOGGER.warning("Unclosed reader for: " + entry.getKey());
                reader.close();
            }
            catch (IOException iOException) {}
        }
        slrMap.get().clear();
    }

    public SeekableLineReader createBlockReader(String uri) throws IOException {
        SeekableLineReader reader = null;
        reader = GeneralURIStreamFactory.isHttp(uri) ? this.getHttpReader(uri) : this.getFileReader(uri);
        slrMap.get().put(uri, reader);
        return reader;
    }

    protected HTTPSeekableLineReader getHttpReader(String url) throws IOException {
        if (this.httpFactory == null) {
            this.httpFactory = HTTPSeekableLineReaderFactory.getHttpFactory(HTTPSeekableLineReaderFactory.HttpLibs.valueOf(this.httpLib), null);
            this.httpFactory.setMaxHostConnections(this.maxHostConnections);
            this.httpFactory.setMaxTotalConnections(this.maxTotalConnections);
            this.httpFactory.setConnectionTimeoutMS(this.connectTimeoutMS);
            this.httpFactory.setSocketTimeoutMS(this.readTimeoutMS);
            this.httpFactory.setStaleChecking(this.staleChecking);
            if (this.numRetries >= 0) {
                this.httpFactory.setNumRetries(this.numRetries);
            }
        }
        HTTPSeekableLineReader reader = this.httpFactory.get(url);
        reader.setBufferFully(this.bufferFully);
        reader.setNoKeepAlive(this.noKeepAlive);
        String reqCookie = this.cookie;
        if (this.signer != null) {
            reqCookie = this.signer.getHMacCookieStr(this.signDurationSecs);
        }
        if (reqCookie != null) {
            reader.setCookie(reqCookie);
        }
        return reader;
    }

    protected SeekableLineReader getFileReader(String filename) throws IOException {
        SeekableLineReaderFactory factory;
        if (this.fileFactoryMap == null) {
            this.fileFactoryMap = new HashMap<String, SeekableLineReaderFactory>();
            this.fileFactoryMap = Collections.synchronizedMap(this.fileFactoryMap);
        }
        if ((factory = this.fileFactoryMap.get(filename)) == null) {
            factory = GeneralURIStreamFactory.createSeekableStreamFactory(filename, this.useNio);
            this.fileFactoryMap.put(filename, factory);
        }
        SeekableLineReader reader = factory.get();
        reader.setBufferFully(this.bufferFully);
        return reader;
    }

    public SeekableLineReader attemptLoadBlock(String location, long startOffset, int totalLength, boolean decompress, boolean isRequired) {
        SeekableLineReader currReader;
        block8: {
            currReader = null;
            try {
                currReader = this.createBlockReader(location);
                currReader.seekWithMaxRead(startOffset, decompress, totalLength);
            }
            catch (IOException io) {
                Level level = isRequired ? Level.SEVERE : Level.WARNING;
                String actualLocation = null;
                if (currReader instanceof HTTPSeekableLineReader) {
                    actualLocation = ((HTTPSeekableLineReader)currReader).getConnectedUrl();
                }
                if (actualLocation == null) {
                    actualLocation = location;
                }
                String msg = io.toString() + " -- -r " + startOffset + "-" + (startOffset + (long)totalLength - 1L) + " " + actualLocation;
                if (LOGGER.isLoggable(level)) {
                    LOGGER.log(level, msg);
                }
                if (currReader != null) {
                    try {
                        currReader.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    currReader = null;
                }
                if (!isRequired) break block8;
                throw new RuntimeIOException(msg);
            }
        }
        return currReader;
    }

    public void closeFileFactory(String filename) throws IOException {
        if (this.fileFactoryMap == null) {
            return;
        }
        SeekableLineReaderFactory factory = this.fileFactoryMap.remove(filename);
        if (factory != null) {
            factory.close();
        }
    }

    public void close() throws IOException {
        if (this.fileFactoryMap != null) {
            for (SeekableLineReaderFactory factory : this.fileFactoryMap.values()) {
                factory.close();
            }
            this.fileFactoryMap = null;
        }
        if (this.httpFactory != null) {
            this.httpFactory.close();
            this.httpFactory = null;
        }
    }

    public boolean isUseNio() {
        return this.useNio;
    }

    public void setUseNio(boolean useNio) {
        this.useNio = useNio;
    }

    public boolean isBufferFully() {
        return this.bufferFully;
    }

    public void setBufferFully(boolean bufferFully) {
        this.bufferFully = bufferFully;
    }

    public boolean isNoKeepAlive() {
        return this.noKeepAlive;
    }

    public void setNoKeepAlive(boolean noKeepAlive) {
        this.noKeepAlive = noKeepAlive;
    }

    public int getMaxHostConnections() {
        return this.maxHostConnections;
    }

    public void setMaxHostConnections(int maxHostConnections) {
        this.maxHostConnections = maxHostConnections;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getConnectTimeoutMS() {
        return this.connectTimeoutMS;
    }

    public void setConnectTimeoutMS(int connectTimeoutMS) {
        this.connectTimeoutMS = connectTimeoutMS;
    }

    public int getReadTimeoutMS() {
        return this.readTimeoutMS;
    }

    public void setReadTimeoutMS(int readTimeoutMS) {
        this.readTimeoutMS = readTimeoutMS;
    }

    public int getNumRetries() {
        return this.numRetries;
    }

    public void setNumRetries(int numRetries) {
        this.numRetries = numRetries;
    }

    public void setStaleChecking(boolean staleChecking) {
        this.staleChecking = staleChecking;
    }

    public boolean isStaleChecking() {
        return this.staleChecking;
    }

    public String getHttpLib() {
        return this.httpLib;
    }

    public void setHttpLib(String httpLib) {
        this.httpLib = httpLib;
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public HMACSigner getSigner() {
        return this.signer;
    }

    public void setSigner(HMACSigner signer) {
        this.signer = signer;
    }

    public int getSignDurationSecs() {
        return this.signDurationSecs;
    }

    public void setSignDurationSecs(int signDurationSecs) {
        this.signDurationSecs = signDurationSecs;
    }
}

