/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.binsearch.impl;

import com.google.common.io.LimitInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.archive.util.binsearch.AbstractSeekableLineReader;

public class HDFSSeekableLineReader
extends AbstractSeekableLineReader {
    private FSDataInputStream fsdis;
    private long length;

    public HDFSSeekableLineReader(FSDataInputStream fsdis, long length, int blockSize) {
        super(blockSize);
        this.fsdis = fsdis;
        this.length = length;
    }

    @Override
    public InputStream doSeekLoad(long offset, int maxLength) throws IOException {
        this.fsdis.seek(offset);
        if (maxLength >= 0) {
            return new LimitInputStream((InputStream)this.fsdis, (long)maxLength);
        }
        return this.fsdis;
    }

    public long getOffset() throws IOException {
        return this.fsdis.getPos();
    }

    @Override
    public void doClose() throws IOException {
        this.fsdis = null;
    }

    @Override
    public long getSize() throws IOException {
        return this.length;
    }
}

