/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.dictionary;

import com.hankcs.hanlp.corpus.dictionary.CommonDictionaryMaker;
import com.hankcs.hanlp.corpus.dictionary.EasyDictionary;
import com.hankcs.hanlp.corpus.document.CorpusLoader;
import com.hankcs.hanlp.corpus.document.Document;
import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.corpus.tag.NR;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.utility.Predefine;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class NRDictionaryMaker
extends CommonDictionaryMaker {
    public NRDictionaryMaker(EasyDictionary dictionary) {
        super(dictionary);
    }

    @Override
    protected void addToDictionary(List<List<IWord>> sentenceList) {
        Predefine.logger.warning("\u5f00\u59cb\u5236\u4f5c\u8bcd\u5178");
        for (List<IWord> wordList : sentenceList) {
            for (IWord word : wordList) {
                if (word.getLabel().equals(NR.A.toString())) continue;
                this.dictionaryMaker.add(word);
            }
        }
        for (List<IWord> wordList : sentenceList) {
            IWord pre = null;
            for (IWord word : wordList) {
                if (pre != null) {
                    this.nGramDictionaryMaker.addPair(pre, word);
                }
                pre = word;
            }
        }
    }

    @Override
    protected void roleTag(List<List<IWord>> sentenceList) {
        Predefine.logger.info("\u5f00\u59cb\u6807\u6ce8\u89d2\u8272");
        int i = 0;
        for (List<IWord> wordList : sentenceList) {
            String combine;
            IWord word;
            Predefine.logger.info(String.valueOf(++i) + " / " + sentenceList.size());
            if (verbose) {
                System.out.println("\u539f\u59cb\u8bed\u6599 " + wordList);
            }
            IWord pre = new Word("##\u59cb##", "begin");
            ListIterator<IWord> listIterator = wordList.listIterator();
            while (listIterator.hasNext()) {
                IWord word2 = listIterator.next();
                if (!word2.getLabel().equals(Nature.nr.toString())) {
                    word2.setLabel(NR.A.toString());
                } else if (!pre.getLabel().equals(Nature.nr.toString())) {
                    pre.setLabel(NR.K.toString());
                }
                pre = word2;
            }
            if (verbose) {
                System.out.println("\u6807\u6ce8\u975e\u524d " + wordList);
            }
            IWord next = new Word("##\u672b##", "end");
            while (listIterator.hasPrevious()) {
                word = listIterator.previous();
                if (word.getLabel().equals(Nature.nr.toString())) {
                    String label = next.getLabel();
                    if (label.equals("A")) {
                        next.setLabel("L");
                    } else if (label.equals("K")) {
                        next.setLabel("M");
                    }
                }
                next = word;
            }
            if (verbose) {
                System.out.println("\u6807\u6ce8\u4e2d\u540e " + wordList);
            }
            listIterator = wordList.listIterator();
            while (listIterator.hasNext()) {
                word = listIterator.next();
                if (!word.getLabel().equals(Nature.nr.toString())) continue;
                switch (word.getValue().length()) {
                    case 2: {
                        if (word.getValue().startsWith("\u5927") || word.getValue().startsWith("\u8001") || word.getValue().startsWith("\u5c0f")) {
                            listIterator.add(new Word(word.getValue().substring(1, 2), NR.B.toString()));
                            word.setValue(word.getValue().substring(0, 1));
                            word.setLabel(NR.F.toString());
                            break;
                        }
                        if (word.getValue().endsWith("\u54e5") || word.getValue().endsWith("\u516c") || word.getValue().endsWith("\u59d0") || word.getValue().endsWith("\u8001") || word.getValue().endsWith("\u67d0") || word.getValue().endsWith("\u5ac2") || word.getValue().endsWith("\u6c0f") || word.getValue().endsWith("\u603b")) {
                            listIterator.add(new Word(word.getValue().substring(1, 2), NR.G.toString()));
                            word.setValue(word.getValue().substring(0, 1));
                            word.setLabel(NR.B.toString());
                            break;
                        }
                        listIterator.add(new Word(word.getValue().substring(1, 2), NR.E.toString()));
                        word.setValue(word.getValue().substring(0, 1));
                        word.setLabel(NR.B.toString());
                        break;
                    }
                    case 3: {
                        listIterator.add(new Word(word.getValue().substring(1, 2), NR.C.toString()));
                        listIterator.add(new Word(word.getValue().substring(2, 3), NR.D.toString()));
                        word.setValue(word.getValue().substring(0, 1));
                        word.setLabel(NR.B.toString());
                    }
                }
            }
            if (verbose) {
                System.out.println("\u59d3\u540d\u62c6\u5206 " + wordList);
            }
            listIterator = wordList.listIterator();
            pre = new Word("##\u59cb##", "begin");
            while (listIterator.hasNext()) {
                word = listIterator.next();
                if (word.getLabel().equals(NR.B.toString()) && this.dictionary.contains(combine = String.valueOf(pre.getValue()) + word.getValue())) {
                    pre.setValue(combine);
                    pre.setLabel("U");
                    listIterator.remove();
                }
                pre = word;
            }
            if (verbose) {
                System.out.println("\u4e0a\u6587\u6210\u8bcd " + wordList);
            }
            next = new Word("##\u672b##", "end");
            while (listIterator.hasPrevious()) {
                word = listIterator.previous();
                if (word.getLabel().equals(NR.B.toString()) && this.dictionary.contains(combine = String.valueOf(word.getValue()) + next.getValue())) {
                    next.setValue(combine);
                    next.setLabel(next.getLabel().equals(NR.C.toString()) ? NR.X.toString() : NR.Y.toString());
                    listIterator.remove();
                }
                next = word;
            }
            if (verbose) {
                System.out.println("\u5934\u90e8\u6210\u8bcd " + wordList);
            }
            pre = new Word("##\u59cb##", "begin");
            while (listIterator.hasNext()) {
                word = listIterator.next();
                if (word.getLabel().equals(NR.D.toString()) && this.dictionary.contains(combine = String.valueOf(pre.getValue()) + word.getValue())) {
                    pre.setValue(combine);
                    pre.setLabel(NR.Z.toString());
                    listIterator.remove();
                }
                pre = word;
            }
            if (verbose) {
                System.out.println("\u5c3e\u90e8\u6210\u8bcd " + wordList);
            }
            next = new Word("##\u672b##", "end");
            while (listIterator.hasPrevious()) {
                word = listIterator.previous();
                if (word.getLabel().equals(NR.D.toString()) && this.dictionary.contains(combine = String.valueOf(word.getValue()) + next.getValue())) {
                    next.setValue(combine);
                    next.setLabel(NR.V.toString());
                    listIterator.remove();
                }
                next = word;
            }
            if (verbose) {
                System.out.println("\u5934\u90e8\u6210\u8bcd " + wordList);
            }
            LinkedList wordLinkedList = (LinkedList)wordList;
            wordLinkedList.addFirst(new Word("\u59cb##\u59cb", "S"));
            wordLinkedList.addLast(new Word("\u672b##\u672b", "A"));
            if (!verbose) continue;
            System.out.println("\u6dfb\u52a0\u9996\u5c3e " + wordList);
        }
    }

    public static void main(String[] args) {
        EasyDictionary dictionary = EasyDictionary.create("data/dictionary/2014_dictionary.txt");
        NRDictionaryMaker nrDictionaryMaker = new NRDictionaryMaker(dictionary);
        CorpusLoader.walk("data/corpus/2014/", new CorpusLoader.Handler(){

            @Override
            public void handle(Document document) {
                List<List<Word>> simpleSentenceList = document.getSimpleSentenceList();
                LinkedList<List<IWord>> compatibleList = new LinkedList<List<IWord>>();
                for (List<Word> wordList : simpleSentenceList) {
                    compatibleList.add(new LinkedList<Word>(wordList));
                }
                NRDictionaryMaker.this.compute(compatibleList);
            }
        });
        nrDictionaryMaker.saveTxtTo("D:\\JavaProjects\\HanLP\\data\\dictionary\\person\\nr1");
    }
}

