/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

public class CharSubSequence
implements CharSequence {
    protected CharSequence inner;
    protected int start;
    protected int end;

    public CharSubSequence(CharSequence inner, int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("Start " + start + " is > " + " than end " + end);
        }
        if (end < 0 || start < 0) {
            throw new IllegalArgumentException("Start " + start + " or end " + end + " is < 0.");
        }
        if (inner == null) {
            throw new NullPointerException("Passed charsequence is null.");
        }
        this.inner = inner;
        this.start = start;
        this.end = end;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public char charAt(int index) {
        return this.inner.charAt(this.start + index);
    }

    @Override
    public CharSequence subSequence(int begin, int finish) {
        return new CharSubSequence(this, begin, finish);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(this.length());
        for (int i = 0; i < this.length(); ++i) {
            sb.append(this.charAt(i));
        }
        return sb.toString();
    }
}

