/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.binsearch.impl.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.io.input.CountingInputStream;
import org.archive.util.binsearch.impl.HTTPSeekableLineReader;

public class ApacheHttp31SLR
extends HTTPSeekableLineReader {
    private HttpClient http;
    private String url;
    private long length = -1L;
    protected CountingInputStream cin;
    private GetMethod activeMethod;

    public ApacheHttp31SLR(HttpClient http, String url) {
        this.http = http;
        this.url = url;
    }

    private void acquireLength() throws URISyntaxException, HttpException, IOException {
        HeadMethod head = new HeadMethod(this.url);
        int code = this.http.executeMethod((HttpMethod)head);
        if (code != 200) {
            throw new IOException("Unable to retrieve from " + this.url);
        }
        Header lengthHeader = head.getResponseHeader("Content-Length");
        if (lengthHeader == null) {
            throw new IOException("No Content-Length header for " + this.url);
        }
        String val = lengthHeader.getValue();
        try {
            this.length = Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            throw new IOException("Bad Content-Length value " + this.url + ": " + val);
        }
    }

    protected String getHeader(String header) throws URISyntaxException, HttpException, IOException {
        HeadMethod head = new HeadMethod(this.url);
        int code = this.http.executeMethod((HttpMethod)head);
        if (code != 200) {
            throw new IOException("Unable to retrieve from " + this.url);
        }
        Header theHeader = head.getResponseHeader(header);
        if (theHeader == null) {
            throw new IOException("No " + header + " header for " + this.url);
        }
        String val = theHeader.getValue();
        return val;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    protected InputStream doSeekLoad(long offset, int maxLength) throws IOException {
        if (this.activeMethod != null) {
            this.doClose();
        }
        this.br = null;
        try {
            this.activeMethod = new GetMethod(this.url);
            String rangeHeader = ApacheHttp31SLR.makeRangeHeader(offset, maxLength);
            if (rangeHeader != null) {
                this.activeMethod.setRequestHeader("Range", rangeHeader);
            }
            if (this.isNoKeepAlive()) {
                this.activeMethod.setRequestHeader("Connection", "close");
            }
            if (this.getCookie() != null) {
                this.activeMethod.getParams().setCookiePolicy("ignoreCookies");
                this.activeMethod.setRequestHeader("Cookie", this.getCookie());
            }
            int code = this.http.executeMethod((HttpMethod)this.activeMethod);
            this.connectedUrl = this.activeMethod.getURI().toString();
            if (code != 206 && code != 200) {
                throw new HTTPSeekableLineReader.BadHttpStatusException(code, this.connectedUrl + " " + rangeHeader);
            }
            InputStream is = this.activeMethod.getResponseBodyAsStream();
            this.cin = new CountingInputStream(is);
            return this.cin;
        }
        catch (IOException io) {
            if (this.saveErrHeader != null) {
                this.errHeader = this.getHeaderValue(this.saveErrHeader);
            }
            this.connectedUrl = this.activeMethod.getURI().toString();
            this.doClose();
            throw io;
        }
    }

    public GetMethod getHttpMethod() {
        return this.activeMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doClose() throws IOException {
        if (this.activeMethod == null) {
            return;
        }
        try {
            long bytesRead;
            long contentLength = this.activeMethod.getResponseContentLength();
            long l = bytesRead = this.cin != null ? this.cin.getByteCount() : 0L;
            if (contentLength <= 0L || contentLength != bytesRead) {
                this.activeMethod.abort();
            }
            this.activeMethod.releaseConnection();
            this.activeMethod = null;
        }
        finally {
            if (this.activeMethod != null) {
                this.activeMethod.abort();
                this.activeMethod.releaseConnection();
                this.activeMethod = null;
            }
        }
        this.cin = null;
        this.is = null;
        this.br = null;
    }

    @Override
    public long getSize() throws IOException {
        if (this.length < 0L) {
            try {
                if (this.activeMethod != null) {
                    this.length = this.activeMethod.getResponseContentLength();
                } else {
                    this.acquireLength();
                }
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return this.length;
    }

    @Override
    public String getHeaderValue(String headerName) {
        if (this.activeMethod == null) {
            return null;
        }
        Header header = this.activeMethod.getResponseHeader(headerName);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }
}

