/*
 * Decompiled with CFR 0.152.
 */
package org.archive.url;

import gnu.inet.encoding.IDNA;
import gnu.inet.encoding.IDNAException;
import it.unimi.dsi.mg4j.util.MutableString;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.archive.url.LaxURLCodec;
import org.archive.url.UsableURI;
import org.archive.util.TextUtils;

public class UsableURIFactory
extends URI {
    private static final long serialVersionUID = -6146295130382209042L;
    private static Logger logger = Logger.getLogger(UsableURIFactory.class.getName());
    private static final UsableURIFactory factory = new UsableURIFactory();
    public static final Pattern RFC2396REGEX = Pattern.compile("^(([a-zA-Z][a-zA-Z0-9\\+\\-\\.]*):)?((//([^/?#]*))?([^?#]*)(\\?([^#]*))?)?(#(.*))?");
    public static final String SLASHDOTDOTSLASH = "^(/\\.\\./)+";
    public static final String SLASH = "/";
    public static final String HTTP = "http";
    public static final String HTTP_PORT = ":80";
    public static final String HTTPS = "https";
    public static final String HTTPS_PORT = ":443";
    public static final String DOT = ".";
    public static final String EMPTY_STRING = "";
    public static final String NBSP = "\u00a0";
    public static final String SPACE = " ";
    public static final String ESCAPED_SPACE = "%20";
    public static final String TRAILING_ESCAPED_SPACE = "^(.*)(%20)+$";
    public static final String PIPE = "|";
    public static final String PIPE_PATTERN = "\\|";
    public static final String ESCAPED_PIPE = "%7C";
    public static final String CIRCUMFLEX = "^";
    public static final String CIRCUMFLEX_PATTERN = "\\^";
    public static final String ESCAPED_CIRCUMFLEX = "%5E";
    public static final String QUOT = "\"";
    public static final String ESCAPED_QUOT = "%22";
    public static final String SQUOT = "'";
    public static final String ESCAPED_SQUOT = "%27";
    public static final String APOSTROPH = "`";
    public static final String ESCAPED_APOSTROPH = "%60";
    public static final String LSQRBRACKET = "[";
    public static final String LSQRBRACKET_PATTERN = "\\[";
    public static final String ESCAPED_LSQRBRACKET = "%5B";
    public static final String RSQRBRACKET = "]";
    public static final String RSQRBRACKET_PATTERN = "\\]";
    public static final String ESCAPED_RSQRBRACKET = "%5D";
    public static final String LCURBRACKET = "{";
    public static final String LCURBRACKET_PATTERN = "\\{";
    public static final String ESCAPED_LCURBRACKET = "%7B";
    public static final String RCURBRACKET = "}";
    public static final String RCURBRACKET_PATTERN = "\\}";
    public static final String ESCAPED_RCURBRACKET = "%7D";
    public static final String BACKSLASH = "\\";
    public static final String ESCAPED_BACKSLASH = "%5C";
    public static final String STRAY_SPACING = "[\n\r\t]+";
    public static final String IMPROPERESC_REPLACE = "%25$1";
    public static final String IMPROPERESC = "%((?:[^\\p{XDigit}])|(?:.[^\\p{XDigit}])|(?:\\z))";
    public static final String COMMERCIAL_AT = "@";
    public static final char PERCENT_SIGN = '%';
    public static final char COLON = ':';
    public static final String URI_HEX_ENCODING = "^[^%]*%[\\p{XDigit}][\\p{XDigit}].*";
    protected static final Pattern PORTREGEX = Pattern.compile("(.*:)([0-9]+)$");
    protected static final String ACCEPTABLE_ASCII_DOMAIN = "^(?:[a-zA-Z0-9_-]++(?:\\.)?)++$";
    protected static final Pattern HTTP_SCHEME_SLASHES = Pattern.compile("^(https?://)/+(.*)");
    static final Pattern MULTIPLE_SLASHES = Pattern.compile("//+");

    protected UsableURIFactory() {
    }

    public static UsableURI getInstance(String uri) throws URIException {
        return factory.create(uri);
    }

    public static UsableURI getInstance(String uri, String charset) throws URIException {
        return factory.create(uri, charset);
    }

    public static UsableURI getInstance(UsableURI base, String relative) throws URIException {
        return factory.create(base, relative);
    }

    protected UsableURI create(String uri) throws URIException {
        return this.create(uri, UsableURI.getDefaultProtocolCharset());
    }

    protected UsableURI create(String uri, String charset) throws URIException {
        UsableURI uuri = this.makeOne(this.fixup(uri, null, charset), true, charset);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("URI " + uri + " PRODUCT " + uuri.toString() + " CHARSET " + charset);
        }
        return this.validityCheck(uuri);
    }

    protected UsableURI makeOne(String fixedUpUri, boolean escaped, String charset) throws URIException {
        return new UsableURI(fixedUpUri, escaped, charset);
    }

    protected UsableURI makeOne(UsableURI base, UsableURI relative) throws URIException {
        return new UsableURI(base, relative);
    }

    protected UsableURI create(UsableURI base, String relative) throws URIException {
        UsableURI relativeUURI = this.makeOne(this.fixup(relative, base, base.getProtocolCharset()), true, base.getProtocolCharset());
        UsableURI uuri = this.makeOne(base, relativeUURI);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" URI " + relative + " PRODUCT " + uuri.toString() + " CHARSET " + base.getProtocolCharset() + " BASE " + base);
        }
        return this.validityCheck(uuri);
    }

    protected UsableURI validityCheck(UsableURI uuri) throws URIException {
        if (uuri.getRawURI().length > 2083) {
            throw new URIException("Created (escaped) uuri > 2083: " + uuri.toString());
        }
        return uuri;
    }

    private String fixup(String uri, URI base, String charset) throws URIException {
        int nextBackslash;
        if (uri == null) {
            throw new NullPointerException();
        }
        if (uri.length() == 0 && base == null) {
            throw new URIException("URI length is zero (and not relative).");
        }
        if (uri.length() > 2083) {
            throw new URIException("URI length > 2083: " + uri);
        }
        if (uri.indexOf(NBSP) >= 0) {
            uri = TextUtils.replaceAll(NBSP, uri, SPACE);
        }
        if ((nextBackslash = (uri = uri.trim()).indexOf(BACKSLASH)) >= 0) {
            int queryStart = uri.indexOf(63);
            StringBuilder tmp = new StringBuilder(uri);
            while (nextBackslash >= 0 && (queryStart < 0 || nextBackslash < queryStart)) {
                tmp.setCharAt(nextBackslash, '/');
                nextBackslash = uri.indexOf(BACKSLASH, nextBackslash + 1);
            }
            uri = tmp.toString();
        }
        uri = TextUtils.replaceAll(STRAY_SPACING, uri, EMPTY_STRING);
        Matcher matcher = TextUtils.getMatcher(HTTP_SCHEME_SLASHES.pattern(), uri);
        if (matcher.matches()) {
            uri = matcher.group(1) + matcher.group(2);
        }
        TextUtils.recycleMatcher(matcher);
        uri = this.escapeWhitespace(uri);
        matcher = TextUtils.getMatcher(RFC2396REGEX.pattern(), uri);
        if (!matcher.matches()) {
            throw new URIException("Failed parse of " + uri);
        }
        String uriScheme = this.checkUriElementAndLowerCase(matcher.group(2));
        String uriSchemeSpecificPart = this.checkUriElement(matcher.group(3));
        String uriAuthority = this.checkUriElement(matcher.group(5));
        String uriPath = this.checkUriElement(matcher.group(6));
        String uriQuery = this.checkUriElement(matcher.group(8));
        TextUtils.recycleMatcher(matcher);
        matcher = null;
        if (uriScheme == null || uriScheme.length() <= 0) {
            if (base == null) {
                throw new URIException("Relative URI but no base: " + uri);
            }
        } else {
            this.checkHttpSchemeSpecificPartSlashPrefix(base, uriScheme, uriSchemeSpecificPart);
        }
        uriAuthority = this.fixupAuthority(uriAuthority, charset);
        if (uriSchemeSpecificPart != null && uriSchemeSpecificPart.startsWith(SLASH)) {
            if (uriPath != null) {
                uriPath = TextUtils.replaceFirst(SLASHDOTDOTSLASH, uriPath, SLASH);
            }
            if (uriPath == null || EMPTY_STRING.equals(uriPath)) {
                uriPath = SLASH;
            }
        }
        if (uriAuthority != null) {
            if (uriScheme != null && uriScheme.length() > 0 && uriScheme.equals(HTTP)) {
                uriAuthority = this.checkPort(uriAuthority);
                uriAuthority = UsableURIFactory.stripTail(uriAuthority, HTTP_PORT);
            } else if (uriScheme != null && uriScheme.length() > 0 && uriScheme.equals(HTTPS)) {
                uriAuthority = this.checkPort(uriAuthority);
                uriAuthority = UsableURIFactory.stripTail(uriAuthority, HTTPS_PORT);
            }
            uriAuthority = UsableURIFactory.stripTail(uriAuthority, DOT);
            uriAuthority = this.stripPrefix(uriAuthority, DOT);
        } else if (uriScheme != null && base != null && uriScheme.equals(base.getScheme())) {
            uriScheme = null;
        }
        uriPath = this.ensureMinimalEscaping(uriPath, charset);
        uriQuery = this.ensureMinimalEscaping(uriQuery, charset, LaxURLCodec.QUERY_SAFE);
        MutableString s = new MutableString((uriScheme != null ? uriScheme.length() : 0) + 1 + (uriAuthority != null ? uriAuthority.length() : 0) + 2 + (uriPath != null ? uriPath.length() : 0) + 1 + (uriQuery != null ? uriQuery.length() : 0));
        this.appendNonNull(s, uriScheme, ":", true);
        this.appendNonNull(s, uriAuthority, "//", false);
        this.appendNonNull(s, uriPath, EMPTY_STRING, false);
        this.appendNonNull(s, uriQuery, "?", false);
        return s.toString();
    }

    protected void checkHttpSchemeSpecificPartSlashPrefix(URI base, String scheme, String schemeSpecificPart) throws URIException {
        if (scheme == null || scheme.length() <= 0) {
            return;
        }
        if (!scheme.equals(HTTP) && !scheme.equals(HTTPS)) {
            return;
        }
        if (schemeSpecificPart == null || !schemeSpecificPart.startsWith("//")) {
            if (base == null || !scheme.equals(base.getScheme())) {
                throw new URIException("relative URI with scheme only allowed for scheme matching base");
            }
            return;
        }
        if (schemeSpecificPart.length() <= 2) {
            throw new URIException("http scheme specific part is too short: " + schemeSpecificPart);
        }
    }

    private String fixupAuthority(String uriAuthority, String charset) throws URIException {
        if (uriAuthority != null) {
            while (uriAuthority.endsWith(ESCAPED_SPACE)) {
                uriAuthority = uriAuthority.substring(0, uriAuthority.length() - 3);
            }
            int atIndex = uriAuthority.indexOf(COMMERCIAL_AT);
            int portColonIndex = uriAuthority.indexOf(58, atIndex < 0 ? 0 : atIndex);
            if (atIndex < 0 && portColonIndex < 0) {
                return this.fixupDomainlabel(uriAuthority);
            }
            if (atIndex < 0 && portColonIndex > -1) {
                String domain = this.fixupDomainlabel(uriAuthority.substring(0, portColonIndex));
                String port = uriAuthority.substring(portColonIndex);
                return domain + port;
            }
            if (atIndex > -1 && portColonIndex < 0) {
                String userinfo = this.ensureMinimalEscaping(uriAuthority.substring(0, atIndex + 1), charset);
                String domain = this.fixupDomainlabel(uriAuthority.substring(atIndex + 1));
                return userinfo + domain;
            }
            String userinfo = this.ensureMinimalEscaping(uriAuthority.substring(0, atIndex + 1), charset);
            String domain = this.fixupDomainlabel(uriAuthority.substring(atIndex + 1, portColonIndex));
            String port = uriAuthority.substring(portColonIndex);
            return userinfo + domain + port;
        }
        return uriAuthority;
    }

    private String fixupDomainlabel(String label) throws URIException {
        block2: {
            try {
                label = IDNA.toASCII((String)label);
            }
            catch (IDNAException e) {
                if (TextUtils.matches(ACCEPTABLE_ASCII_DOMAIN, label)) break block2;
                URIException ue = new URIException((Object)((Object)e) + SPACE + label);
                ue.initCause((Throwable)e);
                throw ue;
            }
        }
        label = label.toLowerCase();
        return label;
    }

    private String ensureMinimalEscaping(String u, String charset) {
        return this.ensureMinimalEscaping(u, charset, LaxURLCodec.EXPANDED_URI_SAFE);
    }

    private String ensureMinimalEscaping(String u, String charset, BitSet bitset) {
        if (u == null) {
            return null;
        }
        for (int i = 0; i < u.length(); ++i) {
            char c = u.charAt(i);
            if (bitset.get(c)) continue;
            try {
                u = LaxURLCodec.DEFAULT.encode(bitset, u, charset);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            break;
        }
        return u;
    }

    protected String escapeWhitespace(String uri) {
        MutableString buffer = null;
        for (int i = 0; i < uri.length(); ++i) {
            char c = uri.charAt(i);
            if (Character.isWhitespace(c)) {
                if (buffer == null) {
                    buffer = new MutableString(uri.length() + 2);
                    buffer.append(uri.substring(0, i));
                }
                buffer.append("%");
                String hexStr = Integer.toHexString(c);
                if (hexStr.length() % 2 > 0) {
                    buffer.append("0");
                }
                buffer.append(hexStr);
                continue;
            }
            if (buffer == null) continue;
            buffer.append(c);
        }
        return buffer != null ? buffer.toString() : uri;
    }

    private String checkPort(String uriAuthority) throws URIException {
        String no;
        Matcher m = TextUtils.getMatcher(PORTREGEX.pattern(), uriAuthority);
        if (m.matches() && (no = m.group(2)) != null && no.length() > 0) {
            while (no.charAt(0) == '0' && no.length() > 1) {
                no = no.substring(1);
            }
            uriAuthority = m.group(1) + no;
            int portNo = 0;
            try {
                portNo = Integer.parseInt(no);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (portNo <= 0 || portNo > 65535) {
                throw new URIException("Port out of bounds: " + uriAuthority);
            }
        }
        TextUtils.recycleMatcher(m);
        return uriAuthority;
    }

    private void appendNonNull(MutableString b, String str, String substr, boolean suffix) {
        if (str != null && str.length() > 0) {
            if (!suffix) {
                b.append(substr);
            }
            b.append(str);
            if (suffix) {
                b.append(substr);
            }
        }
    }

    private String stripPrefix(String str, String prefix) {
        return str.startsWith(prefix) ? str.substring(prefix.length(), str.length()) : str;
    }

    private static String stripTail(String str, String tail) {
        return str.endsWith(tail) ? str.substring(0, str.length() - tail.length()) : str;
    }

    private String checkUriElement(String element) {
        return element == null || element.length() <= 0 ? null : element;
    }

    private String checkUriElementAndLowerCase(String element) {
        String tmp = this.checkUriElement(element);
        return tmp != null ? tmp.toLowerCase() : tmp;
    }
}

