/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.test.seg;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.io.FolderWalker;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.seg.Dijkstra.DijkstraSegment;
import com.hankcs.hanlp.seg.NShort.NShortSegment;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.utility.SentencesUtil;
import java.io.File;
import java.util.List;
import junit.framework.TestCase;

public class TestPersonRecognition
extends TestCase {
    static final String FOLDER = "D:\\Doc\\\u8bed\u6599\u5e93\\\u4e0a\u6d77\u9759\u5b89\\";

    public void testBatch() throws Exception {
        List<File> fileList = FolderWalker.open(FOLDER);
        int i = 0;
        for (File file : fileList) {
            System.out.println(String.valueOf(++i) + " / " + fileList.size() + " " + file.getName() + " ");
            String path = file.getAbsolutePath();
            String content = IOUtil.readTxt(path);
            DijkstraSegment segment = new DijkstraSegment();
            List<List<Term>> sentenceList = segment.seg2sentence(content);
            for (List<Term> sentence : sentenceList) {
                if (!SentencesUtil.hasNature(sentence, Nature.nr)) continue;
                System.out.println(sentence);
            }
        }
    }

    public void testNameRecognition() throws Exception {
        HanLP.Config.enableDebug();
        NShortSegment segment = new NShortSegment();
        System.out.println(segment.seg("\u4e16\u754c\u4e0a\u6700\u957f\u7684\u59d3\u540d\u662f\u7b80\u68ee\u00b7\u4e54\u4f0a\u00b7\u4e9a\u5386\u5c71\u5927\u00b7\u6bd4\u57fa\u00b7\u5361\u5229\u65af\u52d2\u00b7\u8fbe\u592b\u00b7\u57c3\u5229\u5965\u7279\u00b7\u798f\u514b\u65af\u00b7\u4f0a\u7ef4\u9c81\u83ab\u00b7\u9a6c\u5c14\u5c3c\u00b7\u6885\u5c14\u65af\u00b7\u5e15\u7279\u68ee\u00b7\u6c64\u666e\u68ee\u00b7\u534e\u83b1\u58eb\u00b7\u666e\u96f7\u65af\u987f\u3002"));
    }

    public void testJPName() throws Exception {
        HanLP.Config.enableDebug();
        Segment segment = new DijkstraSegment().enableJapaneseNameRecognize(true);
        System.out.println(segment.seg("\u5317\u5ddd\u666f\u5b50\u53c2\u6f14\u4e86\u6797\u8be3\u5f6c\u5bfc\u6f14"));
    }

    public void testChineseNameRecognition() throws Exception {
        HanLP.Config.enableDebug();
        DijkstraSegment segment = new DijkstraSegment();
        System.out.println(segment.seg("\u7f16\u5267\u90b5\u94a7\u6797\u548c\u7a3d\u9053\u9752\u8bf4"));
    }
}

