/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.test.corpus;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.dictionary.SimpleDictionary;
import com.hankcs.hanlp.corpus.dictionary.StringDictionary;
import com.hankcs.hanlp.corpus.dictionary.StringDictionaryMaker;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.dictionary.py.Head;
import com.hankcs.hanlp.dictionary.py.Pinyin;
import com.hankcs.hanlp.dictionary.py.PinyinDictionary;
import com.hankcs.hanlp.dictionary.py.SYTDictionary;
import com.hankcs.hanlp.dictionary.py.Shengmu;
import com.hankcs.hanlp.dictionary.py.TonePinyinString2PinyinConverter;
import com.hankcs.hanlp.dictionary.py.Yunmu;
import com.hankcs.hanlp.utility.TextUtility;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class TestMakePinYinDictionary
extends TestCase {
    public void testCombine() throws Exception {
        HanLP.Config.enableDebug();
        StringDictionary dictionaryPY = new StringDictionary();
        dictionaryPY.load("D:\\JavaProjects\\jpinyin\\data\\pinyinTable.standard.txt");
        StringDictionary dictionaryPolyphone = new StringDictionary();
        dictionaryPolyphone.load("D:\\JavaProjects\\jpinyin\\data\\polyphone.txt");
        StringDictionary dictionarySingle = new StringDictionary();
        dictionarySingle.load("data/dictionary/pinyin/single.txt");
        StringDictionary main = StringDictionaryMaker.combine(dictionaryPY, dictionaryPolyphone, dictionarySingle);
        main.save("data/dictionary/pinyin/pinyin.txt");
    }

    public void testCombineSingle() throws Exception {
        HanLP.Config.enableDebug();
        StringDictionary main = StringDictionaryMaker.combine("data/dictionary/pinyin/pinyin.txt", "data/dictionary/pinyin/single.txt");
        main.save("data/dictionary/pinyin/pinyin.txt");
    }

    public void testSpeed() throws Exception {
    }

    public void testMakeSingle() throws Exception {
        LinkedList<String[]> csv = IOUtil.readCsv("D:\\JavaProjects\\jpinyin\\data\\words.csv");
        StringDictionary dictionarySingle = new StringDictionary();
        for (String[] args : csv) {
            String word = args[1];
            String py = args[2];
            String sm = args[3];
            String ym = args[4];
            String yd = args[5];
            String pyyd = String.valueOf(py) + yd;
            if (!TextUtility.isAllChinese(word)) continue;
            dictionarySingle.add(word, pyyd);
        }
        dictionarySingle.save("data/dictionary/pinyin/single.txt");
    }

    public void testMakeTable() throws Exception {
        LinkedList<String[]> csv = IOUtil.readCsv("D:\\JavaProjects\\jpinyin\\data\\words.csv");
        StringDictionary dictionarySingle = new StringDictionary();
        for (String[] args : csv) {
            String word = args[1];
            String py = args[2];
            String sm = args[3];
            String ym = args[4];
            String yd = args[5];
            String pyyd = String.valueOf(py) + yd;
            if (!TextUtility.isAllChinese(word)) continue;
            dictionarySingle.add(pyyd, String.valueOf(sm) + "," + ym + "," + yd);
        }
        dictionarySingle.save("data/dictionary/pinyin/sm-ym-table.txt");
    }

    public void testConvert() throws Exception {
        String text = "\u91cd\u8f7d\u4e0d\u662f\u91cd\u62c5\uff0c" + HanLP.convertToTraditionalChinese("\u4ee5\u540e\u7231\u7687\u540e");
        List<Pinyin> pinyinList = PinyinDictionary.convertToPinyin(text);
        System.out.print("\u539f\u6587,");
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            System.out.printf("%c,", Character.valueOf(c));
            ++n2;
        }
        System.out.println();
        System.out.print("\u62fc\u97f3\uff08\u6570\u5b57\u97f3\u8c03\uff09,");
        for (Pinyin pinyin : pinyinList) {
            System.out.printf("%s,", new Object[]{pinyin});
        }
        System.out.println();
        System.out.print("\u62fc\u97f3\uff08\u7b26\u53f7\u97f3\u8c03\uff09,");
        for (Pinyin pinyin : pinyinList) {
            System.out.printf("%s,", pinyin.getPinyinWithToneMark());
        }
        System.out.println();
        System.out.print("\u62fc\u97f3\uff08\u65e0\u97f3\u8c03\uff09,");
        for (Pinyin pinyin : pinyinList) {
            System.out.printf("%s,", pinyin.getPinyinWithoutTone());
        }
        System.out.println();
        System.out.print("\u58f0\u8c03,");
        for (Pinyin pinyin : pinyinList) {
            System.out.printf("%s,", pinyin.getTone());
        }
        System.out.println();
        System.out.print("\u58f0\u6bcd,");
        for (Pinyin pinyin : pinyinList) {
            System.out.printf("%s,", new Object[]{pinyin.getShengmu()});
        }
        System.out.println();
        System.out.print("\u97f5\u6bcd,");
        for (Pinyin pinyin : pinyinList) {
            System.out.printf("%s,", new Object[]{pinyin.getYunmu()});
        }
        System.out.println();
        System.out.print("\u8f93\u5165\u6cd5\u5934,");
        for (Pinyin pinyin : pinyinList) {
            System.out.printf("%s,", pinyin.getHeadString());
        }
        System.out.println();
    }

    public void testMakePinyinEnum() throws Exception {
        StringDictionary dictionary = new StringDictionary();
        dictionary.load("data/dictionary/pinyin/pinyin.txt");
        StringDictionary pyEnumDictionary = new StringDictionary();
        for (Map.Entry entry : dictionary.entrySet()) {
            String[] args;
            String[] stringArray = args = ((String)entry.getValue()).split(",");
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                pyEnumDictionary.add(arg, arg);
                ++n2;
            }
        }
        StringDictionary table = new StringDictionary();
        table.combine(pyEnumDictionary);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : table.entrySet()) {
            sb.append(entry.getKey());
            sb.append('\n');
        }
        IOUtil.saveTxt("data/dictionary/pinyin/py.enum.txt", sb.toString());
    }

    public void testExtendTable() throws Exception {
        StringDictionary dictionary = new StringDictionary();
        dictionary.load("data/dictionary/pinyin/pinyin.txt");
        StringDictionary pyEnumDictionary = new StringDictionary();
        for (Map.Entry entry : dictionary.entrySet()) {
            String[] args;
            String[] stringArray = args = ((String)entry.getValue()).split(",");
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                pyEnumDictionary.add(arg, arg);
                ++n2;
            }
        }
        StringDictionary table = new StringDictionary();
        table.load("data/dictionary/pinyin/sm-ym-table.txt");
        table.combine(pyEnumDictionary);
        Iterator iterator = table.entrySet().iterator();
        Map.Entry pre = iterator.next();
        String prePy = pre.getKey().substring(0, pre.getKey().length() - 1);
        String preYd = pre.getKey().substring(pre.getKey().length() - 1);
        while (iterator.hasNext()) {
            Map.Entry current = iterator.next();
            String currentPy = current.getKey().substring(0, current.getKey().length() - 1);
            String currentYd = current.getKey().substring(current.getKey().length() - 1);
            if (!((String)current.getValue()).contains(",")) {
                if (currentPy.equals(prePy)) {
                    table.add(current.getKey(), ((String)pre.getValue()).replace(preYd, currentYd));
                } else {
                    System.out.println(String.valueOf(currentPy) + currentYd);
                }
            }
            pre = current;
            prePy = currentPy;
            preYd = currentYd;
        }
        table.save("data/dictionary/pinyin/sm-ym-yd-table.txt");
    }

    public void testDumpSMT() throws Exception {
        HanLP.Config.enableDebug();
        SYTDictionary.dumpEnum("data/dictionary/pinyin/");
    }

    public void testPinyinDictionary() throws Exception {
        HanLP.Config.enableDebug();
        Pinyin[] pinyins = PinyinDictionary.get("\u4e2d");
        System.out.println(Arrays.toString((Object[])pinyins));
    }

    public void testCombineAnsjWithPinyinTxt() throws Exception {
        StringDictionary dictionaryAnsj = new StringDictionary();
        dictionaryAnsj.load("D:\\JavaProjects\\jpinyin\\data\\ansj.txt");
        System.out.println(dictionaryAnsj.remove(new SimpleDictionary.Filter<String>(){

            @Override
            public boolean remove(Map.Entry<String, String> entry) {
                String word = entry.getKey();
                String pinyin = entry.getValue();
                String[] pinyinStringArray = entry.getValue().split("[,\\s\u3000]");
                if (word.length() != pinyinStringArray.length || !TonePinyinString2PinyinConverter.valid(pinyinStringArray)) {
                    System.out.println(entry);
                    return false;
                }
                return true;
            }
        }));
    }

    public void testMakePinyinJavaCode() throws Exception {
        StringBuilder sb = new StringBuilder();
        Pinyin[] pinyinArray = PinyinDictionary.pinyins;
        int n = PinyinDictionary.pinyins.length;
        int n2 = 0;
        while (n2 < n) {
            Pinyin pinyin = pinyinArray[n2];
            sb.append((Object)((Object)pinyin) + "(" + Shengmu.class.getSimpleName() + "." + (Object)((Object)pinyin.getShengmu()) + ", " + Yunmu.class.getSimpleName() + "." + (Object)((Object)pinyin.getYunmu()) + ", " + pinyin.getTone() + ", \"" + pinyin.getPinyinWithToneMark() + "\", \"" + pinyin.getPinyinWithoutTone() + "\"" + ", " + Head.class.getSimpleName() + "." + pinyin.getHeadString() + ", '" + pinyin.getFirstChar() + "'" + "),\n");
            ++n2;
        }
        IOUtil.saveTxt("data/dictionary/pinyin/py.txt", sb.toString());
    }

    public void testConvertUnicodeTable() throws Exception {
        StringDictionary dictionary = new StringDictionary("=");
        for (String line : IOUtil.readLineList("D:\\Doc\\\u8bed\u6599\u5e93\\Uni2Pinyin.txt")) {
            String[] argArray;
            if (line.startsWith("#") || (argArray = line.split("\\s")).length == 1) continue;
            String py = argArray[1];
            int i = 2;
            while (i < argArray.length) {
                py = String.valueOf(py) + ',';
                py = String.valueOf(py) + argArray[i];
                ++i;
            }
            dictionary.add(String.valueOf((char)Integer.parseInt(argArray[0], 16)), py);
        }
        dictionary.save("D:\\Doc\\\u8bed\u6599\u5e93\\Hanzi2Pinyin.txt");
    }

    public void testCombineUnicodeTableWithMainDictionary() throws Exception {
        StringDictionary mainDictionary = new StringDictionary("=");
        mainDictionary.load("data/dictionary/pinyin/pinyin.txt");
        StringDictionary subDictionary = new StringDictionary("=");
        subDictionary.load("D:\\Doc\\\u8bed\u6599\u5e93\\Hanzi2Pinyin.txt");
        mainDictionary.combine(subDictionary);
        mainDictionary.save("data/dictionary/pinyin/pinyin.txt");
    }
}

