/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.test.corpus;

import com.hankcs.hanlp.corpus.dictionary.DictionaryMaker;
import com.hankcs.hanlp.corpus.dictionary.PlaceSuffixDictionary;
import com.hankcs.hanlp.corpus.dictionary.SuffixDictionary;
import com.hankcs.hanlp.corpus.tag.NS;
import com.hankcs.hanlp.utility.Predefine;
import java.util.Map;
import junit.framework.TestCase;

public class SuffixDictionaryTest
extends TestCase {
    SuffixDictionary dictionary = new SuffixDictionary();

    public void setUp() throws Exception {
        super.setUp();
        this.dictionary.addAll(Predefine.POSTFIX_SINGLE);
        this.dictionary.addAll(Predefine.POSTFIX_MUTIPLE);
    }

    public void testGet() throws Exception {
        String total = Predefine.POSTFIX_SINGLE;
        int i = 0;
        while (i < total.length()) {
            String single = String.valueOf(total.charAt(i));
            SuffixDictionaryTest.assertEquals((int)1, (int)this.dictionary.get(single));
            ++i;
        }
        String[] stringArray = Predefine.POSTFIX_MUTIPLE;
        int n = Predefine.POSTFIX_MUTIPLE.length;
        int n2 = 0;
        while (n2 < n) {
            String single = stringArray[n2];
            SuffixDictionaryTest.assertEquals((int)single.length(), (int)this.dictionary.get(single));
            ++n2;
        }
    }

    public void testEndsWith() throws Exception {
        SuffixDictionaryTest.assertEquals((boolean)true, (boolean)this.dictionary.endsWith("\u9ec4\u5188\u5e02"));
        SuffixDictionaryTest.assertEquals((boolean)false, (boolean)this.dictionary.endsWith("\u9ec4\u5188\u4e00\u4e8c\u4e09"));
    }

    public void testLongest() throws Exception {
        SuffixDictionaryTest.assertEquals((int)2, (int)this.dictionary.getLongestSuffixLength("\u5df4\u5c14\u5e72\u534a\u5c9b"));
    }

    public void testDump() throws Exception {
        DictionaryMaker dictionaryMaker = new DictionaryMaker();
        for (Map.Entry<String, Integer> entry : PlaceSuffixDictionary.dictionary.entrySet()) {
            dictionaryMaker.add(entry.getKey(), NS.H.toString());
        }
        dictionaryMaker.saveTxtTo("data/dictionary/place/suffix.txt");
    }
}

