/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.common;

import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.dictionary.BaseSearcher;
import com.hankcs.hanlp.utility.Predefine;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class CommonDictionary<V> {
    DoubleArrayTrie<V> trie;

    public boolean load(String path) {
        this.trie = new DoubleArrayTrie();
        long start = System.currentTimeMillis();
        V[] valueArray = this.onLoadValue(path);
        if (valueArray == null) {
            Predefine.logger.info("\u52a0\u8f7d\u503c" + path + ".value.dat\u5931\u8d25\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
            return false;
        }
        Predefine.logger.info("\u52a0\u8f7d\u503c" + path + ".value.dat\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
        start = System.currentTimeMillis();
        if (this.loadDat(String.valueOf(path) + ".trie.dat", valueArray)) {
            Predefine.logger.info("\u52a0\u8f7d\u952e" + path + ".trie.dat\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
            return true;
        }
        ArrayList<String> keyList = new ArrayList<String>(valueArray.length);
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            while ((line = br.readLine()) != null) {
                String[] paramArray = line.split("\\s");
                keyList.add(paramArray[0]);
            }
            br.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6" + path + "\u5931\u8d25" + e);
        }
        int resultCode = this.trie.build(keyList, valueArray);
        if (resultCode != 0) {
            Predefine.logger.warning("trie\u5efa\u7acb\u5931\u8d25" + resultCode + ",\u6b63\u5728\u5c1d\u8bd5\u6392\u5e8f\u540e\u91cd\u8f7d");
            TreeMap<String, V> map = new TreeMap<String, V>();
            int i = 0;
            while (i < valueArray.length) {
                map.put((String)keyList.get(i), valueArray[i]);
                ++i;
            }
            this.trie = new DoubleArrayTrie();
            this.trie.build(map);
            i = 0;
            for (Object v : map.values()) {
                valueArray[i++] = v;
            }
        }
        this.trie.save(String.valueOf(path) + ".trie.dat");
        this.onSaveValue(valueArray, path);
        Predefine.logger.info(String.valueOf(path) + "\u52a0\u8f7d\u6210\u529f");
        return true;
    }

    private boolean loadDat(String path, V[] valueArray) {
        return this.trie.load(path, valueArray);
    }

    public V get(String key) {
        return this.trie.get(key);
    }

    public boolean contains(String key) {
        return this.get(key) != null;
    }

    public int size() {
        return this.trie.size();
    }

    public static boolean sort(String path) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            while ((line = br.readLine()) != null) {
                String[] argArray = line.split("\\s");
                map.put(argArray[0], line);
            }
            br.close();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(path)));
            for (Map.Entry entry : map.entrySet()) {
                bw.write((String)entry.getValue());
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6" + path + "\u5931\u8d25" + e);
            return false;
        }
        return true;
    }

    protected abstract V[] onLoadValue(String var1);

    protected abstract boolean onSaveValue(V[] var1, String var2);

    public BaseSearcher getSearcher(String text) {
        return new Searcher(text);
    }

    public class Searcher
    extends BaseSearcher<V> {
        int begin;
        private List<Map.Entry<String, V>> entryList;

        protected Searcher(char[] c) {
            super(c);
        }

        protected Searcher(String text) {
            super(text);
            this.entryList = new LinkedList();
        }

        @Override
        public Map.Entry<String, V> next() {
            while (this.entryList.size() == 0 && this.begin < this.c.length) {
                this.entryList = CommonDictionary.this.trie.commonPrefixSearchWithValue(this.c, this.begin);
                ++this.begin;
            }
            if (this.entryList.size() == 0 && this.begin < this.c.length) {
                this.entryList = CommonDictionary.this.trie.commonPrefixSearchWithValue(this.c, this.begin);
                ++this.begin;
            }
            if (this.entryList.size() == 0) {
                return null;
            }
            Map.Entry result = this.entryList.get(0);
            this.entryList.remove(0);
            this.offset = this.begin - 1;
            return result;
        }
    }
}

