/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.bintrie.BinTrie;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class BiGramDictionary {
    static DoubleArrayTrie<Integer> trie;
    public static final String path;
    public static final int totalFrequency = 37545990;

    static {
        path = HanLP.Config.BiGramDictionaryPath;
        long start = System.currentTimeMillis();
        if (!BiGramDictionary.load(path)) {
            Predefine.logger.severe("\u4e8c\u5143\u8bcd\u5178\u52a0\u8f7d\u5931\u8d25");
            System.exit(-1);
        } else {
            Predefine.logger.info(String.valueOf(path) + "\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
        }
    }

    public static boolean load(String path) {
        int freq;
        boolean create;
        Predefine.logger.info("\u4e8c\u5143\u8bcd\u5178\u5f00\u59cb\u52a0\u8f7d:" + path);
        trie = new DoubleArrayTrie();
        boolean bl = create = !BiGramDictionary.loadDat(path);
        if (!create) {
            return true;
        }
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            while ((line = br.readLine()) != null) {
                String[] params = line.split("\\s");
                String twoWord = params[0];
                freq = Integer.parseInt(params[1]);
                map.put(twoWord, freq);
            }
            br.close();
            Predefine.logger.info("\u4e8c\u5143\u8bcd\u5178\u8bfb\u53d6\u5b8c\u6bd5:" + path + "\uff0c\u5f00\u59cb\u6784\u5efa\u53cc\u6570\u7ec4Trie\u6811(DoubleArrayTrie)\u2026\u2026");
        }
        catch (FileNotFoundException e) {
            Predefine.logger.severe("\u4e8c\u5143\u8bcd\u5178" + path + "\u4e0d\u5b58\u5728\uff01" + e);
            return false;
        }
        catch (IOException e) {
            Predefine.logger.severe("\u4e8c\u5143\u8bcd\u5178" + path + "\u8bfb\u53d6\u9519\u8bef\uff01" + e);
            return false;
        }
        int resultCode = trie.build(map);
        Predefine.logger.info("\u4e8c\u5143\u8bcd\u5178DAT\u6784\u5efa\u7ed3\u679c:{}" + resultCode);
        Predefine.logger.info("\u4e8c\u5143\u8bcd\u5178\u52a0\u8f7d\u6210\u529f:" + trie.size() + "\u4e2a\u8bcd\u6761");
        if (create) {
            try {
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(path) + ".bin")));
                Collection freqList = map.values();
                out.writeInt(freqList.size());
                Iterator iterator = freqList.iterator();
                while (iterator.hasNext()) {
                    freq = (Integer)iterator.next();
                    out.writeInt(freq);
                }
                trie.save(out);
                out.close();
            }
            catch (Exception e) {
                Predefine.logger.warning("\u5728\u7f13\u5b58" + path + ".bin" + "\u65f6\u53d1\u751f\u5f02\u5e38" + TextUtility.exceptionToString(e));
                return false;
            }
        }
        return true;
    }

    private static boolean loadDat(String path) {
        ByteArray byteArray;
        block4: {
            byteArray = ByteArray.createByteArray(String.valueOf(path) + ".bin");
            if (byteArray != null) break block4;
            return false;
        }
        try {
            int size = byteArray.nextInt();
            Integer[] value = new Integer[size];
            int i = 0;
            while (i < size) {
                value[i] = byteArray.nextInt();
                ++i;
            }
            return trie.load(byteArray, (Integer[])value);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Set<String> _findSpecialString() {
        HashSet<String> stringSet = new HashSet<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            while ((line = br.readLine()) != null) {
                String[] params = line.split("\t");
                String twoWord = params[0];
                String[] stringArray = params = twoWord.split("@");
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    String w = stringArray[n2];
                    if (w.contains("##")) {
                        stringSet.add(w);
                    }
                    ++n2;
                }
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringSet;
    }

    public static int getBiFrequency(String from, String to) {
        return BiGramDictionary.getBiFrequency(String.valueOf(from) + '@' + to);
    }

    public static int getBiFrequency(String twoWord) {
        Integer result = trie.get(twoWord);
        return result == null ? 0 : result;
    }

    private static boolean reSaveDictionary(TreeMap<String, Integer> map, String path) {
        StringBuilder sbOut = new StringBuilder();
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            sbOut.append(entry.getKey());
            sbOut.append(' ');
            sbOut.append(entry.getValue());
            sbOut.append('\n');
        }
        return IOUtil.saveTxt(path, sbOut.toString());
    }

    private static void sortListForBuildTrie(List<String> wordList, List<Integer> freqList, String path) {
        BinTrie<Integer> binTrie = new BinTrie<Integer>();
        int i = 0;
        while (i < wordList.size()) {
            binTrie.put(wordList.get(i), freqList.get(i));
            ++i;
        }
        Collections.sort(wordList);
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(path)));
            for (String w : wordList) {
                bw.write(String.valueOf(w) + '\t' + binTrie.get(w));
                bw.newLine();
            }
            bw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

