/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.collection.MDAG;

import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.ICacheAble;
import java.io.DataOutputStream;

public class SimpleMDAGNode
implements ICacheAble {
    private char letter;
    private boolean isAcceptNode;
    private int transitionSetSize;
    private int transitionSetBeginIndex;

    public SimpleMDAGNode(char letter, boolean isAcceptNode, int transitionSetSize) {
        this.letter = letter;
        this.isAcceptNode = isAcceptNode;
        this.transitionSetSize = transitionSetSize;
        this.transitionSetBeginIndex = 0;
    }

    public SimpleMDAGNode() {
    }

    public char getLetter() {
        return this.letter;
    }

    public boolean isAcceptNode() {
        return this.isAcceptNode;
    }

    public int getTransitionSetBeginIndex() {
        return this.transitionSetBeginIndex;
    }

    public int getOutgoingTransitionSetSize() {
        return this.transitionSetSize;
    }

    public void setTransitionSetBeginIndex(int transitionSetBeginIndex) {
        this.transitionSetBeginIndex = transitionSetBeginIndex;
    }

    public SimpleMDAGNode transition(SimpleMDAGNode[] mdagDataArray, char letter) {
        SimpleMDAGNode targetNode = null;
        int offset = this.binarySearch(mdagDataArray, letter);
        if (offset >= 0) {
            targetNode = mdagDataArray[offset];
        }
        return targetNode;
    }

    private SimpleMDAGNode transitionBruteForce(SimpleMDAGNode[] mdagDataArray, char letter) {
        int onePastTransitionSetEndIndex = this.transitionSetBeginIndex + this.transitionSetSize;
        SimpleMDAGNode targetNode = null;
        int i = this.transitionSetBeginIndex;
        while (i < onePastTransitionSetEndIndex) {
            if (mdagDataArray[i].getLetter() == letter) {
                targetNode = mdagDataArray[i];
                break;
            }
            ++i;
        }
        return targetNode;
    }

    private int binarySearch(SimpleMDAGNode[] mdagDataArray, char node) {
        if (this.transitionSetSize < 1) {
            return -1;
        }
        int high = this.transitionSetBeginIndex + this.transitionSetSize - 1;
        int low = this.transitionSetBeginIndex;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = mdagDataArray[mid].getLetter() - node;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public SimpleMDAGNode transition(SimpleMDAGNode[] mdagDataArray, String str) {
        SimpleMDAGNode currentNode = this;
        int numberOfChars = str.length();
        int i = 0;
        while (i < numberOfChars) {
            if ((currentNode = currentNode.transition(mdagDataArray, str.charAt(i))) == null) break;
            ++i;
        }
        return currentNode;
    }

    public SimpleMDAGNode transition(SimpleMDAGNode[] mdagDataArray, char[] str) {
        SimpleMDAGNode currentNode = this;
        int numberOfChars = str.length;
        int i = 0;
        while (i < numberOfChars) {
            if ((currentNode = currentNode.transition(mdagDataArray, str[i])) == null) break;
            ++i;
        }
        return currentNode;
    }

    public SimpleMDAGNode transition(SimpleMDAGNode[] mdagDataArray, char[] str, int offset) {
        SimpleMDAGNode currentNode = this;
        int numberOfChars = str.length - offset;
        int i = 0;
        while (i < numberOfChars) {
            if ((currentNode = currentNode.transition(mdagDataArray, str[offset + i])) == null) break;
            ++i;
        }
        return currentNode;
    }

    public static SimpleMDAGNode traverseMDAG(SimpleMDAGNode[] mdagDataArray, SimpleMDAGNode sourceNode, String str) {
        return sourceNode.transition(mdagDataArray, str.toCharArray());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SimpleMDAGNode{");
        sb.append("letter=").append(this.letter);
        sb.append(", isAcceptNode=").append(this.isAcceptNode);
        sb.append(", transitionSetSize=").append(this.transitionSetSize);
        sb.append(", transitionSetBeginIndex=").append(this.transitionSetBeginIndex);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void save(DataOutputStream out) throws Exception {
        out.writeChar(this.letter);
        out.writeByte(this.isAcceptNode ? 1 : 0);
        out.writeInt(this.transitionSetBeginIndex);
        out.writeInt(this.transitionSetSize);
    }

    @Override
    public boolean load(ByteArray byteArray) {
        this.letter = byteArray.nextChar();
        this.isAcceptNode = byteArray.nextByte() == 1;
        this.transitionSetBeginIndex = byteArray.nextInt();
        this.transitionSetSize = byteArray.nextInt();
        return true;
    }
}

