/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Generics;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String PROP = "prop";
    private static final String PROPS = "props";
    private static final String PROPERTIES = "properties";
    private static final String ARGS = "args";
    private static final String ARGUMENTS = "arguments";
    public static final Function<Object, String> DEFAULT_TOSTRING = new Function<Object, String>(){

        @Override
        public String apply(Object in) {
            return in.toString();
        }
    };
    private static Pattern diacriticalMarksPattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}");

    private StringUtils() {
    }

    public static boolean find(String str, String regex) {
        return Pattern.compile(regex).matcher(str).find();
    }

    public static boolean containsIgnoreCase(Collection<String> c, String s) {
        for (String squote : c) {
            if (!squote.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean lookingAt(String str, String regex) {
        return Pattern.compile(regex).matcher(str).lookingAt();
    }

    public static String[] mapStringToArray(String map) {
        String[] m = map.split("[,;]");
        int maxIndex = 0;
        String[] keys = new String[m.length];
        int[] indices = new int[m.length];
        for (int i = 0; i < m.length; ++i) {
            int index = m[i].lastIndexOf(61);
            keys[i] = m[i].substring(0, index);
            indices[i] = Integer.parseInt(m[i].substring(index + 1));
            if (indices[i] <= maxIndex) continue;
            maxIndex = indices[i];
        }
        Object[] mapArr = new String[maxIndex + 1];
        Arrays.fill(mapArr, null);
        for (int i = 0; i < m.length; ++i) {
            mapArr[indices[i]] = keys[i];
        }
        return mapArr;
    }

    public static Map<String, String> mapStringToMap(String map) {
        String[] m = map.split("[,;]");
        Map<String, String> res = Generics.newHashMap();
        for (String str : m) {
            int index = str.lastIndexOf(61);
            String key = str.substring(0, index);
            String val = str.substring(index + 1);
            res.put(key.trim(), val.trim());
        }
        return res;
    }

    public static List<Pattern> regexesToPatterns(Iterable<String> regexes) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String regex : regexes) {
            patterns.add(Pattern.compile(regex));
        }
        return patterns;
    }

    public static List<String> regexGroups(Pattern regex, String str) {
        if (str == null) {
            return null;
        }
        Matcher matcher = regex.matcher(str);
        if (!matcher.find()) {
            return null;
        }
        ArrayList<String> groups = new ArrayList<String>();
        for (int index = 1; index <= matcher.groupCount(); ++index) {
            groups.add(matcher.group(index));
        }
        return groups;
    }

    public static boolean matches(String str, String regex) {
        return Pattern.compile(regex).matcher(str).matches();
    }

    public static Set<String> stringToSet(String str, String delimiter) {
        Set<String> ret = null;
        if (str != null) {
            String[] fields = str.split(delimiter);
            ret = Generics.newHashSet(fields.length);
            for (String field : fields) {
                field = field.trim();
                ret.add(field);
            }
        }
        return ret;
    }

    public static String joinWords(Iterable<? extends HasWord> l, String glue) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (HasWord hasWord : l) {
            if (!first) {
                sb.append(glue);
            } else {
                first = false;
            }
            sb.append(hasWord.word());
        }
        return sb.toString();
    }

    public static <E> String join(List<? extends E> l, String glue, Function<E, String> toStringFunc, int start, int end) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        start = Math.max(start, 0);
        end = Math.min(end, l.size());
        for (int i = start; i < end; ++i) {
            if (!first) {
                sb.append(glue);
            } else {
                first = false;
            }
            sb.append(toStringFunc.apply(l.get(i)));
        }
        return sb.toString();
    }

    public static String joinWords(List<? extends HasWord> l, String glue, int start, int end) {
        return StringUtils.join(l, glue, new Function<HasWord, String>(){

            @Override
            public String apply(HasWord in) {
                return in.word();
            }
        }, start, end);
    }

    public static String joinFields(List<? extends CoreMap> l, final Class field, final String defaultFieldValue, String glue, int start, int end, final Function<Object, String> toStringFunc) {
        return StringUtils.join(l, glue, new Function<CoreMap, String>(){

            @Override
            public String apply(CoreMap in) {
                Object val = in.get(field);
                return val != null ? (String)toStringFunc.apply(val) : defaultFieldValue;
            }
        }, start, end);
    }

    public static String joinFields(List<? extends CoreMap> l, Class field, String defaultFieldValue, String glue, int start, int end) {
        return StringUtils.joinFields(l, field, defaultFieldValue, glue, start, end, DEFAULT_TOSTRING);
    }

    public static String joinFields(List<? extends CoreMap> l, Class field, Function<Object, String> toStringFunc) {
        return StringUtils.joinFields(l, field, "-", " ", 0, l.size(), toStringFunc);
    }

    public static String joinFields(List<? extends CoreMap> l, Class field) {
        return StringUtils.joinFields(l, field, "-", " ", 0, l.size());
    }

    public static String joinMultipleFields(List<? extends CoreMap> l, final Class[] fields, final String defaultFieldValue, final String fieldGlue, String glue, int start, int end, final Function<Object, String> toStringFunc) {
        return StringUtils.join(l, glue, new Function<CoreMap, String>(){

            @Override
            public String apply(CoreMap in) {
                StringBuilder sb = new StringBuilder();
                for (Class field : fields) {
                    Object val;
                    if (sb.length() > 0) {
                        sb.append(fieldGlue);
                    }
                    String str = (val = in.get(field)) != null ? (String)toStringFunc.apply(val) : defaultFieldValue;
                    sb.append(str);
                }
                return sb.toString();
            }
        }, start, end);
    }

    public static String joinMultipleFields(List<? extends CoreMap> l, Class[] fields, Function<Object, String> toStringFunc) {
        return StringUtils.joinMultipleFields(l, fields, "-", "/", " ", 0, l.size(), toStringFunc);
    }

    public static String joinMultipleFields(List<? extends CoreMap> l, Class[] fields, String defaultFieldValue, String fieldGlue, String glue, int start, int end) {
        return StringUtils.joinMultipleFields(l, fields, defaultFieldValue, fieldGlue, glue, start, end, DEFAULT_TOSTRING);
    }

    public static String joinMultipleFields(List<? extends CoreMap> l, Class[] fields) {
        return StringUtils.joinMultipleFields(l, fields, "-", "/", " ", 0, l.size());
    }

    public static String joinWithOriginalWhiteSpace(List<CoreLabel> tokens) {
        if (tokens.isEmpty()) {
            return "";
        }
        CoreLabel lastToken = tokens.get(0);
        StringBuilder buffer = new StringBuilder(lastToken.word());
        for (int i = 1; i < tokens.size(); ++i) {
            CoreLabel currentToken = tokens.get(i);
            int numSpaces = currentToken.beginPosition() - lastToken.endPosition();
            if (numSpaces < 0) {
                numSpaces = 0;
            }
            buffer.append(StringUtils.repeat(' ', numSpaces)).append(currentToken.word());
            lastToken = currentToken;
        }
        return buffer.toString();
    }

    public static <X> String join(Iterable<X> l, String glue) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (X o : l) {
            if (!first) {
                sb.append(glue);
            } else {
                first = false;
            }
            sb.append(o);
        }
        return sb.toString();
    }

    public static String join(Object[] elements, String glue) {
        return StringUtils.join(Arrays.asList(elements), glue);
    }

    public static String join(Iterable<?> l) {
        return StringUtils.join(l, " ");
    }

    public static String join(Object[] elements) {
        return StringUtils.join(elements, " ");
    }

    public static List<String> split(String s) {
        return StringUtils.split(s, "\\s+");
    }

    public static List<String> split(String str, String regex) {
        return Arrays.asList(str.split(regex));
    }

    public static String[] splitOnChar(String input, char delimiter) {
        String[] out2 = new String[input.length() + 1];
        int nextIndex = 0;
        int lastDelimiterIndex = -1;
        char[] chars = input.toCharArray();
        for (int i = 0; i <= chars.length; ++i) {
            if (i < chars.length && chars[i] != delimiter) continue;
            char[] tokenChars = new char[i - (lastDelimiterIndex + 1)];
            System.arraycopy(chars, lastDelimiterIndex + 1, tokenChars, 0, tokenChars.length);
            out2[nextIndex] = new String(tokenChars);
            ++nextIndex;
            lastDelimiterIndex = i;
        }
        String[] trimmedOut = new String[nextIndex];
        System.arraycopy(out2, 0, trimmedOut, 0, trimmedOut.length);
        return trimmedOut;
    }

    public static List<List<String>> splitFieldsFast(String str, String delimiter) {
        ArrayList<List<String>> fields = Generics.newArrayList();
        StringTokenizer tokenizer = new StringTokenizer(str.trim());
        ArrayList<String> currentField = Generics.newArrayList();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(delimiter)) {
                fields.add(currentField);
                currentField = Generics.newArrayList();
                continue;
            }
            currentField.add(token.trim());
        }
        if (currentField.size() > 0) {
            fields.add(currentField);
        }
        return fields;
    }

    public static List<String> valueSplit(String str, String valueRegex, String separatorRegex) {
        Pattern vPat = Pattern.compile(valueRegex);
        Pattern sPat = Pattern.compile(separatorRegex);
        ArrayList<String> ret = new ArrayList<String>();
        while (str.length() > 0) {
            Matcher vm = vPat.matcher(str);
            if (!vm.lookingAt()) {
                throw new IllegalArgumentException("valueSplit: " + valueRegex + " doesn't match " + str);
            }
            ret.add(vm.group());
            str = str.substring(vm.end());
            if (str.length() <= 0) continue;
            Matcher sm = sPat.matcher(str);
            if (sm.lookingAt()) {
                str = str.substring(sm.end());
                continue;
            }
            throw new IllegalArgumentException("valueSplit: " + separatorRegex + " doesn't match " + str);
        }
        return ret;
    }

    public static String pad(String str, int totalChars) {
        if (str == null) {
            str = "null";
        }
        int slen = str.length();
        StringBuilder sb = new StringBuilder(str);
        for (int i = 0; i < totalChars - slen; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String pad(Object obj, int totalChars) {
        return StringUtils.pad(obj.toString(), totalChars);
    }

    public static String padOrTrim(String str, int num) {
        int leng;
        if (str == null) {
            str = "null";
        }
        if ((leng = str.length()) < num) {
            StringBuilder sb = new StringBuilder(str);
            for (int i = 0; i < num - leng; ++i) {
                sb.append(' ');
            }
            return sb.toString();
        }
        if (leng > num) {
            return str.substring(0, num);
        }
        return str;
    }

    public static String padLeftOrTrim(String str, int num) {
        int leng;
        if (str == null) {
            str = "null";
        }
        if ((leng = str.length()) < num) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < num - leng; ++i) {
                sb.append(' ');
            }
            sb.append(str);
            return sb.toString();
        }
        if (leng > num) {
            return str.substring(str.length() - num);
        }
        return str;
    }

    public static String padOrTrim(Object obj, int totalChars) {
        return StringUtils.padOrTrim(obj.toString(), totalChars);
    }

    public static String padLeft(String str, int totalChars, char ch) {
        if (str == null) {
            str = "null";
        }
        StringBuilder sb = new StringBuilder();
        int num = totalChars - str.length();
        for (int i = 0; i < num; ++i) {
            sb.append(ch);
        }
        sb.append(str);
        return sb.toString();
    }

    public static String padLeft(String str, int totalChars) {
        return StringUtils.padLeft(str, totalChars, ' ');
    }

    public static String padLeft(Object obj, int totalChars) {
        return StringUtils.padLeft(obj.toString(), totalChars);
    }

    public static String padLeft(int i, int totalChars) {
        return StringUtils.padLeft((Object)i, totalChars);
    }

    public static String padLeft(double d, int totalChars) {
        return StringUtils.padLeft(new Double(d), totalChars);
    }

    public static String trim(String s, int maxWidth) {
        if (s.length() <= maxWidth) {
            return s;
        }
        return s.substring(0, maxWidth);
    }

    public static String trim(Object obj, int maxWidth) {
        return StringUtils.trim(obj.toString(), maxWidth);
    }

    public static String repeat(String s, int times) {
        if (times == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(times * s.length());
        for (int i = 0; i < times; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String repeat(char ch, int times) {
        if (times == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(times);
        for (int i = 0; i < times; ++i) {
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String fileNameClean(String s) {
        char[] chars = s.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char c : chars) {
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') {
                sb.append(c);
                continue;
            }
            if (c == ' ' || c == '-') {
                sb.append('_');
                continue;
            }
            sb.append('x').append((int)c).append('x');
        }
        return sb.toString();
    }

    public static int nthIndex(String s, char ch, int n) {
        int index = 0;
        for (int i = 0; i < n; ++i) {
            if (index == s.length() - 1) {
                return -1;
            }
            if ((index = s.indexOf(ch, index + 1)) != -1) continue;
            return -1;
        }
        return index;
    }

    public static String truncate(int n, int smallestDigit, int biggestDigit) {
        int j;
        int numDigits = biggestDigit - smallestDigit + 1;
        char[] result = new char[numDigits];
        for (j = 1; j < smallestDigit; ++j) {
            n /= 10;
        }
        for (j = numDigits - 1; j >= 0; --j) {
            result[j] = Character.forDigit(n % 10, 10);
            n /= 10;
        }
        return new String(result);
    }

    public static Map<String, String[]> argsToMap(String[] args) {
        return StringUtils.argsToMap(args, Collections.<String, Integer>emptyMap());
    }

    public static Map<String, String[]> argsToMap(String[] args, Map<String, Integer> flagsToNumArgs) {
        Map<String, String[]> result = Generics.newHashMap();
        ArrayList<String> remainingArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String key = args[i];
            if (key.charAt(0) == '-') {
                Integer numFlagArgs = flagsToNumArgs.get(key);
                int max = numFlagArgs == null ? 1 : numFlagArgs;
                int min = numFlagArgs == null ? 0 : numFlagArgs;
                ArrayList<String> flagArgs = new ArrayList<String>();
                for (int j = 0; j < max && i + 1 < args.length && (j < min || args[i + 1].length() == 0 || args[i + 1].charAt(0) != '-'); ++j) {
                    flagArgs.add(args[i + 1]);
                    ++i;
                }
                if (result.containsKey(key)) {
                    String[] newFlagArg = new String[result.get(key).length + flagsToNumArgs.get(key)];
                    int oldNumArgs = result.get(key).length;
                    System.arraycopy(result.get(key), 0, newFlagArg, 0, oldNumArgs);
                    for (int j = 0; j < flagArgs.size(); ++j) {
                        newFlagArg[j + oldNumArgs] = (String)flagArgs.get(j);
                    }
                    result.put(key, newFlagArg);
                    continue;
                }
                result.put(key, flagArgs.toArray(new String[flagArgs.size()]));
                continue;
            }
            remainingArgs.add(args[i]);
        }
        result.put(null, remainingArgs.toArray(new String[remainingArgs.size()]));
        return result;
    }

    public static Properties argsToProperties(String[] args) {
        return StringUtils.argsToProperties(args, Collections.<String, Integer>emptyMap());
    }

    public static Properties argsToProperties(String[] args, Map<String, Integer> flagsToNumArgs) {
        Properties result = new Properties();
        ArrayList<String> remainingArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String key = args[i];
            if (key.length() > 0 && key.charAt(0) == '-') {
                key = key.length() > 1 && key.charAt(1) == '-' ? key.substring(2) : key.substring(1);
                Integer maxFlagArgs = flagsToNumArgs.get(key);
                int max = maxFlagArgs == null ? 1 : maxFlagArgs;
                int min = maxFlagArgs == null ? 0 : maxFlagArgs;
                ArrayList<String> flagArgs = new ArrayList<String>();
                for (int j = 0; j < max && i + 1 < args.length && (j < min || args[i + 1].length() == 0 || args[i + 1].charAt(0) != '-'); ++j) {
                    flagArgs.add(args[i + 1]);
                    ++i;
                }
                if (flagArgs.isEmpty()) {
                    result.setProperty(key, "true");
                    continue;
                }
                result.setProperty(key, StringUtils.join(flagArgs, " "));
                if (!key.equalsIgnoreCase(PROP) && !key.equalsIgnoreCase(PROPS) && !key.equalsIgnoreCase(PROPERTIES) && !key.equalsIgnoreCase(ARGUMENTS) && !key.equalsIgnoreCase(ARGS)) continue;
                try {
                    InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(result.getProperty(key));
                    InputStreamReader reader = new InputStreamReader(is, "utf-8");
                    result.remove(key);
                    result.load(reader);
                    for (Object propKey : result.keySet()) {
                        String newVal = result.getProperty((String)propKey);
                        result.setProperty((String)propKey, newVal.trim());
                    }
                    is.close();
                    continue;
                }
                catch (IOException e) {
                    result.remove(key);
                    System.err.println("argsToProperties could not read properties file: " + result.getProperty(key));
                    throw new RuntimeIOException(e);
                }
            }
            remainingArgs.add(args[i]);
        }
        if (!remainingArgs.isEmpty()) {
            result.setProperty("", StringUtils.join(remainingArgs, " "));
        }
        if (result.containsKey(PROP)) {
            String file = result.getProperty(PROP);
            result.remove(PROP);
            Properties toAdd = StringUtils.argsToProperties(new String[]{"-prop", file});
            Enumeration<?> e = toAdd.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String val = toAdd.getProperty(key);
                if (result.containsKey(key)) continue;
                result.setProperty(key, val);
            }
        }
        return result;
    }

    public static Properties propFileToProperties(String filename) {
        Properties result = new Properties();
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(filename));
            result.load(is);
            for (Object propKey : result.keySet()) {
                String newVal = result.getProperty((String)propKey);
                result.setProperty((String)propKey, newVal.trim());
            }
            ((InputStream)is).close();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeIOException("propFileToProperties could not read properties file: " + filename, e);
        }
    }

    public static Properties stringToProperties(String str) {
        Properties result = new Properties();
        return StringUtils.stringToProperties(str, result);
    }

    public static Properties stringToProperties(String str, Properties props) {
        String[] propsStr;
        for (String term : propsStr = str.trim().split(",\\s*")) {
            String value;
            String key;
            int divLoc = term.indexOf(61);
            if (divLoc >= 0) {
                key = term.substring(0, divLoc).trim();
                value = term.substring(divLoc + 1).trim();
            } else {
                key = term.trim();
                value = "true";
            }
            props.setProperty(key, value);
        }
        return props;
    }

    public static String checkRequiredProperties(Properties props, String ... requiredProps) {
        for (String required : requiredProps) {
            if (props.getProperty(required) != null) continue;
            return required;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printToFile(File file, String message, boolean append, boolean printLn, String encoding) {
        PrintWriter pw = null;
        try {
            OutputStreamWriter fw = encoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), encoding) : new FileWriter(file, append);
            pw = new PrintWriter(fw);
            if (printLn) {
                pw.println(message);
            } else {
                pw.print(message);
            }
        }
        catch (Exception e) {
            System.err.println("Exception: in printToFile " + file.getAbsolutePath());
            e.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printToFileLn(File file, String message, boolean append) {
        PrintWriter pw = null;
        try {
            FileWriter fw = new FileWriter(file, append);
            pw = new PrintWriter(fw);
            pw.println(message);
        }
        catch (Exception e) {
            System.err.println("Exception: in printToFileLn " + file.getAbsolutePath() + ' ' + message);
            e.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printToFile(File file, String message, boolean append) {
        PrintWriter pw = null;
        try {
            FileWriter fw = new FileWriter(file, append);
            pw = new PrintWriter(fw);
            pw.print(message);
        }
        catch (Exception e) {
            System.err.println("Exception: in printToFile " + file.getAbsolutePath());
            e.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    public static void printToFile(File file, String message) {
        StringUtils.printToFile(file, message, false);
    }

    public static void printToFile(String filename, String message, boolean append) {
        StringUtils.printToFile(new File(filename), message, append);
    }

    public static void printToFileLn(String filename, String message, boolean append) {
        StringUtils.printToFileLn(new File(filename), message, append);
    }

    public static void printToFile(String filename, String message) {
        StringUtils.printToFile(new File(filename), message, false);
    }

    public static Map<String, String> parseCommandLineArguments(String[] args) {
        return StringUtils.parseCommandLineArguments(args, false);
    }

    public static Map<String, Object> parseCommandLineArguments(String[] args, boolean parseNumbers) {
        Map<String, Object> result = Generics.newHashMap();
        for (int i = 0; i < args.length; ++i) {
            String key = args[i];
            if (key.charAt(0) != '-') continue;
            if (i + 1 < args.length) {
                String value = args[i + 1];
                if (value.charAt(0) != '-') {
                    if (parseNumbers) {
                        Object numericValue = value;
                        try {
                            numericValue = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e2) {
                            // empty catch block
                        }
                        result.put(key, numericValue);
                    } else {
                        result.put(key, value);
                    }
                    ++i;
                    continue;
                }
                result.put(key, null);
                continue;
            }
            result.put(key, null);
        }
        return result;
    }

    public static String stripNonAlphaNumerics(String orig) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < orig.length(); ++i) {
            char c = orig.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (c < '0' || c > '9')) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String stripSGML(String orig) {
        Pattern sgmlPattern = Pattern.compile("<.*?>", 32);
        Matcher sgmlMatcher = sgmlPattern.matcher(orig);
        return sgmlMatcher.replaceAll("");
    }

    public static void printStringOneCharPerLine(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            System.out.println(c + " '" + (char)c + "' ");
        }
    }

    public static String escapeString(String s, char[] charsToEscape, char escapeChar) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == escapeChar) {
                result.append(escapeChar);
            } else {
                for (char charToEscape : charsToEscape) {
                    if (c != charToEscape) continue;
                    result.append(escapeChar);
                    break;
                }
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String[] splitOnCharWithQuoting(String s, char splitChar, char quoteChar, char escapeChar) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        int length = s.length();
        StringBuilder b = new StringBuilder();
        block0: while (i < length) {
            char curr = s.charAt(i);
            if (curr == splitChar) {
                if (b.length() > 0) {
                    result.add(b.toString());
                    b = new StringBuilder();
                }
                ++i;
                continue;
            }
            if (curr == quoteChar) {
                ++i;
                while (i < length) {
                    curr = s.charAt(i);
                    if (curr == escapeChar && i + 1 < length && s.charAt(i + 1) == quoteChar) {
                        b.append(s.charAt(i + 1));
                        i += 2;
                        continue;
                    }
                    if (curr == quoteChar) {
                        ++i;
                        continue block0;
                    }
                    b.append(s.charAt(i));
                    ++i;
                }
                continue;
            }
            b.append(curr);
            ++i;
        }
        if (b.length() > 0) {
            result.add(b.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    public static int longestCommonSubstring(String s, String t) {
        int j;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return 0;
        }
        if (m == 0) {
            return 0;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = 0;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = 0;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                d[i][j] = s_i == t_j ? SloppyMath.max(d[i - 1][j], d[i][j - 1], d[i - 1][j - 1] + 1) : Math.max(d[i - 1][j], d[i][j - 1]);
            }
        }
        return d[n][m];
    }

    public static int longestCommonContiguousSubstring(String s, String t) {
        if (s.isEmpty() || t.isEmpty()) {
            return 0;
        }
        int M = s.length();
        int N = t.length();
        int[][] d = new int[M + 1][N + 1];
        for (int j = 0; j <= N; ++j) {
            d[0][j] = 0;
        }
        for (int i = 0; i <= M; ++i) {
            d[i][0] = 0;
        }
        int max = 0;
        for (int i = 1; i <= M; ++i) {
            for (int j = 1; j <= N; ++j) {
                d[i][j] = s.charAt(i - 1) == t.charAt(j - 1) ? d[i - 1][j - 1] + 1 : 0;
                if (d[i][j] <= max) continue;
                max = d[i][j];
            }
        }
        return max;
    }

    public static int editDistance(String s, String t) {
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (int j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char s_i = s.charAt(i - 1);
            for (int j = 1; j <= m; ++j) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = SloppyMath.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    public static String pennPOSToWordnetPOS(String s) {
        if (s.matches("NN|NNP|NNS|NNPS")) {
            return "noun";
        }
        if (s.matches("VB|VBD|VBG|VBN|VBZ|VBP|MD")) {
            return "verb";
        }
        if (s.matches("JJ|JJR|JJS|CD")) {
            return "adjective";
        }
        if (s.matches("RB|RBR|RBS|RP|WRB")) {
            return "adverb";
        }
        return null;
    }

    public static String getShortClassName(Object o) {
        if (o == null) {
            return "null";
        }
        String name = o.getClass().getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public static <T> T columnStringToObject(Class objClass, String str, String delimiterRegex, String[] fieldNames) throws InstantiationException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, InvocationTargetException {
        Pattern delimiterPattern = Pattern.compile(delimiterRegex);
        return StringUtils.columnStringToObject(objClass, str, delimiterPattern, fieldNames);
    }

    public static <T> T columnStringToObject(Class<?> objClass, String str, Pattern delimiterPattern, String[] fieldNames) throws InstantiationException, IllegalAccessException, NoSuchMethodException, NoSuchFieldException, InvocationTargetException {
        String[] fields = delimiterPattern.split(str);
        Object item = ErasureUtils.uncheckedCast(objClass.newInstance());
        for (int i = 0; i < fields.length; ++i) {
            try {
                Field field = objClass.getDeclaredField(fieldNames[i]);
                field.set(item, fields[i]);
                continue;
            }
            catch (IllegalAccessException ex) {
                Method method = objClass.getDeclaredMethod("set" + StringUtils.capitalize(fieldNames[i]), String.class);
                method.invoke(item, fields[i]);
            }
        }
        return item;
    }

    public static String objectToColumnString(Object object, String delimiter, String[] fieldNames) throws IllegalAccessException, NoSuchFieldException, NoSuchMethodException, InvocationTargetException {
        StringBuilder sb = new StringBuilder();
        for (String fieldName : fieldNames) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            try {
                Field field = object.getClass().getDeclaredField(fieldName);
                sb.append(field.get(object));
            }
            catch (IllegalAccessException ex) {
                Method method = object.getClass().getDeclaredMethod("get" + StringUtils.capitalize(fieldName), new Class[0]);
                sb.append(method.invoke(object, new Object[0]));
            }
        }
        return sb.toString();
    }

    public static String capitalize(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
        return s;
    }

    public static boolean isCapitalized(String s) {
        return Character.isUpperCase(s.charAt(0));
    }

    public static String searchAndReplace(String text, String from, String to) {
        from = StringUtils.escapeString(from, new char[]{'.', '[', ']', '\\'}, '\\');
        Pattern p = Pattern.compile(from);
        Matcher m = p.matcher(text);
        return m.replaceAll(to);
    }

    public static String makeHTMLTable(String[][] table, String[] rowLabels, String[] colLabels) {
        StringBuilder buff = new StringBuilder();
        buff.append("<table class=\"auto\" border=\"1\" cellspacing=\"0\">\n");
        buff.append("<tr>\n");
        buff.append("<td></td>\n");
        for (int j = 0; j < table[0].length; ++j) {
            buff.append("<td class=\"label\">").append(colLabels[j]).append("</td>\n");
        }
        buff.append("</tr>\n");
        for (int i = 0; i < table.length; ++i) {
            buff.append("<tr>\n");
            buff.append("<td class=\"label\">").append(rowLabels[i]).append("</td>\n");
            for (int j = 0; j < table[i].length; ++j) {
                buff.append("<td class=\"data\">");
                buff.append(table[i][j] != null ? table[i][j] : "");
                buff.append("</td>\n");
            }
            buff.append("</tr>\n");
        }
        buff.append("</table>");
        return buff.toString();
    }

    public static String makeTextTable(Object[][] table, Object[] rowLabels, Object[] colLabels, int padLeft, int padRight, boolean tsv) {
        StringBuilder buff = new StringBuilder();
        buff.append(StringUtils.makeAsciiTableCell("", padLeft, padRight, tsv));
        for (int j = 0; j < table[0].length; ++j) {
            buff.append(StringUtils.makeAsciiTableCell(colLabels[j], padLeft, padRight, j != table[0].length - 1 && tsv));
        }
        buff.append('\n');
        for (int i = 0; i < table.length; ++i) {
            buff.append(StringUtils.makeAsciiTableCell(rowLabels[i], padLeft, padRight, tsv));
            for (int j = 0; j < table[i].length; ++j) {
                buff.append(StringUtils.makeAsciiTableCell(table[i][j], padLeft, padRight, j != table[0].length - 1 && tsv));
            }
            buff.append('\n');
        }
        return buff.toString();
    }

    private static String makeAsciiTableCell(Object obj, int padLeft, int padRight, boolean tsv) {
        String result = obj.toString();
        if (padLeft > 0) {
            result = StringUtils.padLeft(result, padLeft);
        }
        if (padRight > 0) {
            result = StringUtils.pad(result, padRight);
        }
        if (tsv) {
            result = result + '\t';
        }
        return result;
    }

    public static void main(String[] args) {
        String[] s = new String[]{"there once was a man", "this one is a manic", "hey there", "there once was a mane", "once in a manger.", "where is one match?", "Jo3seph Smarr!", "Joseph R Smarr"};
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                System.out.println("s1: " + s[i]);
                System.out.println("s2: " + s[j]);
                System.out.println("edit distance: " + StringUtils.editDistance(s[i], s[j]));
                System.out.println("LCS:           " + StringUtils.longestCommonSubstring(s[i], s[j]));
                System.out.println("LCCS:          " + StringUtils.longestCommonContiguousSubstring(s[i], s[j]));
                System.out.println();
            }
        }
    }

    public static String toAscii(String s) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                String result = "?";
                if (c >= '\u00c0' && c <= '\u00c5') {
                    result = "A";
                } else if (c == '\u00c6') {
                    result = "AE";
                } else if (c == '\u00c7') {
                    result = "C";
                } else if (c >= '\u00c8' && c <= '\u00cb') {
                    result = "E";
                } else if (c >= '\u00cc' && c <= '\u00cf') {
                    result = "F";
                } else if (c == '\u00d0') {
                    result = "D";
                } else if (c == '\u00d1') {
                    result = "N";
                } else if (c >= '\u00d2' && c <= '\u00d6') {
                    result = "O";
                } else if (c == '\u00d7') {
                    result = "x";
                } else if (c == '\u00d8') {
                    result = "O";
                } else if (c >= '\u00d9' && c <= '\u00dc') {
                    result = "U";
                } else if (c == '\u00dd') {
                    result = "Y";
                } else if (c >= '\u00e0' && c <= '\u00e5') {
                    result = "a";
                } else if (c == '\u00e6') {
                    result = "ae";
                } else if (c == '\u00e7') {
                    result = "c";
                } else if (c >= '\u00e8' && c <= '\u00eb') {
                    result = "e";
                } else if (c >= '\u00ec' && c <= '\u00ef') {
                    result = "i";
                } else if (c == '\u00f1') {
                    result = "n";
                } else if (c >= '\u00f2' && c <= '\u00f8') {
                    result = "o";
                } else if (c >= '\u00f9' && c <= '\u00fc') {
                    result = "u";
                } else if (c >= '\u00fd' && c <= '\u00ff') {
                    result = "y";
                } else if (c >= '\u2018' && c <= '\u2019') {
                    result = "'";
                } else if (c >= '\u201c' && c <= '\u201e') {
                    result = "\"";
                } else if (c >= '\u0213' && c <= '\u2014') {
                    result = "-";
                } else if (c >= '\u00a2' && c <= '\u00a5') {
                    result = "$";
                } else if (c == '\u2026') {
                    result = ".";
                }
                b.append(result);
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String toCSVString(String[] fields) {
        StringBuilder b = new StringBuilder();
        for (String fld : fields) {
            if (b.length() > 0) {
                b.append(',');
            }
            String field = StringUtils.escapeString(fld, new char[]{'\"'}, '\"');
            b.append('\"').append(field).append('\"');
        }
        return b.toString();
    }

    public static String tr(String input, String from, String to) {
        assert (from.length() == to.length());
        StringBuilder sb = null;
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            int ind = from.indexOf(input.charAt(i));
            if (ind < 0) continue;
            if (sb == null) {
                sb = new StringBuilder(input);
            }
            sb.setCharAt(i, to.charAt(ind));
        }
        if (sb == null) {
            return input;
        }
        return sb.toString();
    }

    public static String chomp(String s) {
        if (s.length() == 0) {
            return s;
        }
        int l_1 = s.length() - 1;
        if (s.charAt(l_1) == '\n') {
            return s.substring(0, l_1);
        }
        return s;
    }

    public static String chomp(Object o) {
        return StringUtils.chomp(o.toString());
    }

    public static void printErrInvocationString(String cls, String[] args) {
        System.err.println(StringUtils.toInvocationString(cls, args));
    }

    public static String toInvocationString(String cls, String[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append(cls).append(" invoked on ").append(new Date());
        sb.append(" with arguments:\n  ");
        for (String arg : args) {
            sb.append(' ').append(arg);
        }
        return sb.toString();
    }

    public static String getBaseName(String fileName) {
        return StringUtils.getBaseName(fileName, "");
    }

    public static String getBaseName(String fileName, String suffix) {
        String[] elts = fileName.split("/");
        String lastElt = elts[elts.length - 1];
        if (lastElt.endsWith(suffix)) {
            lastElt = lastElt.substring(0, lastElt.length() - suffix.length());
        }
        return lastElt;
    }

    public static boolean isAlpha(String s) {
        Pattern p = Pattern.compile("^[\\p{Alpha}\\s]+$");
        Matcher m = p.matcher(s);
        return m.matches();
    }

    public static boolean isNumeric(String s) {
        Pattern p = Pattern.compile("^[\\p{Digit}\\s\\.]+$");
        Matcher m = p.matcher(s);
        return m.matches();
    }

    public static boolean isAlphanumeric(String s) {
        Pattern p = Pattern.compile("^[\\p{Alnum}\\s\\.]+$");
        Matcher m = p.matcher(s);
        return m.matches();
    }

    public static boolean isPunct(String s) {
        Pattern p = Pattern.compile("^[\\p{Punct}]+$");
        Matcher m = p.matcher(s);
        return m.matches();
    }

    public static boolean isAcronym(String s) {
        Pattern p = Pattern.compile("^[\\p{Upper}]+$");
        Matcher m = p.matcher(s);
        return m.matches();
    }

    public static String getNotNullString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public static String resolveVars(String str, Map props) {
        if (str == null) {
            return null;
        }
        Pattern p = Pattern.compile("\\$\\{(\\w+)\\}|\\$(\\w+)");
        Matcher m = p.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String varName = null == m.group(1) ? m.group(2) : m.group(1);
            String vrValue = props.containsKey(varName) ? (String)props.get(varName) : System.getenv(varName);
            m.appendReplacement(sb, null == vrValue ? "" : vrValue);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static Properties argsToPropertiesWithResolve(String[] args) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        TreeMap<String, String> existingArgs = new TreeMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String key = args[i];
            if (key.length() <= 0 || key.charAt(0) != '-') continue;
            key = key.length() > 1 && key.charAt(1) == '-' ? key.substring(2) : key.substring(1);
            int max = 1;
            int min = 0;
            ArrayList<String> flagArgs = new ArrayList<String>();
            for (int j = 0; j < max && i + 1 < args.length && (j < min || args[i + 1].length() == 0 || args[i + 1].charAt(0) != '-'); ++j) {
                flagArgs.add(args[i + 1]);
                ++i;
            }
            if (flagArgs.isEmpty()) {
                existingArgs.put(key, "true");
                continue;
            }
            if (key.equalsIgnoreCase(PROP) || key.equalsIgnoreCase(PROPS) || key.equalsIgnoreCase(PROPERTIES) || key.equalsIgnoreCase(ARGUMENTS) || key.equalsIgnoreCase(ARGS)) {
                result.putAll(StringUtils.propFileToTreeMap(StringUtils.join(flagArgs, " "), existingArgs));
                ++i;
                existingArgs.clear();
                continue;
            }
            existingArgs.put(key, StringUtils.join(flagArgs, " "));
        }
        result.putAll(existingArgs);
        for (Map.Entry o : result.entrySet()) {
            String val = StringUtils.resolveVars((String)o.getValue(), result);
            result.put((String)o.getKey(), val);
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)result);
        return props;
    }

    public static TreeMap<String, String> propFileToTreeMap(String filename, Map<String, String> existingArgs) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.putAll(existingArgs);
        for (String l : IOUtils.readLines(filename)) {
            if ((l = l.trim()).isEmpty() || l.startsWith("#")) continue;
            int index = l.indexOf(61);
            if (index == -1) {
                result.put(l, "true");
                continue;
            }
            result.put(l.substring(0, index).trim(), l.substring(index + 1).trim());
        }
        return result;
    }

    public static Collection<String> getNgrams(List<String> words, int minSize, int maxSize) {
        List<List<String>> ng = CollectionUtils.getNGrams(words, minSize, maxSize);
        ArrayList<String> ngrams = new ArrayList<String>();
        for (List<String> n : ng) {
            ngrams.add(StringUtils.join(n, " "));
        }
        return ngrams;
    }

    public static Collection<String> getNgramsFromTokens(List<CoreLabel> words, int minSize, int maxSize) {
        ArrayList<String> wordsStr = new ArrayList<String>();
        for (CoreLabel l : words) {
            wordsStr.add(l.word());
        }
        List ng = CollectionUtils.getNGrams(wordsStr, minSize, maxSize);
        ArrayList<String> ngrams = new ArrayList<String>();
        for (List n : ng) {
            ngrams.add(StringUtils.join(n, " "));
        }
        return ngrams;
    }

    public static Collection<String> getNgramsString(String s, int minSize, int maxSize) {
        return StringUtils.getNgrams(Arrays.asList(s.split("\\s+")), minSize, maxSize);
    }

    public static String normalize(String s) {
        String d = Normalizer.normalize(s, Normalizer.Form.NFKD);
        d = diacriticalMarksPattern.matcher(d).replaceAll("");
        return Normalizer.normalize(d, Normalizer.Form.NFKC);
    }
}

