/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;

public class T4CTTIoclfeatures
extends T4CTTIfun {
    private static final int TOTAL_UB8_BITMAPS_COUNT = 4;
    private static final int UB8_SIZE = 64;
    private long[] ub8BitmapBuckets = new long[4];
    private int clientFeaturesCount = 0;

    T4CTTIoclfeatures(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)17);
    }

    void add(OracleConnection.ClientFeature clientFeature) {
        long l2;
        int n2 = clientFeature.getFeatureId() / 64;
        if ((this.ub8BitmapBuckets[n2] & (l2 = 1L << clientFeature.getFeatureId() % 64)) != 0L) {
            return;
        }
        int n3 = n2;
        this.ub8BitmapBuckets[n3] = this.ub8BitmapBuckets[n3] | l2;
        ++this.clientFeaturesCount;
    }

    void doOCLFEATURES() throws IOException {
        if (this.clientFeaturesCount > 0) {
            this.setFunCode((short)191);
            this.doPigRPC();
            this.ub8BitmapBuckets = new long[4];
            this.clientFeaturesCount = 0;
        }
    }

    @Override
    void marshal() throws IOException {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < this.ub8BitmapBuckets.length - 1; ++i2) {
                stringBuilder.append(this.ub8BitmapBuckets[i2] + ",");
            }
            stringBuilder.append(this.ub8BitmapBuckets[this.ub8BitmapBuckets.length - 1]);
            byte[] byArray = this.meg.conv.StringToCharBytes(stringBuilder.toString());
            this.meg.marshalPTR();
            this.meg.marshalSWORD(byArray.length);
            this.meg.marshalSB8(0L);
            this.meg.marshalCHR(byArray);
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException();
            iOException.initCause(sQLException.getCause());
            throw iOException;
        }
    }
}

