package com.zzsn.extrator;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
/**
 * 日期帮助类
 * 创建人：刘小鹏   
 * 创建时间：2015-5-8 下午1:29:48   
 * 公司 ：郑州数能软件科技有限公司
 * @version  1.0  
 *
 */
public class DateUtil
{
	private static String defDtPtn = "yyyy-MM-dd HH:mm:ss";// 缺省日期格式
	
	public static String getFirstDayOfMonth(Date date){
		String str = "";    
		SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");        
		Calendar lastDate = Calendar.getInstance();
		lastDate.setTime(date);
		lastDate.set(Calendar.DATE,1);//设为当前月的1号    
		str=sdf.format(lastDate.getTime());    
		return str;
	}
	
	public static String formatDateTime(Date date){
		return formatString(date, defDtPtn);
	}
	
    public static String formatString(Date value, String format)
    {
 	   SimpleDateFormat sdf = new SimpleDateFormat(format);//格式化时间 
 	  
	   String nowtime=sdf.format(value);//按以上格式 将当前时间转换成字符串 
	   return nowtime;
    }
    // 根据身份证号获取生日
    public static Date getBirthDay(String IDStr) {
    	String Ai = "";
    	Date date = null;
    	if (IDStr.length() == 18) {
            Ai = IDStr.substring(0, 17);
        } else if (IDStr.length() == 15) {
            Ai = IDStr.substring(0, 6) + "19" + IDStr.substring(6, 15);
        }
	    String strYear  = Ai.substring(6, 10);// 年份
        String strMonth = Ai.substring(10, 12);// 月份
        String strDay   = Ai.substring(12, 14);// 月份 
         try {
			SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd");
			date = s.parse(strYear+"-"+strMonth+"-"+strDay);
		} catch (Exception e) { 
			e.printStackTrace();
		}
    	return date;
    }
    
    public static String format(String value) throws Exception
    {
 	   SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");//格式化时间 
 	   Date date = sdf.parse(value);
	   String nowtime=sdf.format(date);//按以上格式 将当前时间转换成字符串 
	   return nowtime;
    }
    
    public static Date formatStr(String  value,String format){
       SimpleDateFormat sdf = new SimpleDateFormat(format);//格式化时间 
   	   Date date = null;;
	try {
		date = sdf.parse(value);
	} catch (ParseException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
  	   return date;
    	
    }
    
    public static int getGL(String strDate){ 
    	int gl = 0;
    	Date cjYear = null;
    	 try {
 			SimpleDateFormat s = new SimpleDateFormat("yyyy/MM/dd"); 
 			cjYear = s.parse(strDate);
 			Calendar cal = Calendar.getInstance();
 	        cal.setTime(cjYear); 
 			gl = Calendar.getInstance().get(Calendar.YEAR)-cal.get(Calendar.YEAR)+1;
 		} catch (Exception e) { 
 			e.printStackTrace();
 		} 
    	return gl;
    }
	public static String getNextMonthFirst(Date date){
	      String str = "";    
	      SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");        
	      Calendar lastDate = Calendar.getInstance();
	      lastDate.setTime(date);
	      lastDate.add(Calendar.MONTH,1);//减一个月    
	      lastDate.set(Calendar.DATE, 1);//把日期设置为当月第一天     
	      str=sdf.format(lastDate.getTime());    
	      return str;      
	}
	public static int compareTime(String time1, String time2)
	{
		int result = 0;
		try
		{
			DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
			Date date1 = df.parse(time1);
			Date date2 = df.parse(time2);
			result = date1.compareTo(date2);
		} catch (Exception e)
		{
			e.printStackTrace();
		}
		return result;
	}

	public static String format(String time, String from_format, String to_format)
	{
		SimpleDateFormat sdf = null;
		Date date = null;
		if (time != null && !"".equals(time))
		{
			sdf = new SimpleDateFormat(from_format);
			try
			{
				date = sdf.parse(time);
			} catch (ParseException e)
			{
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			if (date != null)
			{
				sdf = new SimpleDateFormat(to_format);
			}
		}
		return sdf.format(date);
	}

	 /**
	  * 获取当前年
	  * 创建人:  刘小鹏  
	  * 创建时间:  2015-5-8 下午1:34:15 
	  * @version 1.0
	  * @return
	  */
	public static String getCurrentYear(){
         String format = "yyyy";
		return DateUtil.format(new Date(), format);
	}
	
	 /**
	  * 获取当前月份
	  * 创建人:  刘小鹏  
	  * 创建时间:  2015-5-8 下午1:34:10 
	  * @version 1.0
	  * @return
	  */
	public static String getCurrentMonth(){
		Calendar cal = Calendar.getInstance();
		int month = cal.get(Calendar.MONTH) + 1;
		return String.valueOf(month);
	}
	
	 /**
	  * 获取当前年月份
	  * 创建人:  刘小鹏  
	  * 创建时间:  2015-5-8 下午1:33:49 
	  * @version 1.0
	  * @return
	  */
	public static String getCurrentYearMonth(){
		String format = "yyyy";
		String year = DateUtil.format(new Date(), format);
		
		Calendar cal = Calendar.getInstance();
		int month = cal.get(Calendar.MONTH) + 1;
		return year + "-" + month;
	}
	
	/**
	 * 获取当前日期
	 * 创建人:  刘小鹏  
	 * 创建时间:  2015-5-8 下午1:33:44 
	 * @version 1.0
	 * @return
	 */
	public static String getCreateDate(){
		
		String format = "yyyy-MM-dd HH:mm:ss";
		
		return DateUtil.format(new Date(), format);
	}
	public static String format(Date d )
	{
		String format = "yyyy-MM-dd HH:mm:ss";
	
		return DateUtil.format(d, format);
	}
	public static String format(Date d, String format)
	{
		if (d == null)
			return "";
		SimpleDateFormat myFormatter = new SimpleDateFormat(format);
		return myFormatter.format(d);
	}
    public static String formatString(Date value)
    {
 	   SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");//格式化时间 
 	  
	   String nowtime=sdf.format(value);//按以上格式 将当前时间转换成字符串 
	   return nowtime;
    }
	/**
	 * 格式化给定时间
	 * 创建人:  刘小鹏  
	 * 创建时间:  2015-5-8 下午1:33:08 
	 * @version 1.0
	 * @param date 需要格式化的时间
	 * @return 给定时间的格式化字符串(如：2008-11-22)
	 */
	public static String formatDate(Date date)
	{
		return new Date(date.getTime()).toString();
	}
	public final static String getDayOfWeekCn1(String dateStr) {
		Calendar cal = Calendar.getInstance();
		String weekCn = null;
		Timestamp time = getTimeOfDateStr(dateStr);
		if (time != null) {
			cal.setTime(time);
			int day = cal.get(Calendar.DAY_OF_WEEK);
			switch (day) {
			case 1:
				weekCn = "日";
				break;
			case 2:
				weekCn = "一";
				break;
			case 3:
				weekCn = "二";
				break;
			case 4:
				weekCn = "三";
				break;
			case 5:
				weekCn = "四";
				break;
			case 6:
				weekCn = "五";
				break;
			case 7:
				weekCn = "六";
				break;
			default:
				weekCn = "";
			}
		}
		return weekCn;
	}
	public final static Timestamp getTimeOfDateStr(String dateStr) {
		DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
		Timestamp time = null;
		try {
			Date da = df.parse(dateStr);
			time = new Timestamp(da.getTime());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return time;
	}
	public final static int getDayOfWeek(Date dateStr)
	{
		Calendar cal = Calendar.getInstance();
		@SuppressWarnings("unused")
		String weekCn = null;
		int day = 0;
		cal.setTime(dateStr);
		day = cal.get(Calendar.DAY_OF_WEEK);
		return day;
	}
    /**
     * 将字符串按指定格式解析成日期对象
     * 创建人:  刘小鹏  
     * 创建时间:  2015-5-8 下午1:31:59 
     * @version 1.0
     * @param dateStr 需要进行转换的日期字符串
     * @param pattern 日期字符串的格式
     * @return "yyyy-MM-dd HH:mm:ss"形式的日期对象
     */
    public static Date parseDate(String dateStr, String pattern) {
        SimpleDateFormat DATEFORMAT = new SimpleDateFormat(defDtPtn);
        DATEFORMAT.applyPattern(pattern);
        Date ret = null;
        try {
            ret = DATEFORMAT.parse(dateStr);
        } catch (Exception e) {
            e.printStackTrace();
        }
        DATEFORMAT.applyPattern(defDtPtn);
        return ret;
    }
	public static String formatDate(Date d, int format, Locale locale, TimeZone timeZone)
	{
		if (d == null)
			return "";
		DateFormat df = DateFormat.getDateInstance(format, locale);
		df.setTimeZone(timeZone);
		return df.format(d);
	}

	public static String formatDateTime(Date d, int format1, int format2, Locale locale, TimeZone timeZone)
	{
		if (d == null)
			return "";
		DateFormat df = DateFormat.getDateTimeInstance(format1, format2, locale);
		df.setTimeZone(timeZone);
		return df.format(d);
	}

	/**
	 * 根据字符串返回指定格式的日期
	 * 创建人:  刘小鹏  
	 * 创建时间:  2015-5-8 下午1:31:16 
	 * @version 1.0
	 * @param dateStr
	 * @param format
	 * @return
	 * @throws ParseException
	 */
	public static Date convertDate(String dateStr, String format) throws ParseException
	{
		Date date = null;
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
		date = simpleDateFormat.parse(dateStr);
		return date;
	}

	public static long toLong(Date d)
	{
		if (d == null)
			return 5338979352082120704L;
		return d.getTime();
	}

	public static String toLongString(Date d)
	{
		return "" + toLong(d);
	}

	public static int getYear(Date date)
	{
		if (date == null)
			return 0;
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		return cal.get(1);
	}

	public static Date parse(String timeMillis)
	{
		Date d = null;
		try
		{
			d = new Date(Long.parseLong(timeMillis.trim()));
		} catch (Exception e)
		{
		}
		return d;
	}

	public static Date parse(String time, String format)
	{
		Date d = null;
		try
		{
			d = parse(time, format, Locale.CHINA);
		} catch (Exception e)
		{
		}
		return d;
	}

	public static Date parse(String time, String format, Locale locale) throws Exception
	{
		if (time == null)
			return null;
		SimpleDateFormat sdf = new SimpleDateFormat(format, locale);
		Date d = null;
		d = sdf.parse(time);
		return d;
	}

	public static String format(Calendar cal, String format)
	{
		if (cal == null)
			return "";
		SimpleDateFormat myFormatter = new SimpleDateFormat(format);
		return myFormatter.format(cal.getTime());
	}

	public static Calendar add(Date d, int day)
	{
		if (d == null)
			return null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		cal.add(5, day);
		return cal;
	}

	public static Date addDate(Date d, int day)
	{
		if (d == null)
			return null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		cal.add(5, day);
		return cal.getTime();
	}
	public static Date addMonth(Date d, int m)
	{
		if (d == null)
			return null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		cal.add(2, m);
		return cal.getTime();
	}
	public static Date addHourDate(Date d, int h)
	{
		if (d == null)
			return null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		cal.add(10, h);
		return cal.getTime();
	}

	public static Calendar addHour(Date d, int h)
	{
		if (d == null)
			return null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		cal.add(10, h);
		return cal;
	}

	public static Date addMinuteDate(Date d, int m)
	{
		if (d == null)
			return null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		cal.add(12, m);
		return cal.getTime();
	}

	public static Calendar addMinute(Date d, int m)
	{
		if (d == null)
			return null;
		Calendar cal = Calendar.getInstance();
		cal.setTime(d);
		cal.add(12, m);
		return cal;
	}

	public static int compare(Calendar c1, Calendar c2)
	{
		if ((c1 == null) || (c2 == null))
			return -1;
		long r = c1.getTimeInMillis() - c2.getTimeInMillis();
		if (r > 5338979730039242752L)
			return 1;
		if (r == 5338979730039242752L)
			return 0;
		return 2;
	}

	public static boolean compare(Date c1, Date c2)
	{
		if ((c1 == null) || (c2 == null))
			return false;
		long r = c1.getTime() - c2.getTime();
	   if(r>0){
		   return true;
	   }
	   return false;
	}

	public static boolean isSameDay(Calendar c1, Calendar c2)
	{
		if ((c1 == null) || (c2 == null))
			return false;
		return ((c1.get(1) == c2.get(1)) && (c1.get(2) == c2.get(2)) && (c1.get(5) == c2.get(5)));
	}

	public static boolean isSameDay(Date d1, Date d2)
	{
		if ((d1 == null) || (d2 == null))
			return false;
		Calendar c1 = Calendar.getInstance();
		c1.setTime(d1);
		Calendar c2 = Calendar.getInstance();
		c2.setTime(d2);
		return ((c1.get(1) == c2.get(1)) && (c1.get(2) == c2.get(2)) && (c1.get(5) == c2.get(5)));
	}

	public static int datediff(Calendar c1, Calendar c2)
	{
		if ((c1 == null) || (c2 == null))
			return -1;
		long r = c1.getTimeInMillis() - c2.getTimeInMillis();
		r /= 86400000L;
		return (int) r;
	}

	public static int datediff(Date c1, Date c2)
	{
		if ((c1 == null) || (c2 == null))
			return -1;
		long r = c1.getTime() - c2.getTime();
		r /= 86400000L;
		return (int) r;
	}

	public static int datediffMinute(Date c1, Date c2)
	{
		if ((c1 == null) || (c2 == null))
			return 0;
		double r = c1.getTime() - c2.getTime();
		r /= 60000.0D;
		return (int) r;
	}

	public static int datediffMinute(Calendar c1, Calendar c2)
	{
		if ((c1 == null) || (c2 == null))
			return 0;
		double r = c1.getTimeInMillis() - c2.getTimeInMillis();
		r /= 60000.0D;
		return (int) r;
	}

	public static int datediffHour(Date c1, Date c2)
	{
		if ((c1 == null) || (c2 == null))
			return 0;
		double r = c1.getTime() - c2.getTime();
		r /= 3600000.0D;
		return (int) r;
	}

	public static int datediffHour(Calendar c1, Calendar c2)
	{
		if ((c1 == null) || (c2 == null))
			return 0;
		double r = c1.getTimeInMillis() - c2.getTimeInMillis();
		r /= 3600000.0D;
		return (int) r;
	}

	@SuppressWarnings("deprecation")
	public static int[] dateDiffDHMS(Date d1, Date d2)
	{
		int diffDay = datediff(d1, d2);
		int h1 = d1.getHours();
		int h2 = d2.getHours();
		int m1 = d1.getMinutes();
		int m2 = d2.getMinutes();
		int s1 = d1.getSeconds();
		int s2 = d2.getSeconds();
		int s = s1 - s2;
		int m = m1 - m2;
		if (s < 0)
		{
			s += 60;
			--m;
		}
		int h = h1 - h2;
		if (m < 0)
		{
			m += 60;
			--h;
		}
		if (h < 0)
		{
			h += 24;
		}
		int[] r =
		{ diffDay, h, m, s };
		return r;
	}

	public static int getDayCount(int year, int month)
	{
		int[] daysInMonth =
		{ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
		if (1 == month)
		{
			return ((((0 == year % 4) && (0 != year % 100)) || (0 == year % 400)) ? 29 : 28);
		}
		return daysInMonth[month];
	}

	public static int getDaysOfYear(int year)
	{
		GregorianCalendar now = new GregorianCalendar();
		return ((now.isLeapYear(year)) ? 366 : 365);
	}

	/**
	 * 转换时间类型时间变字符
	 * 创建人:  刘小鹏  
	 * 创建时间:  2015-5-8 下午1:31:01 
	 * @version 1.0
	 * @param ts
	 * @param withtime
	 * @return
	 */
	public static String Timestamp2String(Timestamp ts, boolean withtime) //
	{
		if (ts == null)
			return "";
		if (withtime)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			return sdf.format(ts);
		} else
		{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			return sdf.format(ts);
		}
	}

	/**
	 * 转换时间类型字符变时间
	 * 创建人:  刘小鹏  
	 * 创建时间:  2015-5-8 下午1:30:54 
	 * @version 1.0
	 * @param string
	 * @param withtime
	 * @return
	 */
	public static Timestamp String2Timestamp(String string, boolean withtime)
	{
		Timestamp ts = null;
		if (string == null || string.equals(""))
			return ts;
		if (withtime)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			try
			{
				ts = new Timestamp(sdf.parse(string).getTime());
			} catch (Exception e)
			{
			}
			return ts;
		} else
		{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			try
			{
				ts = new Timestamp(sdf.parse(string).getTime());
			} catch (Exception e)
			{
			}
			return ts;
		}
	}
	public static String tiemString2String(String string, boolean withtime)
	{
		if (string == null || string.equals(""))
			return null;
		try {
			Long timeL=Long.parseLong(string);
		} catch (NumberFormatException e1) {
			return null;
		}
		Date d=new Date(Long.parseLong(string));
		String ts = null;
		if (withtime)
		{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			try
			{
			return 	sdf.format(d);
			} catch (Exception e)
			{
				
			}
			return null;
		} else
		{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			try
			{
			return 	sdf.format(d);
			} catch (Exception e)
			{
				
			}
			return null;
		}
	}

	/**
	 * 把Long型字符转换成字符串时间
	 * 创建人:  刘小鹏  
	 * 创建时间:  2015-5-8 下午1:30:48 
	 * @version 1.0
	 * @param format
	 * @param l_time
	 * @return
	 */
	public static String longToString(String format, long l_time)
	{
		SimpleDateFormat sdf = new SimpleDateFormat(format);
		Date dt = new Date(l_time * 1000);
		String time = sdf.format(dt);
		return time;
	}

	/**
	 * 在YM的基础上增加count个月
	 * 创建人:  刘小鹏  
	 * 创建时间:  2015-5-8 下午1:30:42 
	 * @version 1.0
	 * @param ym
	 * @param count
	 * @return
	 */
	public static String addMonth(String ym, int count)
	{
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
		try
		{
			Date date = sdf.parse(ym);
			Calendar c = Calendar.getInstance();
			c.setTime(date);
			c.add(2, count);
			return sdf.format(c.getTime());
		} catch (ParseException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 格式化EXCEL导入时获取的日期
	 * 创建人:  刘小鹏  
	 * 创建时间:  2015-5-8 下午1:30:36 
	 * @version 1.0
	 * @param date
	 * @return
	 */
	public static Date formatExcelDate(String date)
	{
		Calendar cld = Calendar.getInstance();
		cld.set(1899, 11, 30);
		cld.add(Calendar.DAY_OF_YEAR, Float.valueOf(date).intValue());
		return cld.getTime();
	}

	/**
	 * 获取当前月第一天
	 * 创建人:  刘小鹏  
	 * 创建时间:  2015-5-8 下午1:30:29 
	 * @version 1.0
	 * @return
	 */
	public static String firstDay()
	{
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		Calendar c = Calendar.getInstance();
		c.add(Calendar.MONTH, 0);
		c.set(Calendar.DAY_OF_MONTH, 1);// 设置为1号,当前日期既为本月第一天
		String first = format.format(c.getTime());
		return first;
	}

	/**
	 * 获取当前月最后天
	 * 创建人:  刘小鹏  
	 * 创建时间:  2015-5-8 下午1:30:22 
	 * @version 1.0
	 * @return
	 */
	public static String lastDay()
	{
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		Calendar ca = Calendar.getInstance();
		ca.set(Calendar.DAY_OF_MONTH, ca.getActualMaximum(Calendar.DAY_OF_MONTH));
		String last = format.format(ca.getTime());
		return last;
	}

	public static String getWeekDayString(Date date)
	{
		String weekString = "";
		final String dayNames[] =
		{ "星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六" };
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		int dayOfWeek = calendar.get(Calendar.DAY_OF_WEEK);
		weekString = dayNames[dayOfWeek - 1];
		return weekString;
	}

	/**
	 * 转换日期格式
	 * 创建人:  刘小鹏  
	 * 创建时间:  2015-5-8 下午1:30:06 
	 * @version 1.0
	 * @param source
	 * @param sourceFormat
	 * @param targetFormat
	 * @return
	 * @throws ParseException
	 */
	public static String convertDate(String source,String sourceFormat,String targetFormat) throws ParseException{
		SimpleDateFormat sdf = new SimpleDateFormat(sourceFormat);
		Date date = sdf.parse(source);
		sdf.applyPattern(targetFormat);
		return sdf.format(date);
	}
	
	/**
	 * 获取当前日期前一天
	 * 创建人:  刘小鹏  
	 * 创建时间:  2015-7-5 下午1:54:01 
	 * @version 1.0
	 * @param source
	 * @param sourceFormat
	 * @param targetFormat
	 * @return
	 * @throws ParseException
	 */
	public static String yestoday(String day) throws ParseException{
		Date date = null;
		DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		date = format.parse(day);
		String dateCreated = DateUtil.format(date, "yyyy-MM-dd");
		
		Date date1 = format.parse(dateCreated);
		Date yesday = new Date (date1.getTime()-24*3600*1000);
		String yestoday = DateUtil.format(yesday, "yyyy-MM-dd");

		return yestoday;
	}
	/**
	 * 获取之前包括今天在内的七天yyyy-MM-dd格式日期
	 * 创建人:  杨海龙  
	 * 创建时间:  2015年7月8日 下午2:35:05 
	 * @version 1.0
	 * @param day
	 * @return
	 */
	public static String[] getLatestSevenDays(String curday){
		String[] days = new String[7];
		DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		Date day = null;
		try {
			day = convertDate(curday, "yyyy-MM-dd");
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		for (int i = 0; i < 7; i++) {
			Date date = new Date(day.getTime()-(6-i)*24*60*60*1000);
			String dateStr = format.format(date);
			days[i] = dateStr;
		}
		return days;
	}
	
	/**
	 * 计算两个日期之间相差的天数（字符串的日期格式的计算）
	 * 创建人:  刘小鹏  
	 * 创建时间:  2015-8-6 下午6:11:55 
	 * @version 1.0
	 * @param smdate（较小的时间）
	 * @param bdate（较大的时间）
	 * @return
	 * @throws ParseException
	 */
    public static int daysBetween(String smdate,String bdate) throws ParseException{  
        SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");  
        Calendar cal = Calendar.getInstance();    
        cal.setTime(sdf.parse(smdate));    
        long time1 = cal.getTimeInMillis();                 
        cal.setTime(sdf.parse(bdate));    
        long time2 = cal.getTimeInMillis();         
        long between_days=(time2-time1)/(1000*3600*24);  
            
       return Integer.parseInt(String.valueOf(between_days));     
    } 
	/**
	 * 获取当前日期后一天
	 * 创建人:  刘小鹏  
	 * 创建时间:  2015-7-5 下午1:54:01 
	 * @version 1.0
	 * @param source
	 * @param sourceFormat
	 * @param targetFormat
	 * @return
	 * @throws ParseException
	 */
	public static String tomorrow(String day) throws ParseException{
		Date date = null;
		DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		date = format.parse(day);
		String dateCreated = DateUtil.format(date, "yyyy-MM-dd");
		
		Date date1 = format.parse(dateCreated);
		Date tomorr = new Date (date1.getTime()+24*3600*1000);
		String tomorrow = DateUtil.format(tomorr, "yyyy-MM-dd");

		return tomorrow;
	}
	
	/**
	 * 获取当前日期
	 * 创建人:  宁永利  
	 * 创建时间:  2015-7-2 下午6:23:57 
	 * @version 1.0
	 * @return
	 */
	public  static String  getCurrentDate(String format){
		
   		Date  now = new  Date();   		
		SimpleDateFormat sf = new SimpleDateFormat(format);		
		String date = sf.format(now);		
		return date;
	}
	
	/**
	 * 获取该日期的前7天的日期
	 * 假如返回dateStr, 则 dateStr 与 day 组成一周
	 */
	public static String getDateBeforeWeek(String day) {
		Date date = formatStr(day, "yyyy-MM-dd");
		Calendar now = Calendar.getInstance();  
		now.setTime(date);  
		now.set(Calendar.DATE,now.get(Calendar.DATE) - 7);  
		return format(now.getTime(), "yyyy-MM-dd");  
	}
	
	/**
	 * 获取该日期的前7天的日期
	 * 假如返回dateStr, 则 dateStr 与 day 组成一周
	 */
	public static String getTommowDay(String day) {
		Date date = formatStr(day, "yyyy-MM-dd");
		Calendar now = Calendar.getInstance();  
		now.setTime(date);  
		now.set(Calendar.DATE,now.get(Calendar.DATE) + 1);  
		return format(now.getTime(), "yyyy-MM-dd");  
	}
	/**
	 * 前台仪表盘组件获取日期选择条件
	 * 创建人:  李东亮  
	 * 创建时间:  2015-12-1 上午10:35:35 
	 * @version 1.0
	 * @param dateType “today”
	 * @param publishStartTime
	 * @param publishEndTime
	 * @return
	 */
	public static Map<String,String> configPublishDateCondition(String dateType,String publishStartTime,String publishEndTime){
		Map<String,String> map = new HashMap<String,String>();
		//发布时间
		String day = DateUtil.format(new Date(), "yyyy-MM-dd");
		String nextday = null;
		try {
			nextday = DateUtil.tomorrow(day);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if ("today".equals(dateType)) {
			publishStartTime = day;
			publishEndTime = nextday;
		} else if ("week".equals(dateType)) {
			//最近一周
			Date date = new Date();
			Date week = new Date (date.getTime()-7*24*3600*1000);
			String weeked = DateUtil.format(week, "yyyy-MM-dd");
			publishStartTime = weeked;
			publishEndTime = nextday;
		} else if ("month".equals(dateType)) {
			//最近一月
			Date date = new Date();
			Date month = new Date (date.getTime()-30*24*3600*1000L);
			String monthed = DateUtil.format(month, "yyyy-MM-dd");
			publishStartTime = monthed;
			publishEndTime = nextday;
		}else if("setdate".equals(dateType)){
			
		}
		map.put("publishStartTime", publishStartTime);
		map.put("publishEndTime", publishEndTime);
		return map;
	}
	public static void main(String[] args) throws ParseException
	{
//		Date da = convertDate("2015-08-31", "yyyy-MM-dd");
////		String yestoday = yestoday("2015-07-05");
//		System.out.println(da);
		String daybefore = getDateBeforeWeek("2015-10-01");
		System.out.println(daybefore);
		String[] dayWeek = getLatestSevenDays("2015-10-01");
		for (int i = 0; i < 7; i++) {
			System.out.println(dayWeek[i]);
		}
	}
	
}