package com.zzsn.extractor.web;


import com.zzsn.util.Constants;
import com.zzsn.util.FileUtil;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;


/**
 * xml操作工具类
 * 创建人：李东亮   
 * 创建时间：2015-5-27 下午2:08:13   
 * 公司 ：郑州数能软件科技有限公司
 * @version  1.0  
 *
 */
public class ProcessorReader {
	

	private static final Logger Log = LoggerFactory.getLogger(ProcessorReader.class);
	private String path=this.getClass().getResource("/").getPath()+"conf/wechat-processor.templete";
	/**
     * 设置范围processor
     * 创建人:  李东亮  
     * 创建时间:  2016-8-16 上午11:45:56 
     * @version 1.0
     * @param scopeTags
     * @return
     */
    public static Processor getScopeProcessor(String scopeTags){
        if(scopeTags==null||scopeTags.length()==0){
            return null;
        }
        ExtType  extType = new ExtType();
        extType.setEname("SCOPE");
        extType.setExp(scopeTags);
        Processor processor = new JsoupTagProcessor(extType);
        processor.init();
        return processor;
    }
    /**
     * 从模板中读取抽取类型和抽取公式
     * 创建人:  李东亮  
     * 创建时间:  2015-5-27 下午3:14:08 
     * @version 1.0
     * @param templete
     * @return
     */
    public static  List<Processor> readProcessors(String templete){
        Log.debug("===读取配置文件开始============");
        List<Processor> processors = new ArrayList<Processor>();
         SAXBuilder builder = new SAXBuilder();
         org.jdom.Document doc = null;
        try {
            doc = builder.build( new StringReader(templete));
        } catch (JDOMException | IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        Element root = doc.getRootElement();
        
        Processor processor;
        ExtType extType;
        Element extTypeEle;
        Element subtractionEle;
        Element attrEle;
        String attr;
        String ename;
        for(WebExtractorImpl.EXT_TYPE extTypeStr : WebExtractorImpl.EXT_TYPE.values()){
            ename = extTypeStr.toString().toLowerCase();
            extTypeEle = root.getChild(ename);
            if(extTypeEle==null){
                continue;
            }
            extType = new ExtType();
            extType.setEname(ename);
            extType.setExp(extTypeEle.getChild("exp").getText().trim());
            subtractionEle = extTypeEle.getChild("subtraction");
            if(subtractionEle!=null){
                extType.setSubtraction(subtractionEle.getText().trim());
            }
            attrEle = extTypeEle.getChild("attr");
            if(attrEle!=null){
                attr = attrEle.getText();
                if(attr!=null){
                    attr = attr.trim();
                    if(attr.length()>0){
                        extType.setAttr(attr);
                    }
                }
            }
            processor = new JsoupTagProcessor(extType);
            processor.init();
            Log.debug("=======");
            Log.debug(extType.getEname()+":");
            Log.debug("exp["+extType.getExp()+"]");
            Log.debug("subtraction["+extType.getSubtraction()+"]");
            Log.debug("attr["+extType.getAttr()+"]");
            Log.debug("=======");
            processors.add(processor);
        }
        Log.debug("===读取配置文件结束,共有"+processors.size()+"项需要爬取============");
        return processors;
    }

    /**
     * 
     * 创建人:  李东亮  
     * 创建时间:  2016-5-23 下午3:24:32 
     * @version 1.0
     * @return
     */
    public static  List<Processor> readWeChatProcessors(){
       // String path = ProcessorReader.class.getClass().getResource("/").getPath()+"conf/wechat-processor.templete";
       // String path=System.getProperty("user.dir")+"/conf/wechat-processor.templete";
       //  String templete =  FileUtil.readFile(new File(path),"UTF-8");
         String templete =  FileUtil.readFile(new File(Constants.path),"UTF-8");
        return readProcessors(templete);
    }
  
	
	public static void main(String[] args) {
	}
}
