package com.zzsn.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 把url转换为保存路径的工具类
 * 创建人：李东亮   
 * 创建时间：2016-8-22 上午10:00:33   
 * 公司 ：郑州数能软件科技有限公司
 * @version  1.0  
 *
 */
public class URLConvertUtil {

    /**
     * 对参数中的中文进行编码
     * 创建人:  李东亮  
     * 创建时间:  2016-4-14 下午2:46:50 
     * @version 1.0
     * @param uri
     * @return
     */
    public static String encodURI(String uri) {
        if (uri == null) {
            return null;
        }
        //只对中文参数进行转码
        if (uri.contains("?")&&!uri.endsWith("?")) {
                StringBuffer sb = new StringBuffer();
                sb.append("?");
                String[] array = uri.split("\\?");
                String uriPart = array[0];
                String paramStr = array[1];
                String[] params = paramStr.split("\\&");
                for (int i = 0 ;i <params.length;i++) {
                    if(i>0){
                        sb.append("&");
                    }
                    String param = params[i];
                    Integer indexFlag = param.indexOf("=");
                    if(indexFlag!=-1){
                        String name =  param.substring(0,indexFlag);
                        String value = param.substring(indexFlag+1);
                        value = encodeParamValue(value);
                        name= encodeParamValue(name);
                        sb.append(name+ "=" +value);
                    }else{
                        param= encodeParamValue(param);
                        sb.append(param);
                    }
                   
                }
                uri = uriPart+sb.toString();
               /* Matcher matcher = Pattern.compile("[\\u4e00-\\u9fa5]").matcher(uri);
                while (matcher.find()) {
                    String tmp = matcher.group();
                    uri = uri.replaceAll(tmp, java.net.URLEncoder.encode(tmp, "UTF-8"));
                }*/
           
        }
        
        //对路径中的中文也进行转码
        String regex="([\u4e00-\u9fa5]+)"; 
        Matcher matcher = Pattern.compile(regex).matcher(uri);
        String find;
        String replace = null;
        while(matcher.find()){
            find  = matcher.group();
            try {
                replace = URLEncoder.encode(find, "UTF-8");
            } catch (UnsupportedEncodingException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }
            while(uri.contains(find)&&!find.equals(replace)){
                    uri = uri.replace(find, replace);
            }
        }
        
        
        
        uri = uri.replaceAll("/+$", "/");
        uri = uri.replaceAll(" ", "%20");
        uri = uri.replaceAll("’", "%E2%80%99");
        return uri;
    }
    
    
    /**
     * 对参数中的中文进行转码
     * 创建人:  李东亮  
     * 创建时间:  2016-8-4 下午3:48:47 
     * @version 1.0
     * @param uri
     * @return
     */
    public static String encodeParamValue(String uri){
        Pattern p = Pattern.compile("([\u4e00-\u9fa5－]+)"); 
        Matcher matcher =  p.matcher(uri);
        String find ;
        String encode = null;
        while(matcher.find()){
            find =  matcher.group();
            try {
                encode = URLEncoder.encode(find, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            while(uri.contains(find)&&!find.equals(encode)){
                uri = uri.replace(find,encode);
            }
        }
        return uri;
    }
    
    
    /**
     * 去除路径中的特殊字符
     * 创建人:  李东亮  
     * 创建时间:  2016-8-19 下午1:29:24 
     * @version 1.0
     * @param path
     * @return
     */
    public static  String convertToSavePath(String desTemp){
        desTemp = desTemp.replaceAll(":", "_");
        desTemp = desTemp.replaceAll("\\?", "_");
        desTemp = desTemp.replaceAll("<", "_");
        desTemp = desTemp.replaceAll(">", "_");
        desTemp = desTemp.replaceAll("\\|", "_");
        desTemp = desTemp.replaceAll("\\*", "_");
        desTemp = desTemp.replaceAll("%", "_");
        desTemp = desTemp.replaceAll("/+$", "");
        desTemp = desTemp.replaceAll("\\s|　", "_");
        return desTemp;
    }
}
