/**
 * 
 */
package com.zzsn.utility.util;


/**
 * 语言类型判断器：判断文件或文本是否是中文 (cn)还是英文文本
 * 
 * @author ear
 * 
 */
public class LangTypeDetector {

	/**
	 * 
	 */
	public LangTypeDetector() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * 判断指定文本内容的语言类型
	 * 
	 * @param content
	 * @return
	 */
	public static String DetectLang(String content) {
		try {
			if (content == null) {
				return null;
			}

			int len = content.length();
			// 获得文本中包含的中文字数
			// 将语言类型由原来的两种（中；英）改为三种（中文；英文；其他）  刘丽芳 20140923
			content = content.replaceAll("[\\u4e00-\\u9fa5]", "");// 去掉中文之后的字符串
			content = content.replaceAll("[0-9]", "");// 去掉数字之后的非中文字符串
			String contentOther = content.replaceAll("[a-zA-Z]", "");// 去掉中英文之后的字符串
			int charOtherLen = contentOther.length();// 获得文本中包含的非中英文字数
			int charLen = content.length();// 获得文本中包含的非中文字数
			double ratioOther = (double) charOtherLen / (double) len;//非中英文字数的占有率
			double ratio = (double) (len-charLen) / (double) len;//中文字数的占有率
			if (ratioOther >= 0.50) {
				return "error";
			}
			if (ratio >= 0.50) {
				return "cn";
			}else{
				return "en";
			}
		} catch (Exception e) {
			return null;
		}

	}

	/**
	 * 判断指定文件的语言类型
	 * 
	 * @param file
	 * @return
	 */
	public static String DetectFileLang(String file) {
		String content = PreProcessor.readFile(file);
		return DetectLang(content);
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		LangTypeDetector l = new LangTypeDetector();
		//???????????????????
		//String s = l.DetectLang("es322??????????语是");
		String s = l.DetectLang("111111111111是");
		System.out.println("结果:"+s);
	}

}
