package com.zzsn.utility.util;

import com.zzsn.utility.model.ImgData;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class ImgDataUtil {
    /**
     * 获取父路径
     * 创建人:  李东亮  
     * 创建时间:  2015-7-6 下午3:17:44 
     * @version 1.0
     * @param path
     * @return
     * @throws IOException 
     */
    public static String getDirPath(String path) {
        path = path.substring(0, path.lastIndexOf("/")) ;
        return path;
    }
    
    /**
     * 去除路径中的./
     * 创建人:  李东亮  
     * 创建时间:  2015-7-6 下午3:43:00 
     * @version 1.0
     * @param path
     * @return
     * @throws IOException 
     */
    public static String formatPath(String currentPageURL,String imgPath) {
        String start="";
        if(currentPageURL.indexOf("http://")!=-1){
            start = "http://";
        }else if(currentPageURL.indexOf("https://")!=-1){
            start = "https://";
        }
        
        //绝对路径
        if(imgPath.startsWith("/")){
            currentPageURL = currentPageURL.replace(start, "");
            int subIndex = currentPageURL.indexOf("/");
            if(subIndex==-1){
                subIndex = currentPageURL.length();
            }
            String domain = currentPageURL.substring(0, subIndex);
            return start+domain+imgPath;
        }
        
        //相对路径
        String path = currentPageURL+"/"+imgPath;
    
        path = path.replaceAll(start, "D:/");
        File f = new File(path);
        String filePath="";
        try {
            filePath = f.getCanonicalPath();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        String result = filePath.replaceAll("D:\\\\", start);
        result = result.replaceAll("\\\\", "/");
        return result;
    }
    
    
    /**
     * 生成图片文件保存路径
     * 创建人:  李东亮  
     * 创建时间:  2016-3-23 下午2:50:33 
     * @version 1.0
     * @return
     */
   private static String genImgFileName(){
       String dir = DateUtil.format(new Date(), "yyyy-MM-dd");
       String uuid = UUID.randomUUID().toString();
       return dir+"/"+uuid;
   }
   
    /**
     * 获取图片链接
     * 创建人:  李东亮  
     * 创建时间:  2015-6-3 下午1:36:19 
     * @version 1.0
     * @param contentStr
     * @return
     */
    public static Map<String,ImgData> getContentImg(String contentStr,String uri){
        Map<String,ImgData> imgMap = new HashMap<String,ImgData>();
        if(contentStr==null||contentStr.length()==0){
            return imgMap;
        }
        Pattern p = Pattern.compile( "(<img.+?src=)(\"|')(.+?)(\"|')(.*?/?>)",Pattern.CASE_INSENSITIVE);
        Matcher m = p.matcher(contentStr);
        String imgPath;
        ImgData imgData;
        StringBuffer replacePath;
        while(m.find()){
            imgData = new ImgData();
            imgPath = m.group(3);
            if(!imgPath.startsWith("http://")&&!imgPath.startsWith("https://")&&uri!=null){
                String puriDir = getDirPath(uri.toString());
                imgPath = formatPath(puriDir,imgPath);
            }
            //图片完整路径
            imgData.setFormatTag(imgPath);
            //图片保存路径
            imgData.setLocalImgPath(genImgFileName());
            replacePath = new StringBuffer("");
            replacePath.append(m.group(1)).append(m.group(2)).append("IMG_SERVER/").append(imgData.getLocalImgPath()).append(m.group(4)).append(m.group(5));
            imgData.setReplaceTag(replacePath.toString());
            imgMap.put(m.group(), imgData);
        }
        return imgMap;
    }
    
}
