package com.zzsn.search.extractor;

import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import java.io.UnsupportedEncodingException;
import java.util.concurrent.TimeoutException;


public class MemcachedFactory {

	private static final Logger Log = LoggerFactory.getLogger(MemcachedFactory.class);
	private static ApplicationContext factory;  
	protected static MemcachedClient client;

	/**
	 * 加载spring容器
	 * 创建人:  李东亮  MemcachedFactory
	 * 创建时间:  2015-5-30 上午11:39:31 
	 * @version 1.0
	 */
	public static void  init(){
		factory = new ClassPathXmlApplicationContext("conf/spring-memcached.xml");  
		client = (MemcachedClient )factory.getBean("memcachedClient");
	}
	
    /**
     * 获取Key值
     * @param key
     * @return
     */
    public  static Object getKey(String key) {
    	try {
			Object obj = client.get(key);
			if("null".equals(obj)){
			    return null;
			}
			return obj;
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
		/*	if (!client.isShutdown()) {
				try {
					client.shutdown();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}*/
		}
    	return null;
    }
    
    
    /**
     * 设置缓存 10天
     * @param key
     * @return
     */
    public static boolean setExpireskey(String key, Object value) {
    	boolean result = false;
    	try {
    		if(value==null){
    			value="null";
    		}
    		if (client.get(key) != null ) {
    			result = client.replace(key, 3600*24*10, value);
    		} else {
    			result = client.set(key, 3600*24*10, value);
    		}
		} catch (TimeoutException | InterruptedException | MemcachedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
		/*	if (!client.isShutdown()) {
				try {
					client.shutdown();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}*/
		}
    	return result;
    }
    /**
     * 设置缓存  永不过期，（一个月后会自动过期）
     * @param key
     * @return
     */
    public static boolean setKey(String key, Object value) {
    	boolean result = false;
    	try {
    		if(value==null){
    			value="null";
    		}
    		if (client.get(key) != null ) {
    			result = client.replace(key, 0, value);
    		} else {
    			result = client.set(key, 0, value);
    		}
    	} catch (TimeoutException | InterruptedException | MemcachedException e) {
    		// TODO Auto-generated catch block
    		e.printStackTrace();
    	} finally {
    		/*	if (!client.isShutdown()) {
				try {
					client.shutdown();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}*/
    	}
    	return result;
    }
    public static void setLset(String key,String value){
//		client
	}
  
    
    public static void main(String[] args) throws UnsupportedEncodingException {
    	MemcachedFactory.init();
//    	DBServiceFactory.init();
    	Object object=MemcachedFactory.getKey("domainUri_www.ceconline.com");
    	System.out.println(object);
    //	List<Site> sites = DBServiceFactory.getCrawlerService().getSnSites();

/*    	//memcached清空缓存
    	Map<String,String> map = new HashMap<String,String>();
    	for(int i=0;i<1000000;i++){
    	    map.put(i+"","adadadadadadadadadadadadadadader");
    	}
    	
    	MemcachedFactory.setKey("aa", map);
    	
    	Map<String,String> m = (Map<String, String>) MemcachedFactory.getKey("aa");
    	System.out.println(m.size());*/
    	//MemcachedFactory.flushAll();
    }
}
