/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.demo;

import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import java.io.IOException;
import java.util.List;

public class NERDemo {
    public static void main(String[] args) throws IOException {
        String serializedClassifier = "classifiers/english.all.3class.distsim.crf.ser.gz";
        if (args.length > 0) {
            serializedClassifier = args[0];
        }
        CRFClassifier<CoreLabel> classifier = CRFClassifier.getClassifierNoExceptions(serializedClassifier);
        if (args.length > 1) {
            String fileContents = IOUtils.slurpFile(args[1]);
            List out2 = classifier.classify(fileContents);
            for (List sentence : out2) {
                for (CoreLabel word : sentence) {
                    System.out.print(word.word() + '/' + (String)word.get(CoreAnnotations.AnswerAnnotation.class) + ' ');
                }
                System.out.println();
            }
            out2 = classifier.classifyFile(args[1]);
            for (List sentence : out2) {
                for (CoreLabel word : sentence) {
                    System.out.print(word.word() + '/' + (String)word.get(CoreAnnotations.AnswerAnnotation.class) + ' ');
                }
                System.out.println();
            }
        } else {
            String s1 = "Good afternoon Rajat Raina, how are you today?";
            String s2 = "I go to school at Stanford University, which is located in California.";
            System.out.println(classifier.classifyToString(s1));
            System.out.println(classifier.classifyWithInlineXML(s2));
            System.out.println(classifier.classifyToString(s2, "xml", true));
            int i = 0;
            for (List lcl : classifier.classify(s2)) {
                for (CoreLabel cl : lcl) {
                    System.out.println(i++ + ":");
                    System.out.println(cl);
                }
            }
        }
    }
}

