/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ie.crf.CRFLabel;
import edu.stanford.nlp.ie.crf.CRFLogConditionalObjectiveFunction;
import edu.stanford.nlp.ie.crf.CRFLogConditionalObjectiveFunctionNoisyLabel;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Index;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.List;

public class CRFClassifierNoisyLabel<IN extends CoreMap>
extends CRFClassifier<IN> {
    protected double[][] errorMatrix;

    public CRFClassifierNoisyLabel(SeqClassifierFlags flags) {
        super(flags);
    }

    static double[][] readErrorMatrix(String fileName, Index<String> tagIndex) {
        int numTags;
        int matrixSize = numTags = tagIndex.size();
        String[] matrixLines = new String[matrixSize];
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(new File(fileName))));
            String line = null;
            int lineCount = 0;
            while ((line = br.readLine()) != null) {
                matrixLines[lineCount] = line = line.trim();
                ++lineCount;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        double[][] matrix = CRFClassifierNoisyLabel.parseMatrix(matrixLines, tagIndex, matrixSize, false);
        System.err.println("Error Matrix: ");
        System.err.println(ArrayUtils.toString(matrix));
        return matrix;
    }

    @Override
    protected CRFLogConditionalObjectiveFunction getObjectiveFunction(int[][][][] data, int[][] labels) {
        if (this.errorMatrix == null && this.flags.errorMatrix != null) {
            if (this.tagIndex == null) {
                this.loadTagIndex();
            }
            this.errorMatrix = CRFClassifierNoisyLabel.readErrorMatrix(this.flags.errorMatrix, this.tagIndex);
        }
        return new CRFLogConditionalObjectiveFunctionNoisyLabel(data, labels, this.windowSize, (Index<String>)this.classIndex, (List<Index<CRFLabel>>)this.labelIndices, this.map, this.flags.priorType, this.flags.backgroundSymbol, this.flags.sigma, (double[][][][])null, this.flags.multiThreadGrad, this.errorMatrix);
    }
}

