/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.archive.format.gzip.GZIPDecoder;
import org.archive.format.gzip.GZIPFormatException;

public class ArchiveUtils {
    private static final Logger LOGGER = Logger.getLogger(ArchiveUtils.class.getName());
    public static final String VERSION = ArchiveUtils.loadVersion();
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP12 = ArchiveUtils.threadLocalDateFormat("yyyyMMddHHmm");
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP14 = ArchiveUtils.threadLocalDateFormat("yyyyMMddHHmmss");
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP17 = ArchiveUtils.threadLocalDateFormat("yyyyMMddHHmmssSSS");
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP17ISO8601Z = ArchiveUtils.threadLocalDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP14ISO8601Z = ArchiveUtils.threadLocalDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final char DEFAULT_PAD_CHAR = ' ';
    private static final int HOUR_IN_MS = 3600000;
    private static final int DAY_IN_MS = 86400000;
    public static int MAX_INT_CHAR_WIDTH = Integer.toString(Integer.MAX_VALUE).length();
    protected static long LAST_UNIQUE_NOW17 = 0L;
    protected static String LAST_TIMESTAMP17 = "";
    protected static long LAST_UNIQUE_NOW14 = 0L;
    protected static String LAST_TIMESTAMP14 = "";
    static final SimpleDateFormat[] dateToTimestampFormats = new SimpleDateFormat[]{new SimpleDateFormat("MM/dd/yyyy"), new SimpleDateFormat("MM/yyyy"), new SimpleDateFormat("yyyy")};
    public static Set<String> TLDS = new HashSet<String>();
    public static final String GZIP_SUFFIX = ".gz";

    private static ThreadLocal<SimpleDateFormat> threadLocalDateFormat(final String pattern) {
        ThreadLocal<SimpleDateFormat> tl = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat df = new SimpleDateFormat(pattern);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                return df;
            }
        };
        return tl;
    }

    public static String get17DigitDate() {
        return TIMESTAMP17.get().format(new Date());
    }

    public static synchronized String getUnique17DigitDate() {
        long effectiveNow = System.currentTimeMillis();
        effectiveNow = Math.max(effectiveNow, LAST_UNIQUE_NOW17 + 1L);
        String candidate = ArchiveUtils.get17DigitDate(effectiveNow);
        while (candidate.equals(LAST_TIMESTAMP17)) {
            candidate = ArchiveUtils.get17DigitDate(++effectiveNow);
        }
        LAST_UNIQUE_NOW17 = effectiveNow;
        LAST_TIMESTAMP17 = candidate;
        return candidate;
    }

    public static String get14DigitDate() {
        return TIMESTAMP14.get().format(new Date());
    }

    public static synchronized String getUnique14DigitDate() {
        long effectiveNow = System.currentTimeMillis();
        effectiveNow = Math.max(effectiveNow, LAST_UNIQUE_NOW14 + 1L);
        String candidate = ArchiveUtils.get14DigitDate(effectiveNow);
        while (candidate.equals(LAST_TIMESTAMP14)) {
            candidate = ArchiveUtils.get14DigitDate(effectiveNow += 1000L);
        }
        LAST_UNIQUE_NOW14 = effectiveNow;
        LAST_TIMESTAMP14 = candidate;
        return candidate;
    }

    public static String get12DigitDate() {
        return TIMESTAMP12.get().format(new Date());
    }

    public static String getLog17Date() {
        return TIMESTAMP17ISO8601Z.get().format(new Date());
    }

    public static String getLog17Date(long date) {
        return TIMESTAMP17ISO8601Z.get().format(new Date(date));
    }

    public static String getLog14Date() {
        return TIMESTAMP14ISO8601Z.get().format(new Date());
    }

    public static String getLog14Date(long date) {
        return TIMESTAMP14ISO8601Z.get().format(new Date(date));
    }

    public static String getLog14Date(Date date) {
        return TIMESTAMP14ISO8601Z.get().format(date);
    }

    public static Date parse14DigitISODate(String datetime, Date defaultVal) {
        try {
            return TIMESTAMP14ISO8601Z.get().parse(datetime);
        }
        catch (ParseException e) {
            return defaultVal;
        }
    }

    public static String get17DigitDate(long date) {
        return TIMESTAMP17.get().format(new Date(date));
    }

    public static String get17DigitDate(Date date) {
        return TIMESTAMP17.get().format(date);
    }

    public static String get14DigitDate(long date) {
        return TIMESTAMP14.get().format(new Date(date));
    }

    public static String get14DigitDate(Date d) {
        return TIMESTAMP14.get().format(d);
    }

    public static String get12DigitDate(long date) {
        return TIMESTAMP12.get().format(new Date(date));
    }

    public static String get12DigitDate(Date d) {
        return TIMESTAMP12.get().format(d);
    }

    public static Date getDate(String d, Date defaultDate) {
        if (d == null) {
            return defaultDate;
        }
        try {
            return ArchiveUtils.getDate(d);
        }
        catch (ParseException pe) {
            return defaultDate;
        }
    }

    public static Date getDate(String d) throws ParseException {
        Date date = null;
        if (d == null) {
            throw new IllegalArgumentException("Passed date is null");
        }
        switch (d.length()) {
            case 14: {
                date = ArchiveUtils.parse14DigitDate(d);
                break;
            }
            case 17: {
                date = ArchiveUtils.parse17DigitDate(d);
                break;
            }
            case 12: {
                date = ArchiveUtils.parse12DigitDate(d);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                throw new ParseException("Date string must at least contain ayear: " + d, d.length());
            }
            default: {
                if (!d.startsWith("19") && !d.startsWith("20")) {
                    throw new ParseException("Unrecognized century: " + d, 0);
                }
                if (d.length() < 8 && d.length() % 2 != 0) {
                    throw new ParseException("Incomplete month/date: " + d, d.length());
                }
                StringBuilder sb = new StringBuilder(d);
                while (sb.length() < 8) {
                    sb.append("01");
                }
                while (sb.length() < 12) {
                    sb.append("0");
                }
                date = ArchiveUtils.parse12DigitDate(sb.toString());
            }
        }
        return date;
    }

    public static String dateToTimestamp(String input) {
        Date date = null;
        if (input.isEmpty()) {
            return null;
        }
        for (SimpleDateFormat format : dateToTimestampFormats) {
            try {
                date = format.parse(input);
                break;
            }
            catch (ParseException e) {
            }
        }
        if (date == null) {
            return null;
        }
        return ArchiveUtils.get14DigitDate(date);
    }

    public static Date parse17DigitDate(String date) throws ParseException {
        return TIMESTAMP17.get().parse(date);
    }

    public static Date parse14DigitDate(String date) throws ParseException {
        return TIMESTAMP14.get().parse(date);
    }

    public static Date parse12DigitDate(String date) throws ParseException {
        return TIMESTAMP12.get().parse(date);
    }

    public static String secondsSinceEpoch(String timestamp) throws ParseException {
        return ArchiveUtils.zeroPadInteger((int)(ArchiveUtils.getSecondsSinceEpoch(timestamp).getTime() / 1000L));
    }

    public static Date getSecondsSinceEpoch(String timestamp) throws ParseException {
        if (timestamp.length() < 14) {
            if (timestamp.length() < 10 && timestamp.length() % 2 == 1) {
                throw new IllegalArgumentException("Must have year, month, date, hour or second granularity: " + timestamp);
            }
            if (timestamp.length() == 4) {
                timestamp = timestamp + "01010000";
            }
            if (timestamp.length() == 6) {
                timestamp = timestamp + "010000";
            }
            if (timestamp.length() < 14) {
                timestamp = timestamp + ArchiveUtils.padTo("", 14 - timestamp.length(), '0');
            }
        }
        return ArchiveUtils.parse14DigitDate(timestamp);
    }

    public static String zeroPadInteger(int i) {
        return ArchiveUtils.padTo(Integer.toString(i), MAX_INT_CHAR_WIDTH, '0');
    }

    public static String padTo(int i, int pad) {
        String n = Integer.toString(i);
        return ArchiveUtils.padTo(n, pad);
    }

    public static String padTo(String s, int pad) {
        return ArchiveUtils.padTo(s, pad, ' ');
    }

    public static String padTo(String s, int pad, char padChar) {
        String result = s;
        int l = s.length();
        if (l < pad) {
            StringBuffer sb = new StringBuffer(pad);
            while (l < pad) {
                sb.append(padChar);
                ++l;
            }
            sb.append(s);
            result = sb.toString();
        }
        return result;
    }

    public static boolean byteArrayEquals(byte[] lhs, byte[] rhs) {
        if (lhs == null && rhs != null || lhs != null && rhs == null) {
            return false;
        }
        if (lhs == rhs) {
            return true;
        }
        if (lhs.length != rhs.length) {
            return false;
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (lhs[i] == rhs[i]) continue;
            return false;
        }
        return true;
    }

    public static String doubleToString(double val, int maxFractionDigits) {
        return ArchiveUtils.doubleToString(val, maxFractionDigits, 0);
    }

    public static String doubleToString(double val, int maxFractionDigits, int minFractionDigits) {
        if (Double.isNaN(val)) {
            return "NaN";
        }
        NumberFormat f = NumberFormat.getNumberInstance(Locale.US);
        f.setMaximumFractionDigits(maxFractionDigits);
        f.setMinimumFractionDigits(minFractionDigits);
        return f.format(val);
    }

    public static String formatBytesForDisplay(long amount) {
        int unitPowerOf1024;
        double displayAmount = amount;
        if (amount <= 0L) {
            return "0 B";
        }
        String[] units = new String[]{" B", " KiB", " MiB", " GiB", " TiB"};
        for (unitPowerOf1024 = 0; displayAmount >= 1024.0 && unitPowerOf1024 < units.length - 1; displayAmount /= 1024.0, ++unitPowerOf1024) {
        }
        int fractionDigits = unitPowerOf1024 == 0 || displayAmount >= 10.0 ? 0 : 1;
        return ArchiveUtils.doubleToString(displayAmount, fractionDigits, fractionDigits) + units[unitPowerOf1024];
    }

    public static String formatMillisecondsToConventional(long time) {
        return ArchiveUtils.formatMillisecondsToConventional(time, 5);
    }

    public static String formatMillisecondsToConventional(long duration, int unitCount) {
        if (unitCount <= 0) {
            unitCount = 5;
        }
        if (duration == 0L) {
            return "0ms";
        }
        StringBuffer sb = new StringBuffer();
        if (duration < 0L) {
            sb.append("-");
        }
        long absTime = Math.abs(duration);
        long[] thresholds = new long[]{86400000L, 3600000L, 60000L, 1000L, 1L};
        String[] units = new String[]{"d", "h", "m", "s", "ms"};
        for (int i = 0; i < thresholds.length; ++i) {
            if (absTime >= thresholds[i]) {
                sb.append(absTime / thresholds[i] + units[i]);
                absTime %= thresholds[i];
                --unitCount;
            }
            if (unitCount == 0) break;
        }
        return sb.toString();
    }

    public static void longIntoByteArray(long l, byte[] array, int offset) {
        int i = 0;
        int shift = 56;
        while (i < 8) {
            array[offset + i] = (byte)(0xFFL & l >> shift);
            ++i;
            shift -= 8;
        }
    }

    public static long byteArrayIntoLong(byte[] bytearray) {
        return ArchiveUtils.byteArrayIntoLong(bytearray, 0);
    }

    public static long byteArrayIntoLong(byte[] bytearray, int offset) {
        long result = 0L;
        for (int i = offset; i < 8; ++i) {
            result = result << 8 | (long)(0xFF & (byte)(bytearray[i] & 0xFF));
        }
        return result;
    }

    public static String addImpliedHttpIfNecessary(String u) {
        int colon = u.indexOf(58);
        int period = u.indexOf(46);
        if (colon == -1 || period >= 0 && period < colon) {
            u = "http://" + u;
        }
        return u;
    }

    public static boolean startsWith(byte[] array, byte[] prefix) {
        if (prefix.length > array.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (array[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public static String prettyString(Object obj) {
        if (obj instanceof Object[]) {
            return ArchiveUtils.prettyString((Object[])obj);
        }
        if (obj instanceof Map) {
            return ArchiveUtils.prettyString((Map)obj);
        }
        return "<" + obj + ">";
    }

    public static String prettyString(Map<?, ?> map) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        boolean needsComma = false;
        for (Object key : map.keySet()) {
            if (needsComma) {
                builder.append(", ");
            }
            builder.append(key);
            builder.append(": ");
            builder.append(ArchiveUtils.prettyString(map.get(key)));
            needsComma = true;
        }
        builder.append(" }");
        return builder.toString();
    }

    public static String prettyString(Object[] array) {
        StringBuilder builder = new StringBuilder();
        builder.append("[ ");
        boolean needsComma = false;
        for (Object o : array) {
            if (o == null) continue;
            if (needsComma) {
                builder.append(", ");
            }
            builder.append(ArchiveUtils.prettyString(o));
            needsComma = true;
        }
        builder.append(" ]");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadVersion() {
        String timestamp;
        String version;
        InputStream input = ArchiveUtils.class.getResourceAsStream("/org/archive/util/version.txt");
        if (input == null) {
            return "UNKNOWN";
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(input));
            version = br.readLine();
            br.readLine();
        }
        catch (IOException e) {
            String string;
            try {
                string = e.getMessage();
            }
            catch (Throwable throwable) {
                ArchiveUtils.closeQuietly(br);
                throw throwable;
            }
            ArchiveUtils.closeQuietly(br);
            return string;
        }
        ArchiveUtils.closeQuietly(br);
        version = version.trim();
        if (!version.endsWith("SNAPSHOT")) {
            return version;
        }
        input = ArchiveUtils.class.getResourceAsStream("/org/archive/util/timestamp.txt");
        if (input == null) {
            return version;
        }
        br = null;
        try {
            br = new BufferedReader(new InputStreamReader(input));
            timestamp = br.readLine();
        }
        catch (IOException e) {
            String string = version;
            return string;
        }
        finally {
            ArchiveUtils.closeQuietly(br);
        }
        if (timestamp.startsWith("timestamp=")) {
            timestamp = timestamp.substring(10);
        }
        return version.trim() + "-" + timestamp.trim();
    }

    public static boolean isTld(String dom) {
        return TLDS.contains(dom.toLowerCase());
    }

    public static void closeQuietly(Object input) {
        if (input == null || !(input instanceof Closeable)) {
            return;
        }
        try {
            ((Closeable)input).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void continueCheck() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException("interrupt detected");
        }
    }

    public static int readFully(InputStream input, byte[] buf) throws IOException {
        int ofs;
        int l;
        int max = buf.length;
        for (ofs = 0; ofs < max; ofs += l) {
            l = input.read(buf, ofs, max - ofs);
            if (l != 0) continue;
            throw new EOFException();
        }
        return ofs;
    }

    public static BufferedReader getBufferedReader(File source) throws IOException {
        FilterInputStream is = new BufferedInputStream(new FileInputStream(source));
        boolean isGzipped = source.getName().toLowerCase().endsWith(GZIP_SUFFIX);
        if (isGzipped) {
            is = new GZIPInputStream(is);
        }
        return new BufferedReader(new InputStreamReader(is));
    }

    public static BufferedReader getBufferedReader(URL source) throws IOException {
        URLConnection conn = source.openConnection();
        boolean isGzipped = conn.getContentType() != null && conn.getContentType().equalsIgnoreCase("application/x-gzip") || conn.getContentEncoding() != null && conn.getContentEncoding().equalsIgnoreCase("gzip");
        InputStream uis = conn.getInputStream();
        return new BufferedReader(isGzipped ? new InputStreamReader(new GZIPInputStream(uis)) : new InputStreamReader(uis));
    }

    public static byte[] gzip(byte[] bytes) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipOS = new GZIPOutputStream(baos);
        gzipOS.write(bytes, 0, bytes.length);
        gzipOS.close();
        return baos.toByteArray();
    }

    public static boolean isGzipped(InputStream is) throws IOException {
        try {
            new GZIPDecoder().parseHeader(is);
            return true;
        }
        catch (GZIPFormatException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream is = ArchiveUtils.class.getResourceAsStream("tlds-alpha-by-domain.txt");
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                TLDS.add(line.trim().toLowerCase());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "TLD list unavailable", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

