/*
 * Decompiled with CFR 0.152.
 */
package org.archive.resource.http;

import com.google.common.io.CountingInputStream;
import com.google.common.io.LimitInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;
import org.archive.format.http.HttpHeader;
import org.archive.format.http.HttpResponse;
import org.archive.format.http.HttpResponseMessage;
import org.archive.resource.AbstractResource;
import org.archive.resource.MetaData;
import org.archive.resource.ResourceConstants;
import org.archive.resource.ResourceContainer;
import org.archive.util.Base32;
import org.archive.util.StreamCopy;
import org.archive.util.io.EOFNotifyingInputStream;
import org.archive.util.io.EOFObserver;

public class HTTPResponseResource
extends AbstractResource
implements ResourceConstants,
EOFObserver {
    private static final Logger LOG = Logger.getLogger(HTTPResponseResource.class.getName());
    CountingInputStream countingIS;
    private HttpResponse response;
    DigestInputStream digIS;

    public HTTPResponseResource(MetaData metaData, ResourceContainer container, HttpResponse response) {
        this(metaData, container, response, false);
    }

    public HTTPResponseResource(MetaData metaData, ResourceContainer container, HttpResponse response, boolean forceCheck) {
        super(metaData, container);
        this.response = response;
        MetaData message = metaData.createChild("Response-Message");
        HttpResponseMessage httpMess = response.getMessage();
        message.putLong("Status", httpMess.getStatus());
        message.putString("Version", httpMess.getVersionString());
        message.putString("Reason", httpMess.getReason());
        metaData.putLong("Headers-Length", response.getHeaderBytes());
        if (response.getHeaders().isCorrupt()) {
            metaData.putBoolean("Headers-Corrupt", true);
        }
        MetaData headers = metaData.createChild("Headers");
        long length = response.getHeaders().getContentLength();
        for (HttpHeader h : response.getHeaders()) {
            headers.putString(h.getName(), h.getValue());
        }
        if (forceCheck && length >= 0L) {
            LimitInputStream lis = new LimitInputStream((InputStream)response, length);
            this.countingIS = new CountingInputStream((InputStream)lis);
        } else {
            this.countingIS = new CountingInputStream((InputStream)response);
        }
        try {
            this.digIS = new DigestInputStream((InputStream)this.countingIS, MessageDigest.getInstance("sha1"));
        }
        catch (NoSuchAlgorithmException e) {
            LOG.severe(e.getMessage());
        }
    }

    public HttpResponse getHttpResponse() {
        return this.response;
    }

    @Override
    public InputStream getInputStream() {
        return new EOFNotifyingInputStream(this.digIS, this);
    }

    @Override
    public void notifyEOF() throws IOException {
        this.metaData.putLong("Entity-Length", this.countingIS.getCount());
        String digString = Base32.encode(this.digIS.getMessageDigest().digest());
        this.metaData.putString("Entity-Digest", "sha1:" + digString);
        this.metaData.putLong("Entity-Trailing-Slop-Bytes", StreamCopy.readToEOF(this.response));
    }
}

