/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io.arc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderGroup;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.archive.io.ArchiveRecord;
import org.archive.io.arc.ARCReader;
import org.archive.io.arc.ARCReaderFactory;
import org.archive.io.arc.ARCRecord;
import org.archive.io.arc.ARCRecordMetaData;
import org.archive.util.ArchiveUtils;
import org.archive.util.SURT;

public class ARC2WCDX {
    public static final String WCDX_VERSION = "0.1";

    public static void main(String[] args) throws IOException {
        String arcFilename = args[0];
        ARC2WCDX.createWcdx(arcFilename);
    }

    public static Object[] createWcdx(String arcFilename) throws IOException {
        ARCReader reader = ARCReaderFactory.get(arcFilename);
        Object[] retVal = ARC2WCDX.createWcdx(reader);
        reader.close();
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] createWcdx(ARCReader reader) {
        long count;
        String wcdxPath;
        block14: {
            reader.setDigest(true);
            wcdxPath = reader.getReaderIdentifier().replaceAll("\\.arc(\\.gz)?$", ".wcdx.gz");
            File wcdxFile = new File(wcdxPath + ".open");
            PrintStream writer = null;
            count = 0L;
            try {
                writer = new PrintStream(new GZIPOutputStream(new FileOutputStream(wcdxFile)));
                StringBuilder legend = new StringBuilder();
                ARC2WCDX.appendField(legend, "CDX");
                ARC2WCDX.appendField(legend, "surt-uri");
                ARC2WCDX.appendField(legend, "b");
                ARC2WCDX.appendField(legend, "http-date");
                ARC2WCDX.appendField(legend, "s");
                ARC2WCDX.appendField(legend, "m");
                ARC2WCDX.appendField(legend, "sha1");
                ARC2WCDX.appendField(legend, "g");
                ARC2WCDX.appendField(legend, "V");
                ARC2WCDX.appendField(legend, "end-offset");
                ARC2WCDX.appendField(legend, "n");
                ARC2WCDX.appendField(legend, "http-content-length");
                ARC2WCDX.appendField(legend, "http-last-modified");
                ARC2WCDX.appendField(legend, "http-expires");
                ARC2WCDX.appendField(legend, "http-etag");
                ARC2WCDX.appendField(legend, "http-location");
                ARC2WCDX.appendField(legend, "e");
                ARC2WCDX.appendField(legend, "a");
                ARC2WCDX.appendField(legend, "0.1@" + ArchiveUtils.get14DigitDate());
                writer.println(legend.toString());
                Iterator<ArchiveRecord> iter = reader.iterator();
                count = 0L;
                while (iter.hasNext()) {
                    ARCRecord record = (ARCRecord)iter.next();
                    record.close();
                    ARCRecordMetaData h = (ARCRecordMetaData)record.getHeader();
                    Header[] httpHeaders = record.getHttpHeaders();
                    if (httpHeaders == null) {
                        httpHeaders = new Header[]{};
                    }
                    HeaderGroup hg = new HeaderGroup();
                    hg.setHeaders(httpHeaders);
                    StringBuilder builder = new StringBuilder();
                    ARC2WCDX.appendField(builder, SURT.fromURI(h.getUrl()));
                    ARC2WCDX.appendField(builder, h.getDate());
                    ARC2WCDX.appendTimeField(builder, hg.getFirstHeader("Date"));
                    ARC2WCDX.appendField(builder, h.getStatusCode());
                    ARC2WCDX.appendField(builder, h.getMimetype());
                    ARC2WCDX.appendField(builder, record.getDigestStr());
                    ARC2WCDX.appendField(builder, reader.getFileName());
                    ARC2WCDX.appendField(builder, h.getOffset());
                    ARC2WCDX.appendField(builder, "-");
                    ARC2WCDX.appendField(builder, h.getLength());
                    ARC2WCDX.appendField(builder, hg.getFirstHeader("Content-Length"));
                    ARC2WCDX.appendTimeField(builder, hg.getFirstHeader("Last-Modified"));
                    ARC2WCDX.appendTimeField(builder, hg.getFirstHeader("Expires"));
                    ARC2WCDX.appendField(builder, hg.getFirstHeader("ETag"));
                    ARC2WCDX.appendField(builder, hg.getFirstHeader("Location"));
                    ARC2WCDX.appendField(builder, h.getIp());
                    ARC2WCDX.appendField(builder, h.getUrl());
                    writer.println(builder.toString());
                    ++count;
                }
                wcdxFile.renameTo(new File(wcdxPath));
            }
            catch (IOException e) {
                if (wcdxFile.exists()) break block14;
                try {
                    wcdxFile.createNewFile();
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            }
            catch (RuntimeException e) {
                if (wcdxFile.exists()) break block14;
                try {
                    wcdxFile.createNewFile();
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        return new Object[]{wcdxPath, count};
    }

    protected static void appendField(StringBuilder builder, Object obj) {
        if (builder.length() > 0) {
            builder.append(' ');
        }
        if (obj instanceof Header) {
            obj = ((Header)obj).getValue().trim();
        }
        builder.append(obj == null || obj.toString().length() == 0 ? "-" : obj);
    }

    protected static void appendTimeField(StringBuilder builder, Object obj) {
        if (builder.length() > 0) {
            builder.append(' ');
        }
        if (obj == null) {
            builder.append("-");
            return;
        }
        if (obj instanceof Header) {
            String s = ((Header)obj).getValue().trim();
            try {
                Date date = DateUtil.parseDate((String)s);
                String d = ArchiveUtils.get14DigitDate(date);
                if (d.startsWith("209")) {
                    d = "199" + d.substring(3);
                }
                obj = d;
            }
            catch (DateParseException e) {
                builder.append('e');
                return;
            }
        }
        builder.append(obj);
    }
}

