/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.IOException;
import org.archive.io.SeekInputStream;

public class BufferedSeekInputStream
extends SeekInputStream {
    private final SeekInputStream input;
    private final byte[] buffer;
    private int maxOffset;
    private int offset;

    public BufferedSeekInputStream(SeekInputStream input, int capacity) throws IOException {
        this.input = input;
        this.buffer = new byte[capacity];
        this.buffer();
    }

    private void buffer() throws IOException {
        int r;
        for (int remaining = this.buffer.length; remaining > 0; remaining -= r) {
            r = this.input.read(this.buffer, this.buffer.length - remaining, remaining);
            if (r > 0) continue;
            this.offset = 0;
            this.maxOffset = this.buffer.length - remaining;
            return;
        }
        this.maxOffset = this.buffer.length;
        this.offset = 0;
    }

    private void ensureBuffer() throws IOException {
        if (this.offset >= this.maxOffset) {
            this.buffer();
        }
    }

    private int remaining() {
        return this.maxOffset - this.offset;
    }

    @Override
    public int read() throws IOException {
        this.ensureBuffer();
        if (this.maxOffset == 0) {
            return -1;
        }
        int ch = this.buffer[this.offset] & 0xFF;
        ++this.offset;
        return ch;
    }

    @Override
    public int read(byte[] buf, int ofs, int len) throws IOException {
        this.ensureBuffer();
        if (this.maxOffset == 0) {
            return 0;
        }
        len = Math.min(len, this.remaining());
        System.arraycopy(this.buffer, this.offset, buf, ofs, len);
        this.offset += len;
        return len;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public long skip(long c) throws IOException {
        this.ensureBuffer();
        if (this.maxOffset == 0) {
            return 0L;
        }
        int count = c > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)c;
        int skip = Math.min(count, this.remaining());
        this.offset += skip;
        return skip;
    }

    public long position() throws IOException {
        return this.input.position() - (long)this.buffer.length + (long)this.offset;
    }

    public void position(long p) throws IOException {
        long blockStart = (this.input.position() - (long)this.maxOffset) / (long)this.buffer.length * (long)this.buffer.length;
        long blockEnd = blockStart + (long)this.maxOffset;
        if (p >= blockStart && p < blockEnd) {
            long adj = p - blockStart;
            this.offset = (int)adj;
            return;
        }
        this.positionDirect(p);
    }

    private void positionDirect(long p) throws IOException {
        long newBlockStart = p / (long)this.buffer.length * (long)this.buffer.length;
        this.input.position(newBlockStart);
        this.buffer();
        this.offset = (int)(p % (long)this.buffer.length);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.input != null) {
            this.input.close();
        }
    }
}

