/*
 * Decompiled with CFR 0.152.
 */
package org.archive.hadoop.func;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.Tuple;

public class URLResolverFunc
extends EvalFunc<String> {
    private static final Logger LOG = Logger.getLogger(URLResolverFunc.class.getName());
    private URL baseURL = null;
    private String lastBase = null;

    private boolean isAbsolute(String url) {
        return url.startsWith("http://") || url.startsWith("https://") || url.startsWith("ftp://") || url.startsWith("feed://") || url.startsWith("mailto:") || url.startsWith("mail:") || url.startsWith("javascript:") || url.startsWith("rtsp://");
    }

    private String resolve(String base, String rel) {
        URL absURL = null;
        if (this.lastBase != null && this.lastBase.equals(base)) {
            try {
                absURL = new URL(this.baseURL, rel);
            }
            catch (MalformedURLException e) {
                LOG.warning("Malformed rel url:" + rel);
                return null;
            }
        }
        if (absURL == null) {
            try {
                this.baseURL = new URL(base);
                this.lastBase = base;
            }
            catch (MalformedURLException e) {
                LOG.warning("Malformed base url:" + base);
                return null;
            }
            try {
                absURL = new URL(this.baseURL, rel);
            }
            catch (MalformedURLException e) {
                LOG.warning("Malformed rel url:" + rel);
                return null;
            }
        }
        return absURL.toString();
    }

    public String doResolve(String page, String base, String url) {
        String tmp;
        if (url == null || url.length() == 0) {
            return null;
        }
        if (this.isAbsolute(url)) {
            return url;
        }
        if (base != null && base.length() > 0 && (tmp = this.resolve(base, url)) != null) {
            return tmp;
        }
        if (page != null && page.length() > 0 && (tmp = this.resolve(page, url)) != null) {
            return tmp;
        }
        return url;
    }

    private static String NToStr(Object o) {
        return o == null ? null : o.toString();
    }

    public String exec(Tuple tup) throws IOException {
        if (tup == null || tup.size() != 3) {
            return null;
        }
        return this.doResolve(URLResolverFunc.NToStr(tup.get(0)), URLResolverFunc.NToStr(tup.get(1)), URLResolverFunc.NToStr(tup.get(2)));
    }
}

