/*
 * Decompiled with CFR 0.152.
 */
package org.archive.extract;

import com.google.common.io.CountingOutputStream;
import com.google.common.io.NullOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Logger;
import org.archive.extract.ExtractorOutput;
import org.archive.resource.Resource;
import org.archive.util.StreamCopy;
import org.json.JSONException;

public class DumpingExtractorOutput
implements ExtractorOutput {
    private static final Logger LOG = Logger.getLogger(DumpingExtractorOutput.class.getName());
    private PrintStream out;

    public DumpingExtractorOutput(OutputStream out) {
        this.out = new PrintStream(out);
    }

    @Override
    public void output(Resource resource) throws IOException {
        NullOutputStream nullo = new NullOutputStream();
        CountingOutputStream co = new CountingOutputStream((OutputStream)nullo);
        StreamCopy.copy(resource.getInputStream(), (OutputStream)co);
        long bytes = co.getCount();
        if (bytes > 0L) {
            LOG.info(bytes + " unconsumed bytes in Resource InputStream.");
        }
        try {
            this.out.println(resource.getMetaData().getTopMetaData().toString(1));
        }
        catch (JSONException e) {
            LOG.warning(e.getMessage());
        }
    }
}

