/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.test.corpus;

import com.hankcs.hanlp.corpus.dictionary.DictionaryMaker;
import com.hankcs.hanlp.corpus.dictionary.EasyDictionary;
import com.hankcs.hanlp.corpus.dictionary.item.Item;
import com.hankcs.hanlp.corpus.document.CorpusLoader;
import com.hankcs.hanlp.corpus.document.Document;
import com.hankcs.hanlp.corpus.document.sentence.word.CompoundWord;
import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.TestCase;

public class TestDictionaryMaker
extends TestCase {
    public void testSingleDocument() throws Exception {
        Document document = CorpusLoader.convert2Document(new File("data/2014/0101/c1002-23996898.txt"));
        DictionaryMaker dictionaryMaker = new DictionaryMaker();
        System.out.println(document);
        this.addToDictionary(document, dictionaryMaker);
        dictionaryMaker.saveTxtTo("data/dictionaryTest.txt");
    }

    private void addToDictionary(Document document, DictionaryMaker dictionaryMaker) {
        for (IWord word : document.getWordList()) {
            if (word instanceof CompoundWord) {
                for (Word inner : ((CompoundWord)word).innerList) {
                    if (inner.getLabel().equals("nr")) continue;
                    dictionaryMaker.add(inner);
                }
            }
            if (word.getLabel().equals("nr")) continue;
            dictionaryMaker.add(word);
        }
    }

    public void testMakeDictionary() throws Exception {
        final DictionaryMaker dictionaryMaker = new DictionaryMaker();
        CorpusLoader.walk("data/2014", new CorpusLoader.Handler(){

            @Override
            public void handle(Document document) {
                TestDictionaryMaker.this.addToDictionary(document, dictionaryMaker);
            }
        });
        dictionaryMaker.saveTxtTo("data/2014_dictionary.txt");
    }

    public void testLoadItemList() throws Exception {
        List<Item> itemList = DictionaryMaker.loadAsItemList("data/2014_dictionary.txt");
        TreeMap<String, Integer> labelMap = new TreeMap<String, Integer>();
        for (Item item : itemList) {
            for (Map.Entry entry : item.labelMap.entrySet()) {
                Integer frequency = (Integer)labelMap.get(entry.getKey());
                if (frequency == null) {
                    frequency = 0;
                }
                labelMap.put((String)entry.getKey(), frequency + (Integer)entry.getValue());
            }
        }
        for (String label : labelMap.keySet()) {
            System.out.println(label);
        }
        System.out.println(labelMap.size());
    }

    public void testLoadEasyDictionary() throws Exception {
        EasyDictionary dictionary = EasyDictionary.create("data/2014_dictionary.txt");
        System.out.println(dictionary.GetWordInfo("\u9ad8\u5cf0"));
    }
}

