/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.common;

import com.hankcs.hanlp.seg.common.EdgeFrom;
import com.hankcs.hanlp.seg.common.Vertex;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class Graph {
    public Vertex[] vertexes;
    public List<EdgeFrom>[] edgesTo;

    public Graph(Vertex[] vertexes) {
        int size = vertexes.length;
        this.vertexes = vertexes;
        this.edgesTo = new List[size];
        int i = 0;
        while (i < size) {
            this.edgesTo[i] = new LinkedList<EdgeFrom>();
            ++i;
        }
    }

    public void connect(int from, int to, double weight) {
        this.edgesTo[to].add(new EdgeFrom(from, weight, String.valueOf(this.vertexes[from].word) + '@' + this.vertexes[to].word));
    }

    public List<EdgeFrom> getEdgeListTo(int to) {
        return this.edgesTo[to];
    }

    public String toString() {
        return "Graph{vertexes=" + Arrays.toString(this.vertexes) + ", edgesTo=" + Arrays.toString(this.edgesTo) + '}';
    }

    public String printByTo() {
        StringBuffer sb = new StringBuffer();
        sb.append("========\u6309\u7ec8\u70b9\u6253\u5370========\n");
        int to = 0;
        while (to < this.edgesTo.length) {
            List<EdgeFrom> edgeFromList = this.edgesTo[to];
            for (EdgeFrom edgeFrom : edgeFromList) {
                sb.append(String.format("to:%3d, from:%3d, weight:%05.2f, word:%s\n", to, edgeFrom.from, edgeFrom.weight, edgeFrom.name));
            }
            ++to;
        }
        return sb.toString();
    }

    public List<Vertex> parsePath(int[] path) {
        LinkedList<Vertex> vertexList = new LinkedList<Vertex>();
        int[] nArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            vertexList.add(this.vertexes[i]);
            ++n2;
        }
        return vertexList;
    }

    public static String parseResult(List<Vertex> path) {
        if (path.size() < 2) {
            throw new RuntimeException("\u8def\u5f84\u8282\u70b9\u6570\u5c0f\u4e8e2:" + path);
        }
        StringBuffer sb = new StringBuffer();
        int i = 1;
        while (i < path.size() - 1) {
            Vertex v = path.get(i);
            sb.append(String.valueOf(v.getRealWord()) + " ");
            ++i;
        }
        return sb.toString();
    }

    public Vertex[] getVertexes() {
        return this.vertexes;
    }

    public List<EdgeFrom>[] getEdgesTo() {
        return this.edgesTo;
    }
}

