/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.py;

import com.hankcs.hanlp.dictionary.py.Pinyin;
import java.util.ArrayList;
import java.util.List;

public class PinyinUtil {
    public static String convertToneNumber2ToneMark(String pinyinStr) {
        String lowerCasePinyinStr = pinyinStr.toLowerCase();
        if (lowerCasePinyinStr.matches("[a-z]*[1-5]?")) {
            int defautlCharValue = 36;
            int defautlIndexValue = -1;
            int unmarkedVowel = 36;
            int indexOfUnmarkedVowel = -1;
            int charA = 97;
            int charE = 101;
            String ouStr = "ou";
            String allUnmarkedVowelStr = "aeiouv";
            String allMarkedVowelStr = "\u0101\u00e1\u01ce\u00e0a\u0113\u00e9\u011b\u00e8e\u012b\u00ed\u01d0\u00eci\u014d\u00f3\u01d2\u00f2o\u016b\u00fa\u01d4\u00f9u\u01d6\u01d8\u01da\u01dc\u00fc";
            if (lowerCasePinyinStr.matches("[a-z]*[1-5]")) {
                int tuneNumber = Character.getNumericValue(lowerCasePinyinStr.charAt(lowerCasePinyinStr.length() - 1));
                int indexOfA = lowerCasePinyinStr.indexOf(97);
                int indexOfE = lowerCasePinyinStr.indexOf(101);
                int ouIndex = lowerCasePinyinStr.indexOf("ou");
                if (-1 != indexOfA) {
                    indexOfUnmarkedVowel = indexOfA;
                    unmarkedVowel = 97;
                } else if (-1 != indexOfE) {
                    indexOfUnmarkedVowel = indexOfE;
                    unmarkedVowel = 101;
                } else if (-1 != ouIndex) {
                    indexOfUnmarkedVowel = ouIndex;
                    unmarkedVowel = "ou".charAt(0);
                } else {
                    int i = lowerCasePinyinStr.length() - 1;
                    while (i >= 0) {
                        if (String.valueOf(lowerCasePinyinStr.charAt(i)).matches("[aeiouv]")) {
                            indexOfUnmarkedVowel = i;
                            unmarkedVowel = lowerCasePinyinStr.charAt(i);
                            break;
                        }
                        --i;
                    }
                }
                if (36 != unmarkedVowel && -1 != indexOfUnmarkedVowel) {
                    int rowIndex = "aeiouv".indexOf(unmarkedVowel);
                    int columnIndex = tuneNumber - 1;
                    int vowelLocation = rowIndex * 5 + columnIndex;
                    char markedVowel = "\u0101\u00e1\u01ce\u00e0a\u0113\u00e9\u011b\u00e8e\u012b\u00ed\u01d0\u00eci\u014d\u00f3\u01d2\u00f2o\u016b\u00fa\u01d4\u00f9u\u01d6\u01d8\u01da\u01dc\u00fc".charAt(vowelLocation);
                    StringBuffer resultBuffer = new StringBuffer();
                    resultBuffer.append(lowerCasePinyinStr.substring(0, indexOfUnmarkedVowel).replaceAll("v", "\u00fc"));
                    resultBuffer.append(markedVowel);
                    resultBuffer.append(lowerCasePinyinStr.substring(indexOfUnmarkedVowel + 1, lowerCasePinyinStr.length() - 1).replaceAll("v", "\u00fc"));
                    return resultBuffer.toString();
                }
                return lowerCasePinyinStr;
            }
            return lowerCasePinyinStr.replaceAll("v", "\u00fc");
        }
        return lowerCasePinyinStr;
    }

    public static Pinyin[] convertList2Array(List<Pinyin> pinyinList) {
        return pinyinList.toArray(new Pinyin[0]);
    }

    public static Pinyin removeTone(Pinyin p) {
        return Pinyin.none5;
    }

    public static List<String> convertPinyinList2TonePinyinList(List<Pinyin> pinyinList) {
        ArrayList<String> tonePinyinList = new ArrayList<String>(pinyinList.size());
        for (Pinyin pinyin : pinyinList) {
            tonePinyinList.add(pinyin.getPinyinWithToneMark());
        }
        return tonePinyinList;
    }
}

