/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.nnparser;

import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.ICacheAble;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;

public class Matrix
implements Cloneable,
Serializable,
ICacheAble {
    private double[][] A;
    private int m;
    private int n;
    private static final long serialVersionUID = 1L;

    public Matrix(int m, int n) {
        this.m = m;
        this.n = n;
        this.A = new double[m][n];
    }

    public Matrix(int m, int n, double s) {
        this.m = m;
        this.n = n;
        this.A = new double[m][n];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                this.A[i][j] = s;
                ++j;
            }
            ++i;
        }
    }

    public Matrix(double[][] A) {
        this.m = A.length;
        this.n = A[0].length;
        int i = 0;
        while (i < this.m) {
            if (A[i].length != this.n) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            ++i;
        }
        this.A = A;
    }

    public Matrix(double[][] A, int m, int n) {
        this.A = A;
        this.m = m;
        this.n = n;
    }

    public Matrix(double[] vals, int m) {
        this.m = m;
        int n = this.n = m != 0 ? vals.length / m : 0;
        if (m * this.n != vals.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.A = new double[m][this.n];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < this.n) {
                this.A[i][j] = vals[i + j * m];
                ++j;
            }
            ++i;
        }
    }

    public Matrix() {
    }

    public static Matrix constructWithCopy(double[][] A) {
        int m = A.length;
        int n = A[0].length;
        Matrix X = new Matrix(m, n);
        double[][] C = X.getArray();
        int i = 0;
        while (i < m) {
            if (A[i].length != n) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            int j = 0;
            while (j < n) {
                C[i][j] = A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Matrix copy() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Object clone() {
        return this.copy();
    }

    public double[][] getArray() {
        return this.A;
    }

    public double[][] getArrayCopy() {
        double[][] C = new double[this.m][this.n];
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j];
                ++j;
            }
            ++i;
        }
        return C;
    }

    public double[] getColumnPackedCopy() {
        double[] vals = new double[this.m * this.n];
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                vals[i + j * this.m] = this.A[i][j];
                ++j;
            }
            ++i;
        }
        return vals;
    }

    public double[] getRowPackedCopy() {
        double[] vals = new double[this.m * this.n];
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                vals[i * this.n + j] = this.A[i][j];
                ++j;
            }
            ++i;
        }
        return vals;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double get(int i, int j) {
        return this.A[i][j];
    }

    public Matrix getMatrix(int i0, int i1, int j0, int j1) {
        Matrix X = new Matrix(i1 - i0 + 1, j1 - j0 + 1);
        double[][] B = X.getArray();
        try {
            int i = i0;
            while (i <= i1) {
                int j = j0;
                while (j <= j1) {
                    B[i - i0][j - j0] = this.A[i][j];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public Matrix getMatrix(int[] r, int[] c) {
        Matrix X = new Matrix(r.length, c.length);
        double[][] B = X.getArray();
        try {
            int i = 0;
            while (i < r.length) {
                int j = 0;
                while (j < c.length) {
                    B[i][j] = this.A[r[i]][c[j]];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public Matrix getMatrix(int i0, int i1, int[] c) {
        Matrix X = new Matrix(i1 - i0 + 1, c.length);
        double[][] B = X.getArray();
        try {
            int i = i0;
            while (i <= i1) {
                int j = 0;
                while (j < c.length) {
                    B[i - i0][j] = this.A[i][c[j]];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public Matrix getMatrix(int[] r, int j0, int j1) {
        Matrix X = new Matrix(r.length, j1 - j0 + 1);
        double[][] B = X.getArray();
        try {
            int i = 0;
            while (i < r.length) {
                int j = j0;
                while (j <= j1) {
                    B[i][j - j0] = this.A[r[i]][j];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public void set(int i, int j, double s) {
        this.A[i][j] = s;
    }

    public void setMatrix(int i0, int i1, int j0, int j1, Matrix X) {
        try {
            int i = i0;
            while (i <= i1) {
                int j = j0;
                while (j <= j1) {
                    this.A[i][j] = X.get(i - i0, j - j0);
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] r, int[] c, Matrix X) {
        try {
            int i = 0;
            while (i < r.length) {
                int j = 0;
                while (j < c.length) {
                    this.A[r[i]][c[j]] = X.get(i, j);
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] r, int j0, int j1, Matrix X) {
        try {
            int i = 0;
            while (i < r.length) {
                int j = j0;
                while (j <= j1) {
                    this.A[r[i]][j] = X.get(i, j - j0);
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int i0, int i1, int[] c, Matrix X) {
        try {
            int i = i0;
            while (i <= i1) {
                int j = 0;
                while (j < c.length) {
                    this.A[i][c[j]] = X.get(i - i0, j);
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public Matrix transpose() {
        Matrix X = new Matrix(this.n, this.m);
        double[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[j][i] = this.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public double norm1() {
        double f = 0.0;
        int j = 0;
        while (j < this.n) {
            double s = 0.0;
            int i = 0;
            while (i < this.m) {
                s += Math.abs(this.A[i][j]);
                ++i;
            }
            f = Math.max(f, s);
            ++j;
        }
        return f;
    }

    public double normInf() {
        double f = 0.0;
        int i = 0;
        while (i < this.m) {
            double s = 0.0;
            int j = 0;
            while (j < this.n) {
                s += Math.abs(this.A[i][j]);
                ++j;
            }
            f = Math.max(f, s);
            ++i;
        }
        return f;
    }

    public Matrix uminus() {
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = -this.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Matrix plus(Matrix B) {
        this.checkMatrixDimensions(B);
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j] + B.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Matrix plusEquals(Matrix B) {
        this.checkMatrixDimensions(B);
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                this.A[i][j] = this.A[i][j] + B.A[i][j];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public Matrix minus(Matrix B) {
        this.checkMatrixDimensions(B);
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j] - B.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Matrix minusEquals(Matrix B) {
        this.checkMatrixDimensions(B);
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                this.A[i][j] = this.A[i][j] - B.A[i][j];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public Matrix arrayTimes(Matrix B) {
        this.checkMatrixDimensions(B);
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j] * B.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Matrix arrayTimesEquals(Matrix B) {
        this.checkMatrixDimensions(B);
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                this.A[i][j] = this.A[i][j] * B.A[i][j];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public Matrix arrayRightDivide(Matrix B) {
        this.checkMatrixDimensions(B);
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j] / B.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Matrix arrayRightDivideEquals(Matrix B) {
        this.checkMatrixDimensions(B);
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                this.A[i][j] = this.A[i][j] / B.A[i][j];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public Matrix arrayLeftDivide(Matrix B) {
        this.checkMatrixDimensions(B);
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = B.A[i][j] / this.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Matrix arrayLeftDivideEquals(Matrix B) {
        this.checkMatrixDimensions(B);
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                this.A[i][j] = B.A[i][j] / this.A[i][j];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public Matrix times(double s) {
        Matrix X = new Matrix(this.m, this.n);
        double[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = s * this.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public Matrix timesEquals(double s) {
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                this.A[i][j] = s * this.A[i][j];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public Matrix times(Matrix B) {
        if (B.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        Matrix X = new Matrix(this.m, B.n);
        double[][] C = X.getArray();
        double[] Bcolj = new double[this.n];
        int j = 0;
        while (j < B.n) {
            int k = 0;
            while (k < this.n) {
                Bcolj[k] = B.A[k][j];
                ++k;
            }
            int i = 0;
            while (i < this.m) {
                double[] Arowi = this.A[i];
                double s = 0.0;
                int k2 = 0;
                while (k2 < this.n) {
                    s += Arowi[k2] * Bcolj[k2];
                    ++k2;
                }
                C[i][j] = s;
                ++i;
            }
            ++j;
        }
        return X;
    }

    public double trace() {
        double t = 0.0;
        int i = 0;
        while (i < Math.min(this.m, this.n)) {
            t += this.A[i][i];
            ++i;
        }
        return t;
    }

    public static Matrix random(int m, int n) {
        Matrix A = new Matrix(m, n);
        double[][] X = A.getArray();
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                X[i][j] = Math.random();
                ++j;
            }
            ++i;
        }
        return A;
    }

    public static Matrix identity(int m, int n) {
        Matrix A = new Matrix(m, n);
        double[][] X = A.getArray();
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                X[i][j] = i == j ? 1.0 : 0.0;
                ++j;
            }
            ++i;
        }
        return A;
    }

    public void print(int w, int d) {
        this.print(new PrintWriter(System.out, true), w, d);
    }

    public void print(PrintWriter output, int w, int d) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(d);
        format.setMinimumFractionDigits(d);
        format.setGroupingUsed(false);
        this.print(output, format, w + 2);
    }

    public void print(NumberFormat format, int width) {
        this.print(new PrintWriter(System.out, true), format, width);
    }

    public void print(PrintWriter output, NumberFormat format, int width) {
        output.println();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                String s = format.format(this.A[i][j]);
                int padding = Math.max(1, width - s.length());
                int k = 0;
                while (k < padding) {
                    output.print(' ');
                    ++k;
                }
                output.print(s);
                ++j;
            }
            output.println();
            ++i;
        }
        output.println();
    }

    public static Matrix read(BufferedReader input) throws IOException {
        StreamTokenizer tokenizer = new StreamTokenizer(input);
        tokenizer.resetSyntax();
        tokenizer.wordChars(0, 255);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.eolIsSignificant(true);
        Vector<Double> vD = new Vector<Double>();
        while (tokenizer.nextToken() == 10) {
        }
        if (tokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        do {
            vD.addElement(Double.valueOf(tokenizer.sval));
        } while (tokenizer.nextToken() == -3);
        int n = vD.size();
        double[] row = new double[n];
        int j = 0;
        while (j < n) {
            row[j] = (Double)vD.elementAt(j);
            ++j;
        }
        Vector<double[]> v = new Vector<double[]>();
        v.addElement(row);
        while (tokenizer.nextToken() == -3) {
            row = new double[n];
            v.addElement(row);
            int j2 = 0;
            do {
                if (j2 >= n) {
                    throw new IOException("Row " + v.size() + " is too long.");
                }
                row[j2++] = Double.valueOf(tokenizer.sval);
            } while (tokenizer.nextToken() == -3);
            if (j2 >= n) continue;
            throw new IOException("Row " + v.size() + " is too short.");
        }
        int m = v.size();
        double[][] A = new double[m][];
        v.copyInto((Object[])A);
        return new Matrix(A);
    }

    private void checkMatrixDimensions(Matrix B) {
        if (B.m != this.m || B.n != this.n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
    }

    public static Matrix zero(int m, int n) {
        Matrix A = new Matrix(m, n);
        double[][] X = A.getArray();
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                X[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        return A;
    }

    public int rows() {
        return this.getRowDimension();
    }

    public int cols() {
        return this.getColumnDimension();
    }

    public Matrix col(int j) {
        double[][] X = new double[this.m][1];
        int i = 0;
        while (i < this.m) {
            X[i][0] = this.A[i][j];
            ++i;
        }
        return new Matrix(X);
    }

    public Matrix row(int i) {
        double[][] X = new double[1][this.n];
        int j = 0;
        while (j < this.n) {
            X[0][j] = this.A[i][j];
            ++j;
        }
        return new Matrix(X);
    }

    public Matrix block(int i, int j, int p, int q) {
        return this.getMatrix(i, i + p - 1, j, j + q - 1);
    }

    public double[][] cube() {
        double[][] X = new double[this.m][this.n];
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                X[i][j] = Math.pow(this.A[i][j], 3.0);
                ++j;
            }
            ++i;
        }
        return X;
    }

    public void setZero() {
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                this.A[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void save(DataOutputStream out) throws Exception {
        out.writeInt(this.m);
        out.writeInt(this.n);
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                out.writeDouble(this.A[i][j]);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public boolean load(ByteArray byteArray) {
        this.m = byteArray.nextInt();
        this.n = byteArray.nextInt();
        this.A = new double[this.m][this.n];
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                this.A[i][j] = byteArray.nextDouble();
                ++j;
            }
            ++i;
        }
        return true;
    }
}

