/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.nnparser;

import java.util.ArrayList;
import java.util.List;

public class Instance {
    List<String> raw_forms;
    List<String> forms = new ArrayList<String>();
    List<String> lemmas;
    List<String> postags = new ArrayList<String>();
    List<String> cpostags;
    List<Integer> heads;
    List<Integer> deprelsidx;
    List<String> deprels;
    List<Integer> predict_heads;
    List<Integer> predict_deprelsidx;
    List<String> predict_deprels;

    int size() {
        return this.forms.size();
    }

    boolean is_tree() {
        ArrayList<List<Integer>> tree = new ArrayList<List<Integer>>(this.heads.size());
        int root = -1;
        int modifier = 0;
        while (modifier < this.heads.size()) {
            int head = this.heads.get(modifier);
            if (head == -1) {
                root = modifier;
            } else {
                ((List)tree.get(head)).add(modifier);
            }
            ++modifier;
        }
        boolean[] visited = new boolean[this.heads.size()];
        if (!this.is_tree_travel(root, tree, visited)) {
            return false;
        }
        int i = 0;
        while (i < visited.length) {
            boolean visit = visited[i];
            if (!visit) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean is_tree_travel(int now, List<List<Integer>> tree, boolean[] visited) {
        if (visited[now]) {
            return false;
        }
        visited[now] = true;
        int c = 0;
        while (c < tree.get(now).size()) {
            int next = tree.get(now).get(c);
            if (!this.is_tree_travel(next, tree, visited)) {
                return false;
            }
            ++c;
        }
        return true;
    }

    boolean is_projective() {
        return !this.is_non_projective();
    }

    boolean is_non_projective() {
        int modifier = 0;
        while (modifier < this.heads.size()) {
            int to;
            int from;
            int head = this.heads.get(modifier);
            if (head < modifier) {
                from = head + 1;
                while (from < modifier) {
                    to = this.heads.get(from);
                    if (to < head || to > modifier) {
                        return true;
                    }
                    ++from;
                }
            } else {
                from = modifier + 1;
                while (from < head) {
                    to = this.heads.get(from);
                    if (to < modifier || to > head) {
                        return true;
                    }
                    ++from;
                }
            }
            ++modifier;
        }
        return false;
    }
}

